import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_role#id DataGoogleIamRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_role#name DataGoogleIamRole#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_role google_iam_role}
*/
export declare class DataGoogleIamRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iam_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_role google_iam_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIamRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleIamRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get includedPermissions(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get stage(): string;
    get title(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
