import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocMetastoreServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database type that the Metastore service stores its data. Default value: "MYSQL" Possible values: ["MYSQL", "SPANNER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#database_type DataprocMetastoreService#database_type}
    */
    readonly databaseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#id DataprocMetastoreService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the metastore service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#labels DataprocMetastoreService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the metastore service should reside.
  The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#location DataprocMetastoreService#location}
    */
    readonly location?: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
  
  "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#network DataprocMetastoreService#network}
    */
    readonly network?: string;
    /**
    * The TCP port at which the metastore service is reached. Default: 9083.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#port DataprocMetastoreService#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#project DataprocMetastoreService#project}
    */
    readonly project?: string;
    /**
    * The release channel of the service. If unspecified, defaults to 'STABLE'. Default value: "STABLE" Possible values: ["CANARY", "STABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#release_channel DataprocMetastoreService#release_channel}
    */
    readonly releaseChannel?: string;
    /**
    * The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
  and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
  3 and 63 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#service_id DataprocMetastoreService#service_id}
    */
    readonly serviceId: string;
    /**
    * The tier of the service. Possible values: ["DEVELOPER", "ENTERPRISE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#tier DataprocMetastoreService#tier}
    */
    readonly tier?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#encryption_config DataprocMetastoreService#encryption_config}
    */
    readonly encryptionConfig?: DataprocMetastoreServiceEncryptionConfig;
    /**
    * hive_metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#hive_metastore_config DataprocMetastoreService#hive_metastore_config}
    */
    readonly hiveMetastoreConfig?: DataprocMetastoreServiceHiveMetastoreConfig;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#maintenance_window DataprocMetastoreService#maintenance_window}
    */
    readonly maintenanceWindow?: DataprocMetastoreServiceMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#timeouts DataprocMetastoreService#timeouts}
    */
    readonly timeouts?: DataprocMetastoreServiceTimeouts;
}
export interface DataprocMetastoreServiceEncryptionConfig {
    /**
    * The fully qualified customer provided Cloud KMS key name to use for customer data encryption.
  Use the following format: 'projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#kms_key DataprocMetastoreService#kms_key}
    */
    readonly kmsKey: string;
}
export declare function dataprocMetastoreServiceEncryptionConfigToTerraform(struct?: DataprocMetastoreServiceEncryptionConfigOutputReference | DataprocMetastoreServiceEncryptionConfig): any;
export declare class DataprocMetastoreServiceEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceEncryptionConfig | undefined;
    set internalValue(value: DataprocMetastoreServiceEncryptionConfig | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    get kmsKeyInput(): string | undefined;
}
export interface DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab {
    /**
    * The relative resource name of a Secret Manager secret version, in the following form:
  
  "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#cloud_secret DataprocMetastoreService#cloud_secret}
    */
    readonly cloudSecret: string;
}
export declare function dataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabToTerraform(struct?: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference | DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab): any;
export declare class DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined;
    set internalValue(value: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined);
    private _cloudSecret?;
    get cloudSecret(): string;
    set cloudSecret(value: string);
    get cloudSecretInput(): string | undefined;
}
export interface DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig {
    /**
    * A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#krb5_config_gcs_uri DataprocMetastoreService#krb5_config_gcs_uri}
    */
    readonly krb5ConfigGcsUri: string;
    /**
    * A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#principal DataprocMetastoreService#principal}
    */
    readonly principal: string;
    /**
    * keytab block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#keytab DataprocMetastoreService#keytab}
    */
    readonly keytab: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab;
}
export declare function dataprocMetastoreServiceHiveMetastoreConfigKerberosConfigToTerraform(struct?: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference | DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig): any;
export declare class DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined;
    set internalValue(value: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined);
    private _krb5ConfigGcsUri?;
    get krb5ConfigGcsUri(): string;
    set krb5ConfigGcsUri(value: string);
    get krb5ConfigGcsUriInput(): string | undefined;
    private _principal?;
    get principal(): string;
    set principal(value: string);
    get principalInput(): string | undefined;
    private _keytab;
    get keytab(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference;
    putKeytab(value: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab): void;
    get keytabInput(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined;
}
export interface DataprocMetastoreServiceHiveMetastoreConfig {
    /**
    * A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
  The mappings override system defaults (some keys cannot be overridden)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#config_overrides DataprocMetastoreService#config_overrides}
    */
    readonly configOverrides?: {
        [key: string]: string;
    };
    /**
    * The Hive metastore schema version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#version DataprocMetastoreService#version}
    */
    readonly version: string;
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#kerberos_config DataprocMetastoreService#kerberos_config}
    */
    readonly kerberosConfig?: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig;
}
export declare function dataprocMetastoreServiceHiveMetastoreConfigToTerraform(struct?: DataprocMetastoreServiceHiveMetastoreConfigOutputReference | DataprocMetastoreServiceHiveMetastoreConfig): any;
export declare class DataprocMetastoreServiceHiveMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceHiveMetastoreConfig | undefined;
    set internalValue(value: DataprocMetastoreServiceHiveMetastoreConfig | undefined);
    private _configOverrides?;
    get configOverrides(): {
        [key: string]: string;
    };
    set configOverrides(value: {
        [key: string]: string;
    });
    resetConfigOverrides(): void;
    get configOverridesInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _kerberosConfig;
    get kerberosConfig(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig): void;
    resetKerberosConfig(): void;
    get kerberosConfigInput(): DataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined;
}
export interface DataprocMetastoreServiceMaintenanceWindow {
    /**
    * The day of week, when the window starts. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#day_of_week DataprocMetastoreService#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * The hour of day (0-23) when the window starts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#hour_of_day DataprocMetastoreService#hour_of_day}
    */
    readonly hourOfDay: number;
}
export declare function dataprocMetastoreServiceMaintenanceWindowToTerraform(struct?: DataprocMetastoreServiceMaintenanceWindowOutputReference | DataprocMetastoreServiceMaintenanceWindow): any;
export declare class DataprocMetastoreServiceMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceMaintenanceWindow | undefined;
    set internalValue(value: DataprocMetastoreServiceMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _hourOfDay?;
    get hourOfDay(): number;
    set hourOfDay(value: number);
    get hourOfDayInput(): number | undefined;
}
export interface DataprocMetastoreServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#create DataprocMetastoreService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#delete DataprocMetastoreService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service#update DataprocMetastoreService#update}
    */
    readonly update?: string;
}
export declare function dataprocMetastoreServiceTimeoutsToTerraform(struct?: DataprocMetastoreServiceTimeoutsOutputReference | DataprocMetastoreServiceTimeouts | cdktf.IResolvable): any;
export declare class DataprocMetastoreServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocMetastoreServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocMetastoreServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service google_dataproc_metastore_service}
*/
export declare class DataprocMetastoreService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_metastore_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_metastore_service google_dataproc_metastore_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocMetastoreServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataprocMetastoreServiceConfig);
    get artifactGcsUri(): string;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    get endpointUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannel?;
    get releaseChannel(): string;
    set releaseChannel(value: string);
    resetReleaseChannel(): void;
    get releaseChannelInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get state(): string;
    get stateMessage(): string;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    get uid(): string;
    private _encryptionConfig;
    get encryptionConfig(): DataprocMetastoreServiceEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocMetastoreServiceEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocMetastoreServiceEncryptionConfig | undefined;
    private _hiveMetastoreConfig;
    get hiveMetastoreConfig(): DataprocMetastoreServiceHiveMetastoreConfigOutputReference;
    putHiveMetastoreConfig(value: DataprocMetastoreServiceHiveMetastoreConfig): void;
    resetHiveMetastoreConfig(): void;
    get hiveMetastoreConfigInput(): DataprocMetastoreServiceHiveMetastoreConfig | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): DataprocMetastoreServiceMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: DataprocMetastoreServiceMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): DataprocMetastoreServiceMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): DataprocMetastoreServiceTimeoutsOutputReference;
    putTimeouts(value: DataprocMetastoreServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataprocMetastoreServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
