import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatastreamPrivateConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#display_name DatastreamPrivateConnection#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#id DatastreamPrivateConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#labels DatastreamPrivateConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this repository is located in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#location DatastreamPrivateConnection#location}
    */
    readonly location: string;
    /**
    * The private connectivity identifier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#private_connection_id DatastreamPrivateConnection#private_connection_id}
    */
    readonly privateConnectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#project DatastreamPrivateConnection#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#timeouts DatastreamPrivateConnection#timeouts}
    */
    readonly timeouts?: DatastreamPrivateConnectionTimeouts;
    /**
    * vpc_peering_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#vpc_peering_config DatastreamPrivateConnection#vpc_peering_config}
    */
    readonly vpcPeeringConfig: DatastreamPrivateConnectionVpcPeeringConfig;
}
export interface DatastreamPrivateConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#create DatastreamPrivateConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#delete DatastreamPrivateConnection#delete}
    */
    readonly delete?: string;
}
export declare function datastreamPrivateConnectionTimeoutsToTerraform(struct?: DatastreamPrivateConnectionTimeoutsOutputReference | DatastreamPrivateConnectionTimeouts | cdktf.IResolvable): any;
export declare class DatastreamPrivateConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamPrivateConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatastreamPrivateConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface DatastreamPrivateConnectionVpcPeeringConfig {
    /**
    * A free subnet for peering. (CIDR of /29)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#subnet DatastreamPrivateConnection#subnet}
    */
    readonly subnet: string;
    /**
    * Fully qualified name of the VPC that Datastream will peer to.
  Format: projects/{project}/global/{networks}/{name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection#vpc DatastreamPrivateConnection#vpc}
    */
    readonly vpc: string;
}
export declare function datastreamPrivateConnectionVpcPeeringConfigToTerraform(struct?: DatastreamPrivateConnectionVpcPeeringConfigOutputReference | DatastreamPrivateConnectionVpcPeeringConfig): any;
export declare class DatastreamPrivateConnectionVpcPeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamPrivateConnectionVpcPeeringConfig | undefined;
    set internalValue(value: DatastreamPrivateConnectionVpcPeeringConfig | undefined);
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    get subnetInput(): string | undefined;
    private _vpc?;
    get vpc(): string;
    set vpc(value: string);
    get vpcInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection google_datastream_private_connection}
*/
export declare class DatastreamPrivateConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastream_private_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/datastream_private_connection google_datastream_private_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastreamPrivateConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DatastreamPrivateConnectionConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _privateConnectionId?;
    get privateConnectionId(): string;
    set privateConnectionId(value: string);
    get privateConnectionIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): DatastreamPrivateConnectionTimeoutsOutputReference;
    putTimeouts(value: DatastreamPrivateConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatastreamPrivateConnectionTimeouts | undefined;
    private _vpcPeeringConfig;
    get vpcPeeringConfig(): DatastreamPrivateConnectionVpcPeeringConfigOutputReference;
    putVpcPeeringConfig(value: DatastreamPrivateConnectionVpcPeeringConfig): void;
    get vpcPeeringConfigInput(): DatastreamPrivateConnectionVpcPeeringConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
