import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceConsumersIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#consumer_project EndpointsServiceConsumersIamBinding#consumer_project}
    */
    readonly consumerProject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#id EndpointsServiceConsumersIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#members EndpointsServiceConsumersIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#role EndpointsServiceConsumersIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#service_name EndpointsServiceConsumersIamBinding#service_name}
    */
    readonly serviceName: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#condition EndpointsServiceConsumersIamBinding#condition}
    */
    readonly condition?: EndpointsServiceConsumersIamBindingCondition;
}
export interface EndpointsServiceConsumersIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#description EndpointsServiceConsumersIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#expression EndpointsServiceConsumersIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding#title EndpointsServiceConsumersIamBinding#title}
    */
    readonly title: string;
}
export declare function endpointsServiceConsumersIamBindingConditionToTerraform(struct?: EndpointsServiceConsumersIamBindingConditionOutputReference | EndpointsServiceConsumersIamBindingCondition): any;
export declare class EndpointsServiceConsumersIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EndpointsServiceConsumersIamBindingCondition | undefined;
    set internalValue(value: EndpointsServiceConsumersIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding google_endpoints_service_consumers_iam_binding}
*/
export declare class EndpointsServiceConsumersIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_endpoints_service_consumers_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_binding google_endpoints_service_consumers_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceConsumersIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceConsumersIamBindingConfig);
    private _consumerProject?;
    get consumerProject(): string;
    set consumerProject(value: string);
    get consumerProjectInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _condition;
    get condition(): EndpointsServiceConsumersIamBindingConditionOutputReference;
    putCondition(value: EndpointsServiceConsumersIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): EndpointsServiceConsumersIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
