import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FilestoreInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#description FilestoreInstance#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#id FilestoreInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * KMS key name used for data encryption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#kms_key_name FilestoreInstance#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#labels FilestoreInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#location FilestoreInstance#location}
    */
    readonly location?: string;
    /**
    * The resource name of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#name FilestoreInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#project FilestoreInstance#project}
    */
    readonly project?: string;
    /**
    * The service tier of the instance.
  Possible values include: STANDARD, PREMIUM, BASIC_HDD, BASIC_SSD, HIGH_SCALE_SSD and ENTERPRISE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#tier FilestoreInstance#tier}
    */
    readonly tier: string;
    /**
    * The name of the Filestore zone of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#zone FilestoreInstance#zone}
    */
    readonly zone?: string;
    /**
    * file_shares block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#file_shares FilestoreInstance#file_shares}
    */
    readonly fileShares: FilestoreInstanceFileShares;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#networks FilestoreInstance#networks}
    */
    readonly networks: FilestoreInstanceNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#timeouts FilestoreInstance#timeouts}
    */
    readonly timeouts?: FilestoreInstanceTimeouts;
}
export interface FilestoreInstanceFileSharesNfsExportOptions {
    /**
    * Either READ_ONLY, for allowing only read requests on the exported directory,
  or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#access_mode FilestoreInstance#access_mode}
    */
    readonly accessMode?: string;
    /**
    * An integer representing the anonymous group id with a default value of 65534.
  Anon_gid may only be set with squashMode of ROOT_SQUASH. An error will be returned
  if this field is specified for other squashMode settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#anon_gid FilestoreInstance#anon_gid}
    */
    readonly anonGid?: number;
    /**
    * An integer representing the anonymous user id with a default value of 65534.
  Anon_uid may only be set with squashMode of ROOT_SQUASH. An error will be returned
  if this field is specified for other squashMode settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#anon_uid FilestoreInstance#anon_uid}
    */
    readonly anonUid?: number;
    /**
    * List of either IPv4 addresses, or ranges in CIDR notation which may mount the file share.
  Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned.
  The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#ip_ranges FilestoreInstance#ip_ranges}
    */
    readonly ipRanges?: string[];
    /**
    * Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH,
  for not allowing root access. The default is NO_ROOT_SQUASH. Default value: "NO_ROOT_SQUASH" Possible values: ["NO_ROOT_SQUASH", "ROOT_SQUASH"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#squash_mode FilestoreInstance#squash_mode}
    */
    readonly squashMode?: string;
}
export declare function filestoreInstanceFileSharesNfsExportOptionsToTerraform(struct?: FilestoreInstanceFileSharesNfsExportOptions | cdktf.IResolvable): any;
export declare class FilestoreInstanceFileSharesNfsExportOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FilestoreInstanceFileSharesNfsExportOptions | cdktf.IResolvable | undefined;
    set internalValue(value: FilestoreInstanceFileSharesNfsExportOptions | cdktf.IResolvable | undefined);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    resetAccessMode(): void;
    get accessModeInput(): string | undefined;
    private _anonGid?;
    get anonGid(): number;
    set anonGid(value: number);
    resetAnonGid(): void;
    get anonGidInput(): number | undefined;
    private _anonUid?;
    get anonUid(): number;
    set anonUid(value: number);
    resetAnonUid(): void;
    get anonUidInput(): number | undefined;
    private _ipRanges?;
    get ipRanges(): string[];
    set ipRanges(value: string[]);
    resetIpRanges(): void;
    get ipRangesInput(): string[] | undefined;
    private _squashMode?;
    get squashMode(): string;
    set squashMode(value: string);
    resetSquashMode(): void;
    get squashModeInput(): string | undefined;
}
export declare class FilestoreInstanceFileSharesNfsExportOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FilestoreInstanceFileSharesNfsExportOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FilestoreInstanceFileSharesNfsExportOptionsOutputReference;
}
export interface FilestoreInstanceFileShares {
    /**
    * File share capacity in GiB. This must be at least 1024 GiB
  for the standard tier, or 2560 GiB for the premium tier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#capacity_gb FilestoreInstance#capacity_gb}
    */
    readonly capacityGb: number;
    /**
    * The name of the fileshare (16 characters or less)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#name FilestoreInstance#name}
    */
    readonly name: string;
    /**
    * nfs_export_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#nfs_export_options FilestoreInstance#nfs_export_options}
    */
    readonly nfsExportOptions?: FilestoreInstanceFileSharesNfsExportOptions[] | cdktf.IResolvable;
}
export declare function filestoreInstanceFileSharesToTerraform(struct?: FilestoreInstanceFileSharesOutputReference | FilestoreInstanceFileShares): any;
export declare class FilestoreInstanceFileSharesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FilestoreInstanceFileShares | undefined;
    set internalValue(value: FilestoreInstanceFileShares | undefined);
    private _capacityGb?;
    get capacityGb(): number;
    set capacityGb(value: number);
    get capacityGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nfsExportOptions;
    get nfsExportOptions(): FilestoreInstanceFileSharesNfsExportOptionsList;
    putNfsExportOptions(value: FilestoreInstanceFileSharesNfsExportOptions[] | cdktf.IResolvable): void;
    resetNfsExportOptions(): void;
    get nfsExportOptionsInput(): cdktf.IResolvable | FilestoreInstanceFileSharesNfsExportOptions[] | undefined;
}
export interface FilestoreInstanceNetworks {
    /**
    * The network connect mode of the Filestore instance.
  If not provided, the connect mode defaults to
  DIRECT_PEERING. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#connect_mode FilestoreInstance#connect_mode}
    */
    readonly connectMode?: string;
    /**
    * IP versions for which the instance has
  IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#modes FilestoreInstance#modes}
    */
    readonly modes: string[];
    /**
    * The name of the GCE VPC network to which the
  instance is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#network FilestoreInstance#network}
    */
    readonly network: string;
    /**
    * A /29 CIDR block that identifies the range of IP
  addresses reserved for this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#reserved_ip_range FilestoreInstance#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
}
export declare function filestoreInstanceNetworksToTerraform(struct?: FilestoreInstanceNetworks | cdktf.IResolvable): any;
export declare class FilestoreInstanceNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FilestoreInstanceNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: FilestoreInstanceNetworks | cdktf.IResolvable | undefined);
    private _connectMode?;
    get connectMode(): string;
    set connectMode(value: string);
    resetConnectMode(): void;
    get connectModeInput(): string | undefined;
    get ipAddresses(): string[];
    private _modes?;
    get modes(): string[];
    set modes(value: string[]);
    get modesInput(): string[] | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
}
export declare class FilestoreInstanceNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FilestoreInstanceNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FilestoreInstanceNetworksOutputReference;
}
export interface FilestoreInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#create FilestoreInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#delete FilestoreInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance#update FilestoreInstance#update}
    */
    readonly update?: string;
}
export declare function filestoreInstanceTimeoutsToTerraform(struct?: FilestoreInstanceTimeoutsOutputReference | FilestoreInstanceTimeouts | cdktf.IResolvable): any;
export declare class FilestoreInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FilestoreInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FilestoreInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/filestore_instance google_filestore_instance}
*/
export declare class FilestoreInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_filestore_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/filestore_instance google_filestore_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FilestoreInstanceConfig
    */
    constructor(scope: Construct, id: string, config: FilestoreInstanceConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _fileShares;
    get fileShares(): FilestoreInstanceFileSharesOutputReference;
    putFileShares(value: FilestoreInstanceFileShares): void;
    get fileSharesInput(): FilestoreInstanceFileShares | undefined;
    private _networks;
    get networks(): FilestoreInstanceNetworksList;
    putNetworks(value: FilestoreInstanceNetworks[] | cdktf.IResolvable): void;
    get networksInput(): cdktf.IResolvable | FilestoreInstanceNetworks[] | undefined;
    private _timeouts;
    get timeouts(): FilestoreInstanceTimeoutsOutputReference;
    putTimeouts(value: FilestoreInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FilestoreInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
