import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GkeHubMembershipIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#id GkeHubMembershipIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#members GkeHubMembershipIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#membership_id GkeHubMembershipIamBinding#membership_id}
    */
    readonly membershipId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#project GkeHubMembershipIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#role GkeHubMembershipIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#condition GkeHubMembershipIamBinding#condition}
    */
    readonly condition?: GkeHubMembershipIamBindingCondition;
}
export interface GkeHubMembershipIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#description GkeHubMembershipIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#expression GkeHubMembershipIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding#title GkeHubMembershipIamBinding#title}
    */
    readonly title: string;
}
export declare function gkeHubMembershipIamBindingConditionToTerraform(struct?: GkeHubMembershipIamBindingConditionOutputReference | GkeHubMembershipIamBindingCondition): any;
export declare class GkeHubMembershipIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GkeHubMembershipIamBindingCondition | undefined;
    set internalValue(value: GkeHubMembershipIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding google_gke_hub_membership_iam_binding}
*/
export declare class GkeHubMembershipIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_membership_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership_iam_binding google_gke_hub_membership_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GkeHubMembershipIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GkeHubMembershipIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _membershipId?;
    get membershipId(): string;
    set membershipId(value: string);
    get membershipIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GkeHubMembershipIamBindingConditionOutputReference;
    putCondition(value: GkeHubMembershipIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GkeHubMembershipIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
