"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleProvider = exports.googleProviderBatchingToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleProviderBatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_batching: cdktf.booleanToTerraform(struct.enableBatching),
        send_after: cdktf.stringToTerraform(struct.sendAfter),
    };
}
exports.googleProviderBatchingToTerraform = googleProviderBatchingToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google google}
*/
class GoogleProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'google',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.0'
            },
            terraformProviderSource: 'google'
        });
        this._accessApprovalCustomEndpoint = config.accessApprovalCustomEndpoint;
        this._accessContextManagerCustomEndpoint = config.accessContextManagerCustomEndpoint;
        this._accessToken = config.accessToken;
        this._activeDirectoryCustomEndpoint = config.activeDirectoryCustomEndpoint;
        this._apigeeCustomEndpoint = config.apigeeCustomEndpoint;
        this._apikeysCustomEndpoint = config.apikeysCustomEndpoint;
        this._appEngineCustomEndpoint = config.appEngineCustomEndpoint;
        this._artifactRegistryCustomEndpoint = config.artifactRegistryCustomEndpoint;
        this._assuredWorkloadsCustomEndpoint = config.assuredWorkloadsCustomEndpoint;
        this._bigQueryCustomEndpoint = config.bigQueryCustomEndpoint;
        this._bigqueryConnectionCustomEndpoint = config.bigqueryConnectionCustomEndpoint;
        this._bigqueryDataTransferCustomEndpoint = config.bigqueryDataTransferCustomEndpoint;
        this._bigqueryReservationCustomEndpoint = config.bigqueryReservationCustomEndpoint;
        this._bigtableCustomEndpoint = config.bigtableCustomEndpoint;
        this._billingCustomEndpoint = config.billingCustomEndpoint;
        this._billingProject = config.billingProject;
        this._binaryAuthorizationCustomEndpoint = config.binaryAuthorizationCustomEndpoint;
        this._certificateManagerCustomEndpoint = config.certificateManagerCustomEndpoint;
        this._cloudAssetCustomEndpoint = config.cloudAssetCustomEndpoint;
        this._cloudBillingCustomEndpoint = config.cloudBillingCustomEndpoint;
        this._cloudBuildCustomEndpoint = config.cloudBuildCustomEndpoint;
        this._cloudBuildWorkerPoolCustomEndpoint = config.cloudBuildWorkerPoolCustomEndpoint;
        this._cloudFunctionsCustomEndpoint = config.cloudFunctionsCustomEndpoint;
        this._cloudIdentityCustomEndpoint = config.cloudIdentityCustomEndpoint;
        this._cloudIotCustomEndpoint = config.cloudIotCustomEndpoint;
        this._cloudResourceManagerCustomEndpoint = config.cloudResourceManagerCustomEndpoint;
        this._cloudRunCustomEndpoint = config.cloudRunCustomEndpoint;
        this._cloudSchedulerCustomEndpoint = config.cloudSchedulerCustomEndpoint;
        this._cloudTasksCustomEndpoint = config.cloudTasksCustomEndpoint;
        this._clouddeployCustomEndpoint = config.clouddeployCustomEndpoint;
        this._cloudfunctions2CustomEndpoint = config.cloudfunctions2CustomEndpoint;
        this._composerCustomEndpoint = config.composerCustomEndpoint;
        this._computeCustomEndpoint = config.computeCustomEndpoint;
        this._containerAnalysisCustomEndpoint = config.containerAnalysisCustomEndpoint;
        this._containerAwsCustomEndpoint = config.containerAwsCustomEndpoint;
        this._containerAzureCustomEndpoint = config.containerAzureCustomEndpoint;
        this._containerCustomEndpoint = config.containerCustomEndpoint;
        this._credentials = config.credentials;
        this._dataCatalogCustomEndpoint = config.dataCatalogCustomEndpoint;
        this._dataFusionCustomEndpoint = config.dataFusionCustomEndpoint;
        this._dataLossPreventionCustomEndpoint = config.dataLossPreventionCustomEndpoint;
        this._dataflowCustomEndpoint = config.dataflowCustomEndpoint;
        this._dataplexCustomEndpoint = config.dataplexCustomEndpoint;
        this._dataprocCustomEndpoint = config.dataprocCustomEndpoint;
        this._dataprocMetastoreCustomEndpoint = config.dataprocMetastoreCustomEndpoint;
        this._datastoreCustomEndpoint = config.datastoreCustomEndpoint;
        this._datastreamCustomEndpoint = config.datastreamCustomEndpoint;
        this._deploymentManagerCustomEndpoint = config.deploymentManagerCustomEndpoint;
        this._dialogflowCustomEndpoint = config.dialogflowCustomEndpoint;
        this._dialogflowCxCustomEndpoint = config.dialogflowCxCustomEndpoint;
        this._dnsCustomEndpoint = config.dnsCustomEndpoint;
        this._documentAiCustomEndpoint = config.documentAiCustomEndpoint;
        this._essentialContactsCustomEndpoint = config.essentialContactsCustomEndpoint;
        this._eventarcCustomEndpoint = config.eventarcCustomEndpoint;
        this._filestoreCustomEndpoint = config.filestoreCustomEndpoint;
        this._firebaserulesCustomEndpoint = config.firebaserulesCustomEndpoint;
        this._firestoreCustomEndpoint = config.firestoreCustomEndpoint;
        this._gameServicesCustomEndpoint = config.gameServicesCustomEndpoint;
        this._gkeHubCustomEndpoint = config.gkeHubCustomEndpoint;
        this._healthcareCustomEndpoint = config.healthcareCustomEndpoint;
        this._iamBetaCustomEndpoint = config.iamBetaCustomEndpoint;
        this._iamCredentialsCustomEndpoint = config.iamCredentialsCustomEndpoint;
        this._iamCustomEndpoint = config.iamCustomEndpoint;
        this._iapCustomEndpoint = config.iapCustomEndpoint;
        this._identityPlatformCustomEndpoint = config.identityPlatformCustomEndpoint;
        this._impersonateServiceAccount = config.impersonateServiceAccount;
        this._impersonateServiceAccountDelegates = config.impersonateServiceAccountDelegates;
        this._kmsCustomEndpoint = config.kmsCustomEndpoint;
        this._loggingCustomEndpoint = config.loggingCustomEndpoint;
        this._memcacheCustomEndpoint = config.memcacheCustomEndpoint;
        this._mlEngineCustomEndpoint = config.mlEngineCustomEndpoint;
        this._monitoringCustomEndpoint = config.monitoringCustomEndpoint;
        this._networkConnectivityCustomEndpoint = config.networkConnectivityCustomEndpoint;
        this._networkManagementCustomEndpoint = config.networkManagementCustomEndpoint;
        this._networkServicesCustomEndpoint = config.networkServicesCustomEndpoint;
        this._notebooksCustomEndpoint = config.notebooksCustomEndpoint;
        this._orgPolicyCustomEndpoint = config.orgPolicyCustomEndpoint;
        this._osConfigCustomEndpoint = config.osConfigCustomEndpoint;
        this._osLoginCustomEndpoint = config.osLoginCustomEndpoint;
        this._privatecaCustomEndpoint = config.privatecaCustomEndpoint;
        this._project = config.project;
        this._pubsubCustomEndpoint = config.pubsubCustomEndpoint;
        this._pubsubLiteCustomEndpoint = config.pubsubLiteCustomEndpoint;
        this._recaptchaEnterpriseCustomEndpoint = config.recaptchaEnterpriseCustomEndpoint;
        this._redisCustomEndpoint = config.redisCustomEndpoint;
        this._region = config.region;
        this._requestReason = config.requestReason;
        this._requestTimeout = config.requestTimeout;
        this._resourceManagerCustomEndpoint = config.resourceManagerCustomEndpoint;
        this._resourceManagerV3CustomEndpoint = config.resourceManagerV3CustomEndpoint;
        this._scopes = config.scopes;
        this._secretManagerCustomEndpoint = config.secretManagerCustomEndpoint;
        this._securityCenterCustomEndpoint = config.securityCenterCustomEndpoint;
        this._serviceManagementCustomEndpoint = config.serviceManagementCustomEndpoint;
        this._serviceNetworkingCustomEndpoint = config.serviceNetworkingCustomEndpoint;
        this._serviceUsageCustomEndpoint = config.serviceUsageCustomEndpoint;
        this._sourceRepoCustomEndpoint = config.sourceRepoCustomEndpoint;
        this._spannerCustomEndpoint = config.spannerCustomEndpoint;
        this._sqlCustomEndpoint = config.sqlCustomEndpoint;
        this._storageCustomEndpoint = config.storageCustomEndpoint;
        this._storageTransferCustomEndpoint = config.storageTransferCustomEndpoint;
        this._tagsCustomEndpoint = config.tagsCustomEndpoint;
        this._tpuCustomEndpoint = config.tpuCustomEndpoint;
        this._userProjectOverride = config.userProjectOverride;
        this._vertexAiCustomEndpoint = config.vertexAiCustomEndpoint;
        this._vpcAccessCustomEndpoint = config.vpcAccessCustomEndpoint;
        this._workflowsCustomEndpoint = config.workflowsCustomEndpoint;
        this._zone = config.zone;
        this._alias = config.alias;
        this._batching = config.batching;
    }
    get accessApprovalCustomEndpoint() {
        return this._accessApprovalCustomEndpoint;
    }
    set accessApprovalCustomEndpoint(value) {
        this._accessApprovalCustomEndpoint = value;
    }
    resetAccessApprovalCustomEndpoint() {
        this._accessApprovalCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessApprovalCustomEndpointInput() {
        return this._accessApprovalCustomEndpoint;
    }
    get accessContextManagerCustomEndpoint() {
        return this._accessContextManagerCustomEndpoint;
    }
    set accessContextManagerCustomEndpoint(value) {
        this._accessContextManagerCustomEndpoint = value;
    }
    resetAccessContextManagerCustomEndpoint() {
        this._accessContextManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessContextManagerCustomEndpointInput() {
        return this._accessContextManagerCustomEndpoint;
    }
    get accessToken() {
        return this._accessToken;
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get activeDirectoryCustomEndpoint() {
        return this._activeDirectoryCustomEndpoint;
    }
    set activeDirectoryCustomEndpoint(value) {
        this._activeDirectoryCustomEndpoint = value;
    }
    resetActiveDirectoryCustomEndpoint() {
        this._activeDirectoryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeDirectoryCustomEndpointInput() {
        return this._activeDirectoryCustomEndpoint;
    }
    get apigeeCustomEndpoint() {
        return this._apigeeCustomEndpoint;
    }
    set apigeeCustomEndpoint(value) {
        this._apigeeCustomEndpoint = value;
    }
    resetApigeeCustomEndpoint() {
        this._apigeeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apigeeCustomEndpointInput() {
        return this._apigeeCustomEndpoint;
    }
    get apikeysCustomEndpoint() {
        return this._apikeysCustomEndpoint;
    }
    set apikeysCustomEndpoint(value) {
        this._apikeysCustomEndpoint = value;
    }
    resetApikeysCustomEndpoint() {
        this._apikeysCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apikeysCustomEndpointInput() {
        return this._apikeysCustomEndpoint;
    }
    get appEngineCustomEndpoint() {
        return this._appEngineCustomEndpoint;
    }
    set appEngineCustomEndpoint(value) {
        this._appEngineCustomEndpoint = value;
    }
    resetAppEngineCustomEndpoint() {
        this._appEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get appEngineCustomEndpointInput() {
        return this._appEngineCustomEndpoint;
    }
    get artifactRegistryCustomEndpoint() {
        return this._artifactRegistryCustomEndpoint;
    }
    set artifactRegistryCustomEndpoint(value) {
        this._artifactRegistryCustomEndpoint = value;
    }
    resetArtifactRegistryCustomEndpoint() {
        this._artifactRegistryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get artifactRegistryCustomEndpointInput() {
        return this._artifactRegistryCustomEndpoint;
    }
    get assuredWorkloadsCustomEndpoint() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    set assuredWorkloadsCustomEndpoint(value) {
        this._assuredWorkloadsCustomEndpoint = value;
    }
    resetAssuredWorkloadsCustomEndpoint() {
        this._assuredWorkloadsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assuredWorkloadsCustomEndpointInput() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    get bigQueryCustomEndpoint() {
        return this._bigQueryCustomEndpoint;
    }
    set bigQueryCustomEndpoint(value) {
        this._bigQueryCustomEndpoint = value;
    }
    resetBigQueryCustomEndpoint() {
        this._bigQueryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigQueryCustomEndpointInput() {
        return this._bigQueryCustomEndpoint;
    }
    get bigqueryConnectionCustomEndpoint() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    set bigqueryConnectionCustomEndpoint(value) {
        this._bigqueryConnectionCustomEndpoint = value;
    }
    resetBigqueryConnectionCustomEndpoint() {
        this._bigqueryConnectionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryConnectionCustomEndpointInput() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    get bigqueryDataTransferCustomEndpoint() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    set bigqueryDataTransferCustomEndpoint(value) {
        this._bigqueryDataTransferCustomEndpoint = value;
    }
    resetBigqueryDataTransferCustomEndpoint() {
        this._bigqueryDataTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryDataTransferCustomEndpointInput() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    get bigqueryReservationCustomEndpoint() {
        return this._bigqueryReservationCustomEndpoint;
    }
    set bigqueryReservationCustomEndpoint(value) {
        this._bigqueryReservationCustomEndpoint = value;
    }
    resetBigqueryReservationCustomEndpoint() {
        this._bigqueryReservationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryReservationCustomEndpointInput() {
        return this._bigqueryReservationCustomEndpoint;
    }
    get bigtableCustomEndpoint() {
        return this._bigtableCustomEndpoint;
    }
    set bigtableCustomEndpoint(value) {
        this._bigtableCustomEndpoint = value;
    }
    resetBigtableCustomEndpoint() {
        this._bigtableCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigtableCustomEndpointInput() {
        return this._bigtableCustomEndpoint;
    }
    get billingCustomEndpoint() {
        return this._billingCustomEndpoint;
    }
    set billingCustomEndpoint(value) {
        this._billingCustomEndpoint = value;
    }
    resetBillingCustomEndpoint() {
        this._billingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingCustomEndpointInput() {
        return this._billingCustomEndpoint;
    }
    get billingProject() {
        return this._billingProject;
    }
    set billingProject(value) {
        this._billingProject = value;
    }
    resetBillingProject() {
        this._billingProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingProjectInput() {
        return this._billingProject;
    }
    get binaryAuthorizationCustomEndpoint() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    set binaryAuthorizationCustomEndpoint(value) {
        this._binaryAuthorizationCustomEndpoint = value;
    }
    resetBinaryAuthorizationCustomEndpoint() {
        this._binaryAuthorizationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAuthorizationCustomEndpointInput() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    get certificateManagerCustomEndpoint() {
        return this._certificateManagerCustomEndpoint;
    }
    set certificateManagerCustomEndpoint(value) {
        this._certificateManagerCustomEndpoint = value;
    }
    resetCertificateManagerCustomEndpoint() {
        this._certificateManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateManagerCustomEndpointInput() {
        return this._certificateManagerCustomEndpoint;
    }
    get cloudAssetCustomEndpoint() {
        return this._cloudAssetCustomEndpoint;
    }
    set cloudAssetCustomEndpoint(value) {
        this._cloudAssetCustomEndpoint = value;
    }
    resetCloudAssetCustomEndpoint() {
        this._cloudAssetCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudAssetCustomEndpointInput() {
        return this._cloudAssetCustomEndpoint;
    }
    get cloudBillingCustomEndpoint() {
        return this._cloudBillingCustomEndpoint;
    }
    set cloudBillingCustomEndpoint(value) {
        this._cloudBillingCustomEndpoint = value;
    }
    resetCloudBillingCustomEndpoint() {
        this._cloudBillingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBillingCustomEndpointInput() {
        return this._cloudBillingCustomEndpoint;
    }
    get cloudBuildCustomEndpoint() {
        return this._cloudBuildCustomEndpoint;
    }
    set cloudBuildCustomEndpoint(value) {
        this._cloudBuildCustomEndpoint = value;
    }
    resetCloudBuildCustomEndpoint() {
        this._cloudBuildCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildCustomEndpointInput() {
        return this._cloudBuildCustomEndpoint;
    }
    get cloudBuildWorkerPoolCustomEndpoint() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    set cloudBuildWorkerPoolCustomEndpoint(value) {
        this._cloudBuildWorkerPoolCustomEndpoint = value;
    }
    resetCloudBuildWorkerPoolCustomEndpoint() {
        this._cloudBuildWorkerPoolCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildWorkerPoolCustomEndpointInput() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    get cloudFunctionsCustomEndpoint() {
        return this._cloudFunctionsCustomEndpoint;
    }
    set cloudFunctionsCustomEndpoint(value) {
        this._cloudFunctionsCustomEndpoint = value;
    }
    resetCloudFunctionsCustomEndpoint() {
        this._cloudFunctionsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudFunctionsCustomEndpointInput() {
        return this._cloudFunctionsCustomEndpoint;
    }
    get cloudIdentityCustomEndpoint() {
        return this._cloudIdentityCustomEndpoint;
    }
    set cloudIdentityCustomEndpoint(value) {
        this._cloudIdentityCustomEndpoint = value;
    }
    resetCloudIdentityCustomEndpoint() {
        this._cloudIdentityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIdentityCustomEndpointInput() {
        return this._cloudIdentityCustomEndpoint;
    }
    get cloudIotCustomEndpoint() {
        return this._cloudIotCustomEndpoint;
    }
    set cloudIotCustomEndpoint(value) {
        this._cloudIotCustomEndpoint = value;
    }
    resetCloudIotCustomEndpoint() {
        this._cloudIotCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIotCustomEndpointInput() {
        return this._cloudIotCustomEndpoint;
    }
    get cloudResourceManagerCustomEndpoint() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    set cloudResourceManagerCustomEndpoint(value) {
        this._cloudResourceManagerCustomEndpoint = value;
    }
    resetCloudResourceManagerCustomEndpoint() {
        this._cloudResourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudResourceManagerCustomEndpointInput() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    get cloudRunCustomEndpoint() {
        return this._cloudRunCustomEndpoint;
    }
    set cloudRunCustomEndpoint(value) {
        this._cloudRunCustomEndpoint = value;
    }
    resetCloudRunCustomEndpoint() {
        this._cloudRunCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudRunCustomEndpointInput() {
        return this._cloudRunCustomEndpoint;
    }
    get cloudSchedulerCustomEndpoint() {
        return this._cloudSchedulerCustomEndpoint;
    }
    set cloudSchedulerCustomEndpoint(value) {
        this._cloudSchedulerCustomEndpoint = value;
    }
    resetCloudSchedulerCustomEndpoint() {
        this._cloudSchedulerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudSchedulerCustomEndpointInput() {
        return this._cloudSchedulerCustomEndpoint;
    }
    get cloudTasksCustomEndpoint() {
        return this._cloudTasksCustomEndpoint;
    }
    set cloudTasksCustomEndpoint(value) {
        this._cloudTasksCustomEndpoint = value;
    }
    resetCloudTasksCustomEndpoint() {
        this._cloudTasksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudTasksCustomEndpointInput() {
        return this._cloudTasksCustomEndpoint;
    }
    get clouddeployCustomEndpoint() {
        return this._clouddeployCustomEndpoint;
    }
    set clouddeployCustomEndpoint(value) {
        this._clouddeployCustomEndpoint = value;
    }
    resetClouddeployCustomEndpoint() {
        this._clouddeployCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clouddeployCustomEndpointInput() {
        return this._clouddeployCustomEndpoint;
    }
    get cloudfunctions2CustomEndpoint() {
        return this._cloudfunctions2CustomEndpoint;
    }
    set cloudfunctions2CustomEndpoint(value) {
        this._cloudfunctions2CustomEndpoint = value;
    }
    resetCloudfunctions2CustomEndpoint() {
        this._cloudfunctions2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudfunctions2CustomEndpointInput() {
        return this._cloudfunctions2CustomEndpoint;
    }
    get composerCustomEndpoint() {
        return this._composerCustomEndpoint;
    }
    set composerCustomEndpoint(value) {
        this._composerCustomEndpoint = value;
    }
    resetComposerCustomEndpoint() {
        this._composerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get composerCustomEndpointInput() {
        return this._composerCustomEndpoint;
    }
    get computeCustomEndpoint() {
        return this._computeCustomEndpoint;
    }
    set computeCustomEndpoint(value) {
        this._computeCustomEndpoint = value;
    }
    resetComputeCustomEndpoint() {
        this._computeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get computeCustomEndpointInput() {
        return this._computeCustomEndpoint;
    }
    get containerAnalysisCustomEndpoint() {
        return this._containerAnalysisCustomEndpoint;
    }
    set containerAnalysisCustomEndpoint(value) {
        this._containerAnalysisCustomEndpoint = value;
    }
    resetContainerAnalysisCustomEndpoint() {
        this._containerAnalysisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAnalysisCustomEndpointInput() {
        return this._containerAnalysisCustomEndpoint;
    }
    get containerAwsCustomEndpoint() {
        return this._containerAwsCustomEndpoint;
    }
    set containerAwsCustomEndpoint(value) {
        this._containerAwsCustomEndpoint = value;
    }
    resetContainerAwsCustomEndpoint() {
        this._containerAwsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAwsCustomEndpointInput() {
        return this._containerAwsCustomEndpoint;
    }
    get containerAzureCustomEndpoint() {
        return this._containerAzureCustomEndpoint;
    }
    set containerAzureCustomEndpoint(value) {
        this._containerAzureCustomEndpoint = value;
    }
    resetContainerAzureCustomEndpoint() {
        this._containerAzureCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAzureCustomEndpointInput() {
        return this._containerAzureCustomEndpoint;
    }
    get containerCustomEndpoint() {
        return this._containerCustomEndpoint;
    }
    set containerCustomEndpoint(value) {
        this._containerCustomEndpoint = value;
    }
    resetContainerCustomEndpoint() {
        this._containerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerCustomEndpointInput() {
        return this._containerCustomEndpoint;
    }
    get credentials() {
        return this._credentials;
    }
    set credentials(value) {
        this._credentials = value;
    }
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsInput() {
        return this._credentials;
    }
    get dataCatalogCustomEndpoint() {
        return this._dataCatalogCustomEndpoint;
    }
    set dataCatalogCustomEndpoint(value) {
        this._dataCatalogCustomEndpoint = value;
    }
    resetDataCatalogCustomEndpoint() {
        this._dataCatalogCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataCatalogCustomEndpointInput() {
        return this._dataCatalogCustomEndpoint;
    }
    get dataFusionCustomEndpoint() {
        return this._dataFusionCustomEndpoint;
    }
    set dataFusionCustomEndpoint(value) {
        this._dataFusionCustomEndpoint = value;
    }
    resetDataFusionCustomEndpoint() {
        this._dataFusionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataFusionCustomEndpointInput() {
        return this._dataFusionCustomEndpoint;
    }
    get dataLossPreventionCustomEndpoint() {
        return this._dataLossPreventionCustomEndpoint;
    }
    set dataLossPreventionCustomEndpoint(value) {
        this._dataLossPreventionCustomEndpoint = value;
    }
    resetDataLossPreventionCustomEndpoint() {
        this._dataLossPreventionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataLossPreventionCustomEndpointInput() {
        return this._dataLossPreventionCustomEndpoint;
    }
    get dataflowCustomEndpoint() {
        return this._dataflowCustomEndpoint;
    }
    set dataflowCustomEndpoint(value) {
        this._dataflowCustomEndpoint = value;
    }
    resetDataflowCustomEndpoint() {
        this._dataflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataflowCustomEndpointInput() {
        return this._dataflowCustomEndpoint;
    }
    get dataplexCustomEndpoint() {
        return this._dataplexCustomEndpoint;
    }
    set dataplexCustomEndpoint(value) {
        this._dataplexCustomEndpoint = value;
    }
    resetDataplexCustomEndpoint() {
        this._dataplexCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataplexCustomEndpointInput() {
        return this._dataplexCustomEndpoint;
    }
    get dataprocCustomEndpoint() {
        return this._dataprocCustomEndpoint;
    }
    set dataprocCustomEndpoint(value) {
        this._dataprocCustomEndpoint = value;
    }
    resetDataprocCustomEndpoint() {
        this._dataprocCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocCustomEndpointInput() {
        return this._dataprocCustomEndpoint;
    }
    get dataprocMetastoreCustomEndpoint() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    set dataprocMetastoreCustomEndpoint(value) {
        this._dataprocMetastoreCustomEndpoint = value;
    }
    resetDataprocMetastoreCustomEndpoint() {
        this._dataprocMetastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocMetastoreCustomEndpointInput() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    get datastoreCustomEndpoint() {
        return this._datastoreCustomEndpoint;
    }
    set datastoreCustomEndpoint(value) {
        this._datastoreCustomEndpoint = value;
    }
    resetDatastoreCustomEndpoint() {
        this._datastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastoreCustomEndpointInput() {
        return this._datastoreCustomEndpoint;
    }
    get datastreamCustomEndpoint() {
        return this._datastreamCustomEndpoint;
    }
    set datastreamCustomEndpoint(value) {
        this._datastreamCustomEndpoint = value;
    }
    resetDatastreamCustomEndpoint() {
        this._datastreamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastreamCustomEndpointInput() {
        return this._datastreamCustomEndpoint;
    }
    get deploymentManagerCustomEndpoint() {
        return this._deploymentManagerCustomEndpoint;
    }
    set deploymentManagerCustomEndpoint(value) {
        this._deploymentManagerCustomEndpoint = value;
    }
    resetDeploymentManagerCustomEndpoint() {
        this._deploymentManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deploymentManagerCustomEndpointInput() {
        return this._deploymentManagerCustomEndpoint;
    }
    get dialogflowCustomEndpoint() {
        return this._dialogflowCustomEndpoint;
    }
    set dialogflowCustomEndpoint(value) {
        this._dialogflowCustomEndpoint = value;
    }
    resetDialogflowCustomEndpoint() {
        this._dialogflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCustomEndpointInput() {
        return this._dialogflowCustomEndpoint;
    }
    get dialogflowCxCustomEndpoint() {
        return this._dialogflowCxCustomEndpoint;
    }
    set dialogflowCxCustomEndpoint(value) {
        this._dialogflowCxCustomEndpoint = value;
    }
    resetDialogflowCxCustomEndpoint() {
        this._dialogflowCxCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCxCustomEndpointInput() {
        return this._dialogflowCxCustomEndpoint;
    }
    get dnsCustomEndpoint() {
        return this._dnsCustomEndpoint;
    }
    set dnsCustomEndpoint(value) {
        this._dnsCustomEndpoint = value;
    }
    resetDnsCustomEndpoint() {
        this._dnsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsCustomEndpointInput() {
        return this._dnsCustomEndpoint;
    }
    get documentAiCustomEndpoint() {
        return this._documentAiCustomEndpoint;
    }
    set documentAiCustomEndpoint(value) {
        this._documentAiCustomEndpoint = value;
    }
    resetDocumentAiCustomEndpoint() {
        this._documentAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get documentAiCustomEndpointInput() {
        return this._documentAiCustomEndpoint;
    }
    get essentialContactsCustomEndpoint() {
        return this._essentialContactsCustomEndpoint;
    }
    set essentialContactsCustomEndpoint(value) {
        this._essentialContactsCustomEndpoint = value;
    }
    resetEssentialContactsCustomEndpoint() {
        this._essentialContactsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get essentialContactsCustomEndpointInput() {
        return this._essentialContactsCustomEndpoint;
    }
    get eventarcCustomEndpoint() {
        return this._eventarcCustomEndpoint;
    }
    set eventarcCustomEndpoint(value) {
        this._eventarcCustomEndpoint = value;
    }
    resetEventarcCustomEndpoint() {
        this._eventarcCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventarcCustomEndpointInput() {
        return this._eventarcCustomEndpoint;
    }
    get filestoreCustomEndpoint() {
        return this._filestoreCustomEndpoint;
    }
    set filestoreCustomEndpoint(value) {
        this._filestoreCustomEndpoint = value;
    }
    resetFilestoreCustomEndpoint() {
        this._filestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filestoreCustomEndpointInput() {
        return this._filestoreCustomEndpoint;
    }
    get firebaserulesCustomEndpoint() {
        return this._firebaserulesCustomEndpoint;
    }
    set firebaserulesCustomEndpoint(value) {
        this._firebaserulesCustomEndpoint = value;
    }
    resetFirebaserulesCustomEndpoint() {
        this._firebaserulesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firebaserulesCustomEndpointInput() {
        return this._firebaserulesCustomEndpoint;
    }
    get firestoreCustomEndpoint() {
        return this._firestoreCustomEndpoint;
    }
    set firestoreCustomEndpoint(value) {
        this._firestoreCustomEndpoint = value;
    }
    resetFirestoreCustomEndpoint() {
        this._firestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firestoreCustomEndpointInput() {
        return this._firestoreCustomEndpoint;
    }
    get gameServicesCustomEndpoint() {
        return this._gameServicesCustomEndpoint;
    }
    set gameServicesCustomEndpoint(value) {
        this._gameServicesCustomEndpoint = value;
    }
    resetGameServicesCustomEndpoint() {
        this._gameServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gameServicesCustomEndpointInput() {
        return this._gameServicesCustomEndpoint;
    }
    get gkeHubCustomEndpoint() {
        return this._gkeHubCustomEndpoint;
    }
    set gkeHubCustomEndpoint(value) {
        this._gkeHubCustomEndpoint = value;
    }
    resetGkeHubCustomEndpoint() {
        this._gkeHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeHubCustomEndpointInput() {
        return this._gkeHubCustomEndpoint;
    }
    get healthcareCustomEndpoint() {
        return this._healthcareCustomEndpoint;
    }
    set healthcareCustomEndpoint(value) {
        this._healthcareCustomEndpoint = value;
    }
    resetHealthcareCustomEndpoint() {
        this._healthcareCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthcareCustomEndpointInput() {
        return this._healthcareCustomEndpoint;
    }
    get iamBetaCustomEndpoint() {
        return this._iamBetaCustomEndpoint;
    }
    set iamBetaCustomEndpoint(value) {
        this._iamBetaCustomEndpoint = value;
    }
    resetIamBetaCustomEndpoint() {
        this._iamBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamBetaCustomEndpointInput() {
        return this._iamBetaCustomEndpoint;
    }
    get iamCredentialsCustomEndpoint() {
        return this._iamCredentialsCustomEndpoint;
    }
    set iamCredentialsCustomEndpoint(value) {
        this._iamCredentialsCustomEndpoint = value;
    }
    resetIamCredentialsCustomEndpoint() {
        this._iamCredentialsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCredentialsCustomEndpointInput() {
        return this._iamCredentialsCustomEndpoint;
    }
    get iamCustomEndpoint() {
        return this._iamCustomEndpoint;
    }
    set iamCustomEndpoint(value) {
        this._iamCustomEndpoint = value;
    }
    resetIamCustomEndpoint() {
        this._iamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCustomEndpointInput() {
        return this._iamCustomEndpoint;
    }
    get iapCustomEndpoint() {
        return this._iapCustomEndpoint;
    }
    set iapCustomEndpoint(value) {
        this._iapCustomEndpoint = value;
    }
    resetIapCustomEndpoint() {
        this._iapCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iapCustomEndpointInput() {
        return this._iapCustomEndpoint;
    }
    get identityPlatformCustomEndpoint() {
        return this._identityPlatformCustomEndpoint;
    }
    set identityPlatformCustomEndpoint(value) {
        this._identityPlatformCustomEndpoint = value;
    }
    resetIdentityPlatformCustomEndpoint() {
        this._identityPlatformCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityPlatformCustomEndpointInput() {
        return this._identityPlatformCustomEndpoint;
    }
    get impersonateServiceAccount() {
        return this._impersonateServiceAccount;
    }
    set impersonateServiceAccount(value) {
        this._impersonateServiceAccount = value;
    }
    resetImpersonateServiceAccount() {
        this._impersonateServiceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountInput() {
        return this._impersonateServiceAccount;
    }
    get impersonateServiceAccountDelegates() {
        return this._impersonateServiceAccountDelegates;
    }
    set impersonateServiceAccountDelegates(value) {
        this._impersonateServiceAccountDelegates = value;
    }
    resetImpersonateServiceAccountDelegates() {
        this._impersonateServiceAccountDelegates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountDelegatesInput() {
        return this._impersonateServiceAccountDelegates;
    }
    get kmsCustomEndpoint() {
        return this._kmsCustomEndpoint;
    }
    set kmsCustomEndpoint(value) {
        this._kmsCustomEndpoint = value;
    }
    resetKmsCustomEndpoint() {
        this._kmsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kmsCustomEndpointInput() {
        return this._kmsCustomEndpoint;
    }
    get loggingCustomEndpoint() {
        return this._loggingCustomEndpoint;
    }
    set loggingCustomEndpoint(value) {
        this._loggingCustomEndpoint = value;
    }
    resetLoggingCustomEndpoint() {
        this._loggingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingCustomEndpointInput() {
        return this._loggingCustomEndpoint;
    }
    get memcacheCustomEndpoint() {
        return this._memcacheCustomEndpoint;
    }
    set memcacheCustomEndpoint(value) {
        this._memcacheCustomEndpoint = value;
    }
    resetMemcacheCustomEndpoint() {
        this._memcacheCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memcacheCustomEndpointInput() {
        return this._memcacheCustomEndpoint;
    }
    get mlEngineCustomEndpoint() {
        return this._mlEngineCustomEndpoint;
    }
    set mlEngineCustomEndpoint(value) {
        this._mlEngineCustomEndpoint = value;
    }
    resetMlEngineCustomEndpoint() {
        this._mlEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mlEngineCustomEndpointInput() {
        return this._mlEngineCustomEndpoint;
    }
    get monitoringCustomEndpoint() {
        return this._monitoringCustomEndpoint;
    }
    set monitoringCustomEndpoint(value) {
        this._monitoringCustomEndpoint = value;
    }
    resetMonitoringCustomEndpoint() {
        this._monitoringCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringCustomEndpointInput() {
        return this._monitoringCustomEndpoint;
    }
    get networkConnectivityCustomEndpoint() {
        return this._networkConnectivityCustomEndpoint;
    }
    set networkConnectivityCustomEndpoint(value) {
        this._networkConnectivityCustomEndpoint = value;
    }
    resetNetworkConnectivityCustomEndpoint() {
        this._networkConnectivityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkConnectivityCustomEndpointInput() {
        return this._networkConnectivityCustomEndpoint;
    }
    get networkManagementCustomEndpoint() {
        return this._networkManagementCustomEndpoint;
    }
    set networkManagementCustomEndpoint(value) {
        this._networkManagementCustomEndpoint = value;
    }
    resetNetworkManagementCustomEndpoint() {
        this._networkManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkManagementCustomEndpointInput() {
        return this._networkManagementCustomEndpoint;
    }
    get networkServicesCustomEndpoint() {
        return this._networkServicesCustomEndpoint;
    }
    set networkServicesCustomEndpoint(value) {
        this._networkServicesCustomEndpoint = value;
    }
    resetNetworkServicesCustomEndpoint() {
        this._networkServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkServicesCustomEndpointInput() {
        return this._networkServicesCustomEndpoint;
    }
    get notebooksCustomEndpoint() {
        return this._notebooksCustomEndpoint;
    }
    set notebooksCustomEndpoint(value) {
        this._notebooksCustomEndpoint = value;
    }
    resetNotebooksCustomEndpoint() {
        this._notebooksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notebooksCustomEndpointInput() {
        return this._notebooksCustomEndpoint;
    }
    get orgPolicyCustomEndpoint() {
        return this._orgPolicyCustomEndpoint;
    }
    set orgPolicyCustomEndpoint(value) {
        this._orgPolicyCustomEndpoint = value;
    }
    resetOrgPolicyCustomEndpoint() {
        this._orgPolicyCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orgPolicyCustomEndpointInput() {
        return this._orgPolicyCustomEndpoint;
    }
    get osConfigCustomEndpoint() {
        return this._osConfigCustomEndpoint;
    }
    set osConfigCustomEndpoint(value) {
        this._osConfigCustomEndpoint = value;
    }
    resetOsConfigCustomEndpoint() {
        this._osConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osConfigCustomEndpointInput() {
        return this._osConfigCustomEndpoint;
    }
    get osLoginCustomEndpoint() {
        return this._osLoginCustomEndpoint;
    }
    set osLoginCustomEndpoint(value) {
        this._osLoginCustomEndpoint = value;
    }
    resetOsLoginCustomEndpoint() {
        this._osLoginCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osLoginCustomEndpointInput() {
        return this._osLoginCustomEndpoint;
    }
    get privatecaCustomEndpoint() {
        return this._privatecaCustomEndpoint;
    }
    set privatecaCustomEndpoint(value) {
        this._privatecaCustomEndpoint = value;
    }
    resetPrivatecaCustomEndpoint() {
        this._privatecaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privatecaCustomEndpointInput() {
        return this._privatecaCustomEndpoint;
    }
    get project() {
        return this._project;
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pubsubCustomEndpoint() {
        return this._pubsubCustomEndpoint;
    }
    set pubsubCustomEndpoint(value) {
        this._pubsubCustomEndpoint = value;
    }
    resetPubsubCustomEndpoint() {
        this._pubsubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubCustomEndpointInput() {
        return this._pubsubCustomEndpoint;
    }
    get pubsubLiteCustomEndpoint() {
        return this._pubsubLiteCustomEndpoint;
    }
    set pubsubLiteCustomEndpoint(value) {
        this._pubsubLiteCustomEndpoint = value;
    }
    resetPubsubLiteCustomEndpoint() {
        this._pubsubLiteCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubLiteCustomEndpointInput() {
        return this._pubsubLiteCustomEndpoint;
    }
    get recaptchaEnterpriseCustomEndpoint() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    set recaptchaEnterpriseCustomEndpoint(value) {
        this._recaptchaEnterpriseCustomEndpoint = value;
    }
    resetRecaptchaEnterpriseCustomEndpoint() {
        this._recaptchaEnterpriseCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaEnterpriseCustomEndpointInput() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    get redisCustomEndpoint() {
        return this._redisCustomEndpoint;
    }
    set redisCustomEndpoint(value) {
        this._redisCustomEndpoint = value;
    }
    resetRedisCustomEndpoint() {
        this._redisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redisCustomEndpointInput() {
        return this._redisCustomEndpoint;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get requestReason() {
        return this._requestReason;
    }
    set requestReason(value) {
        this._requestReason = value;
    }
    resetRequestReason() {
        this._requestReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestReasonInput() {
        return this._requestReason;
    }
    get requestTimeout() {
        return this._requestTimeout;
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get resourceManagerCustomEndpoint() {
        return this._resourceManagerCustomEndpoint;
    }
    set resourceManagerCustomEndpoint(value) {
        this._resourceManagerCustomEndpoint = value;
    }
    resetResourceManagerCustomEndpoint() {
        this._resourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerCustomEndpointInput() {
        return this._resourceManagerCustomEndpoint;
    }
    get resourceManagerV3CustomEndpoint() {
        return this._resourceManagerV3CustomEndpoint;
    }
    set resourceManagerV3CustomEndpoint(value) {
        this._resourceManagerV3CustomEndpoint = value;
    }
    resetResourceManagerV3CustomEndpoint() {
        this._resourceManagerV3CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerV3CustomEndpointInput() {
        return this._resourceManagerV3CustomEndpoint;
    }
    get scopes() {
        return this._scopes;
    }
    set scopes(value) {
        this._scopes = value;
    }
    resetScopes() {
        this._scopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scopesInput() {
        return this._scopes;
    }
    get secretManagerCustomEndpoint() {
        return this._secretManagerCustomEndpoint;
    }
    set secretManagerCustomEndpoint(value) {
        this._secretManagerCustomEndpoint = value;
    }
    resetSecretManagerCustomEndpoint() {
        this._secretManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretManagerCustomEndpointInput() {
        return this._secretManagerCustomEndpoint;
    }
    get securityCenterCustomEndpoint() {
        return this._securityCenterCustomEndpoint;
    }
    set securityCenterCustomEndpoint(value) {
        this._securityCenterCustomEndpoint = value;
    }
    resetSecurityCenterCustomEndpoint() {
        this._securityCenterCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityCenterCustomEndpointInput() {
        return this._securityCenterCustomEndpoint;
    }
    get serviceManagementCustomEndpoint() {
        return this._serviceManagementCustomEndpoint;
    }
    set serviceManagementCustomEndpoint(value) {
        this._serviceManagementCustomEndpoint = value;
    }
    resetServiceManagementCustomEndpoint() {
        this._serviceManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceManagementCustomEndpointInput() {
        return this._serviceManagementCustomEndpoint;
    }
    get serviceNetworkingCustomEndpoint() {
        return this._serviceNetworkingCustomEndpoint;
    }
    set serviceNetworkingCustomEndpoint(value) {
        this._serviceNetworkingCustomEndpoint = value;
    }
    resetServiceNetworkingCustomEndpoint() {
        this._serviceNetworkingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceNetworkingCustomEndpointInput() {
        return this._serviceNetworkingCustomEndpoint;
    }
    get serviceUsageCustomEndpoint() {
        return this._serviceUsageCustomEndpoint;
    }
    set serviceUsageCustomEndpoint(value) {
        this._serviceUsageCustomEndpoint = value;
    }
    resetServiceUsageCustomEndpoint() {
        this._serviceUsageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceUsageCustomEndpointInput() {
        return this._serviceUsageCustomEndpoint;
    }
    get sourceRepoCustomEndpoint() {
        return this._sourceRepoCustomEndpoint;
    }
    set sourceRepoCustomEndpoint(value) {
        this._sourceRepoCustomEndpoint = value;
    }
    resetSourceRepoCustomEndpoint() {
        this._sourceRepoCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceRepoCustomEndpointInput() {
        return this._sourceRepoCustomEndpoint;
    }
    get spannerCustomEndpoint() {
        return this._spannerCustomEndpoint;
    }
    set spannerCustomEndpoint(value) {
        this._spannerCustomEndpoint = value;
    }
    resetSpannerCustomEndpoint() {
        this._spannerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spannerCustomEndpointInput() {
        return this._spannerCustomEndpoint;
    }
    get sqlCustomEndpoint() {
        return this._sqlCustomEndpoint;
    }
    set sqlCustomEndpoint(value) {
        this._sqlCustomEndpoint = value;
    }
    resetSqlCustomEndpoint() {
        this._sqlCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlCustomEndpointInput() {
        return this._sqlCustomEndpoint;
    }
    get storageCustomEndpoint() {
        return this._storageCustomEndpoint;
    }
    set storageCustomEndpoint(value) {
        this._storageCustomEndpoint = value;
    }
    resetStorageCustomEndpoint() {
        this._storageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageCustomEndpointInput() {
        return this._storageCustomEndpoint;
    }
    get storageTransferCustomEndpoint() {
        return this._storageTransferCustomEndpoint;
    }
    set storageTransferCustomEndpoint(value) {
        this._storageTransferCustomEndpoint = value;
    }
    resetStorageTransferCustomEndpoint() {
        this._storageTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageTransferCustomEndpointInput() {
        return this._storageTransferCustomEndpoint;
    }
    get tagsCustomEndpoint() {
        return this._tagsCustomEndpoint;
    }
    set tagsCustomEndpoint(value) {
        this._tagsCustomEndpoint = value;
    }
    resetTagsCustomEndpoint() {
        this._tagsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsCustomEndpointInput() {
        return this._tagsCustomEndpoint;
    }
    get tpuCustomEndpoint() {
        return this._tpuCustomEndpoint;
    }
    set tpuCustomEndpoint(value) {
        this._tpuCustomEndpoint = value;
    }
    resetTpuCustomEndpoint() {
        this._tpuCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tpuCustomEndpointInput() {
        return this._tpuCustomEndpoint;
    }
    get userProjectOverride() {
        return this._userProjectOverride;
    }
    set userProjectOverride(value) {
        this._userProjectOverride = value;
    }
    resetUserProjectOverride() {
        this._userProjectOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userProjectOverrideInput() {
        return this._userProjectOverride;
    }
    get vertexAiCustomEndpoint() {
        return this._vertexAiCustomEndpoint;
    }
    set vertexAiCustomEndpoint(value) {
        this._vertexAiCustomEndpoint = value;
    }
    resetVertexAiCustomEndpoint() {
        this._vertexAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vertexAiCustomEndpointInput() {
        return this._vertexAiCustomEndpoint;
    }
    get vpcAccessCustomEndpoint() {
        return this._vpcAccessCustomEndpoint;
    }
    set vpcAccessCustomEndpoint(value) {
        this._vpcAccessCustomEndpoint = value;
    }
    resetVpcAccessCustomEndpoint() {
        this._vpcAccessCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcAccessCustomEndpointInput() {
        return this._vpcAccessCustomEndpoint;
    }
    get workflowsCustomEndpoint() {
        return this._workflowsCustomEndpoint;
    }
    set workflowsCustomEndpoint(value) {
        this._workflowsCustomEndpoint = value;
    }
    resetWorkflowsCustomEndpoint() {
        this._workflowsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workflowsCustomEndpointInput() {
        return this._workflowsCustomEndpoint;
    }
    get zone() {
        return this._zone;
    }
    set zone(value) {
        this._zone = value;
    }
    resetZone() {
        this._zone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get batching() {
        return this._batching;
    }
    set batching(value) {
        this._batching = value;
    }
    resetBatching() {
        this._batching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get batchingInput() {
        return this._batching;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_approval_custom_endpoint: cdktf.stringToTerraform(this._accessApprovalCustomEndpoint),
            access_context_manager_custom_endpoint: cdktf.stringToTerraform(this._accessContextManagerCustomEndpoint),
            access_token: cdktf.stringToTerraform(this._accessToken),
            active_directory_custom_endpoint: cdktf.stringToTerraform(this._activeDirectoryCustomEndpoint),
            apigee_custom_endpoint: cdktf.stringToTerraform(this._apigeeCustomEndpoint),
            apikeys_custom_endpoint: cdktf.stringToTerraform(this._apikeysCustomEndpoint),
            app_engine_custom_endpoint: cdktf.stringToTerraform(this._appEngineCustomEndpoint),
            artifact_registry_custom_endpoint: cdktf.stringToTerraform(this._artifactRegistryCustomEndpoint),
            assured_workloads_custom_endpoint: cdktf.stringToTerraform(this._assuredWorkloadsCustomEndpoint),
            big_query_custom_endpoint: cdktf.stringToTerraform(this._bigQueryCustomEndpoint),
            bigquery_connection_custom_endpoint: cdktf.stringToTerraform(this._bigqueryConnectionCustomEndpoint),
            bigquery_data_transfer_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDataTransferCustomEndpoint),
            bigquery_reservation_custom_endpoint: cdktf.stringToTerraform(this._bigqueryReservationCustomEndpoint),
            bigtable_custom_endpoint: cdktf.stringToTerraform(this._bigtableCustomEndpoint),
            billing_custom_endpoint: cdktf.stringToTerraform(this._billingCustomEndpoint),
            billing_project: cdktf.stringToTerraform(this._billingProject),
            binary_authorization_custom_endpoint: cdktf.stringToTerraform(this._binaryAuthorizationCustomEndpoint),
            certificate_manager_custom_endpoint: cdktf.stringToTerraform(this._certificateManagerCustomEndpoint),
            cloud_asset_custom_endpoint: cdktf.stringToTerraform(this._cloudAssetCustomEndpoint),
            cloud_billing_custom_endpoint: cdktf.stringToTerraform(this._cloudBillingCustomEndpoint),
            cloud_build_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildCustomEndpoint),
            cloud_build_worker_pool_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildWorkerPoolCustomEndpoint),
            cloud_functions_custom_endpoint: cdktf.stringToTerraform(this._cloudFunctionsCustomEndpoint),
            cloud_identity_custom_endpoint: cdktf.stringToTerraform(this._cloudIdentityCustomEndpoint),
            cloud_iot_custom_endpoint: cdktf.stringToTerraform(this._cloudIotCustomEndpoint),
            cloud_resource_manager_custom_endpoint: cdktf.stringToTerraform(this._cloudResourceManagerCustomEndpoint),
            cloud_run_custom_endpoint: cdktf.stringToTerraform(this._cloudRunCustomEndpoint),
            cloud_scheduler_custom_endpoint: cdktf.stringToTerraform(this._cloudSchedulerCustomEndpoint),
            cloud_tasks_custom_endpoint: cdktf.stringToTerraform(this._cloudTasksCustomEndpoint),
            clouddeploy_custom_endpoint: cdktf.stringToTerraform(this._clouddeployCustomEndpoint),
            cloudfunctions2_custom_endpoint: cdktf.stringToTerraform(this._cloudfunctions2CustomEndpoint),
            composer_custom_endpoint: cdktf.stringToTerraform(this._composerCustomEndpoint),
            compute_custom_endpoint: cdktf.stringToTerraform(this._computeCustomEndpoint),
            container_analysis_custom_endpoint: cdktf.stringToTerraform(this._containerAnalysisCustomEndpoint),
            container_aws_custom_endpoint: cdktf.stringToTerraform(this._containerAwsCustomEndpoint),
            container_azure_custom_endpoint: cdktf.stringToTerraform(this._containerAzureCustomEndpoint),
            container_custom_endpoint: cdktf.stringToTerraform(this._containerCustomEndpoint),
            credentials: cdktf.stringToTerraform(this._credentials),
            data_catalog_custom_endpoint: cdktf.stringToTerraform(this._dataCatalogCustomEndpoint),
            data_fusion_custom_endpoint: cdktf.stringToTerraform(this._dataFusionCustomEndpoint),
            data_loss_prevention_custom_endpoint: cdktf.stringToTerraform(this._dataLossPreventionCustomEndpoint),
            dataflow_custom_endpoint: cdktf.stringToTerraform(this._dataflowCustomEndpoint),
            dataplex_custom_endpoint: cdktf.stringToTerraform(this._dataplexCustomEndpoint),
            dataproc_custom_endpoint: cdktf.stringToTerraform(this._dataprocCustomEndpoint),
            dataproc_metastore_custom_endpoint: cdktf.stringToTerraform(this._dataprocMetastoreCustomEndpoint),
            datastore_custom_endpoint: cdktf.stringToTerraform(this._datastoreCustomEndpoint),
            datastream_custom_endpoint: cdktf.stringToTerraform(this._datastreamCustomEndpoint),
            deployment_manager_custom_endpoint: cdktf.stringToTerraform(this._deploymentManagerCustomEndpoint),
            dialogflow_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCustomEndpoint),
            dialogflow_cx_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCxCustomEndpoint),
            dns_custom_endpoint: cdktf.stringToTerraform(this._dnsCustomEndpoint),
            document_ai_custom_endpoint: cdktf.stringToTerraform(this._documentAiCustomEndpoint),
            essential_contacts_custom_endpoint: cdktf.stringToTerraform(this._essentialContactsCustomEndpoint),
            eventarc_custom_endpoint: cdktf.stringToTerraform(this._eventarcCustomEndpoint),
            filestore_custom_endpoint: cdktf.stringToTerraform(this._filestoreCustomEndpoint),
            firebaserules_custom_endpoint: cdktf.stringToTerraform(this._firebaserulesCustomEndpoint),
            firestore_custom_endpoint: cdktf.stringToTerraform(this._firestoreCustomEndpoint),
            game_services_custom_endpoint: cdktf.stringToTerraform(this._gameServicesCustomEndpoint),
            gke_hub_custom_endpoint: cdktf.stringToTerraform(this._gkeHubCustomEndpoint),
            healthcare_custom_endpoint: cdktf.stringToTerraform(this._healthcareCustomEndpoint),
            iam_beta_custom_endpoint: cdktf.stringToTerraform(this._iamBetaCustomEndpoint),
            iam_credentials_custom_endpoint: cdktf.stringToTerraform(this._iamCredentialsCustomEndpoint),
            iam_custom_endpoint: cdktf.stringToTerraform(this._iamCustomEndpoint),
            iap_custom_endpoint: cdktf.stringToTerraform(this._iapCustomEndpoint),
            identity_platform_custom_endpoint: cdktf.stringToTerraform(this._identityPlatformCustomEndpoint),
            impersonate_service_account: cdktf.stringToTerraform(this._impersonateServiceAccount),
            impersonate_service_account_delegates: cdktf.listMapper(cdktf.stringToTerraform, false)(this._impersonateServiceAccountDelegates),
            kms_custom_endpoint: cdktf.stringToTerraform(this._kmsCustomEndpoint),
            logging_custom_endpoint: cdktf.stringToTerraform(this._loggingCustomEndpoint),
            memcache_custom_endpoint: cdktf.stringToTerraform(this._memcacheCustomEndpoint),
            ml_engine_custom_endpoint: cdktf.stringToTerraform(this._mlEngineCustomEndpoint),
            monitoring_custom_endpoint: cdktf.stringToTerraform(this._monitoringCustomEndpoint),
            network_connectivity_custom_endpoint: cdktf.stringToTerraform(this._networkConnectivityCustomEndpoint),
            network_management_custom_endpoint: cdktf.stringToTerraform(this._networkManagementCustomEndpoint),
            network_services_custom_endpoint: cdktf.stringToTerraform(this._networkServicesCustomEndpoint),
            notebooks_custom_endpoint: cdktf.stringToTerraform(this._notebooksCustomEndpoint),
            org_policy_custom_endpoint: cdktf.stringToTerraform(this._orgPolicyCustomEndpoint),
            os_config_custom_endpoint: cdktf.stringToTerraform(this._osConfigCustomEndpoint),
            os_login_custom_endpoint: cdktf.stringToTerraform(this._osLoginCustomEndpoint),
            privateca_custom_endpoint: cdktf.stringToTerraform(this._privatecaCustomEndpoint),
            project: cdktf.stringToTerraform(this._project),
            pubsub_custom_endpoint: cdktf.stringToTerraform(this._pubsubCustomEndpoint),
            pubsub_lite_custom_endpoint: cdktf.stringToTerraform(this._pubsubLiteCustomEndpoint),
            recaptcha_enterprise_custom_endpoint: cdktf.stringToTerraform(this._recaptchaEnterpriseCustomEndpoint),
            redis_custom_endpoint: cdktf.stringToTerraform(this._redisCustomEndpoint),
            region: cdktf.stringToTerraform(this._region),
            request_reason: cdktf.stringToTerraform(this._requestReason),
            request_timeout: cdktf.stringToTerraform(this._requestTimeout),
            resource_manager_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerCustomEndpoint),
            resource_manager_v3_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerV3CustomEndpoint),
            scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._scopes),
            secret_manager_custom_endpoint: cdktf.stringToTerraform(this._secretManagerCustomEndpoint),
            security_center_custom_endpoint: cdktf.stringToTerraform(this._securityCenterCustomEndpoint),
            service_management_custom_endpoint: cdktf.stringToTerraform(this._serviceManagementCustomEndpoint),
            service_networking_custom_endpoint: cdktf.stringToTerraform(this._serviceNetworkingCustomEndpoint),
            service_usage_custom_endpoint: cdktf.stringToTerraform(this._serviceUsageCustomEndpoint),
            source_repo_custom_endpoint: cdktf.stringToTerraform(this._sourceRepoCustomEndpoint),
            spanner_custom_endpoint: cdktf.stringToTerraform(this._spannerCustomEndpoint),
            sql_custom_endpoint: cdktf.stringToTerraform(this._sqlCustomEndpoint),
            storage_custom_endpoint: cdktf.stringToTerraform(this._storageCustomEndpoint),
            storage_transfer_custom_endpoint: cdktf.stringToTerraform(this._storageTransferCustomEndpoint),
            tags_custom_endpoint: cdktf.stringToTerraform(this._tagsCustomEndpoint),
            tpu_custom_endpoint: cdktf.stringToTerraform(this._tpuCustomEndpoint),
            user_project_override: cdktf.booleanToTerraform(this._userProjectOverride),
            vertex_ai_custom_endpoint: cdktf.stringToTerraform(this._vertexAiCustomEndpoint),
            vpc_access_custom_endpoint: cdktf.stringToTerraform(this._vpcAccessCustomEndpoint),
            workflows_custom_endpoint: cdktf.stringToTerraform(this._workflowsCustomEndpoint),
            zone: cdktf.stringToTerraform(this._zone),
            alias: cdktf.stringToTerraform(this._alias),
            batching: googleProviderBatchingToTerraform(this._batching),
        };
    }
}
exports.GoogleProvider = GoogleProvider;
_a = JSII_RTTI_SYMBOL_1;
GoogleProvider[_a] = { fqn: "@cdktf/provider-google.GoogleProvider", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
GoogleProvider.tfResourceType = "google";
//# sourceMappingURL=data:application/json;base64,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