import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsCryptoKeyIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#crypto_key_id KmsCryptoKeyIamMember#crypto_key_id}
    */
    readonly cryptoKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#id KmsCryptoKeyIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#member KmsCryptoKeyIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#role KmsCryptoKeyIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#condition KmsCryptoKeyIamMember#condition}
    */
    readonly condition?: KmsCryptoKeyIamMemberCondition;
}
export interface KmsCryptoKeyIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#description KmsCryptoKeyIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#expression KmsCryptoKeyIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member#title KmsCryptoKeyIamMember#title}
    */
    readonly title: string;
}
export declare function kmsCryptoKeyIamMemberConditionToTerraform(struct?: KmsCryptoKeyIamMemberConditionOutputReference | KmsCryptoKeyIamMemberCondition): any;
export declare class KmsCryptoKeyIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KmsCryptoKeyIamMemberCondition | undefined;
    set internalValue(value: KmsCryptoKeyIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member google_kms_crypto_key_iam_member}
*/
export declare class KmsCryptoKeyIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_crypto_key_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_member google_kms_crypto_key_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsCryptoKeyIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyIamMemberConfig);
    private _cryptoKeyId?;
    get cryptoKeyId(): string;
    set cryptoKeyId(value: string);
    get cryptoKeyIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): KmsCryptoKeyIamMemberConditionOutputReference;
    putCondition(value: KmsCryptoKeyIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): KmsCryptoKeyIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
