import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * A brief description of this environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#description NotebooksEnvironment#description}
    */
    readonly description?: string;
    /**
    * Display name of this environment for the UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#display_name NotebooksEnvironment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#id NotebooksEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#location NotebooksEnvironment#location}
    */
    readonly location: string;
    /**
    * The name specified for the Environment instance.
  Format: projects/{project_id}/locations/{location}/environments/{environmentId}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#name NotebooksEnvironment#name}
    */
    readonly name: string;
    /**
    * Path to a Bash script that automatically runs after a notebook instance fully boots up.
  The path must be a URL or Cloud Storage path. Example: "gs://path-to-file/file-name"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#post_startup_script NotebooksEnvironment#post_startup_script}
    */
    readonly postStartupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#project NotebooksEnvironment#project}
    */
    readonly project?: string;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#container_image NotebooksEnvironment#container_image}
    */
    readonly containerImage?: NotebooksEnvironmentContainerImage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#timeouts NotebooksEnvironment#timeouts}
    */
    readonly timeouts?: NotebooksEnvironmentTimeouts;
    /**
    * vm_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#vm_image NotebooksEnvironment#vm_image}
    */
    readonly vmImage?: NotebooksEnvironmentVmImage;
}
export interface NotebooksEnvironmentContainerImage {
    /**
    * The path to the container image repository.
  For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#repository NotebooksEnvironment#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#tag NotebooksEnvironment#tag}
    */
    readonly tag?: string;
}
export declare function notebooksEnvironmentContainerImageToTerraform(struct?: NotebooksEnvironmentContainerImageOutputReference | NotebooksEnvironmentContainerImage): any;
export declare class NotebooksEnvironmentContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksEnvironmentContainerImage | undefined;
    set internalValue(value: NotebooksEnvironmentContainerImage | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface NotebooksEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#create NotebooksEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#delete NotebooksEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#update NotebooksEnvironment#update}
    */
    readonly update?: string;
}
export declare function notebooksEnvironmentTimeoutsToTerraform(struct?: NotebooksEnvironmentTimeoutsOutputReference | NotebooksEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class NotebooksEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NotebooksEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NotebooksEnvironmentVmImage {
    /**
    * Use this VM image family to find the image; the newest image in this family will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#image_family NotebooksEnvironment#image_family}
    */
    readonly imageFamily?: string;
    /**
    * Use VM image name to find the image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#image_name NotebooksEnvironment#image_name}
    */
    readonly imageName?: string;
    /**
    * The name of the Google Cloud project that this VM image belongs to.
  Format: projects/{project_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#project NotebooksEnvironment#project}
    */
    readonly project: string;
}
export declare function notebooksEnvironmentVmImageToTerraform(struct?: NotebooksEnvironmentVmImageOutputReference | NotebooksEnvironmentVmImage): any;
export declare class NotebooksEnvironmentVmImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksEnvironmentVmImage | undefined;
    set internalValue(value: NotebooksEnvironmentVmImage | undefined);
    private _imageFamily?;
    get imageFamily(): string;
    set imageFamily(value: string);
    resetImageFamily(): void;
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment google_notebooks_environment}
*/
export declare class NotebooksEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment google_notebooks_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotebooksEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: NotebooksEnvironmentConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _postStartupScript?;
    get postStartupScript(): string;
    set postStartupScript(value: string);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _containerImage;
    get containerImage(): NotebooksEnvironmentContainerImageOutputReference;
    putContainerImage(value: NotebooksEnvironmentContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): NotebooksEnvironmentContainerImage | undefined;
    private _timeouts;
    get timeouts(): NotebooksEnvironmentTimeoutsOutputReference;
    putTimeouts(value: NotebooksEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NotebooksEnvironmentTimeouts | undefined;
    private _vmImage;
    get vmImage(): NotebooksEnvironmentVmImageOutputReference;
    putVmImage(value: NotebooksEnvironmentVmImage): void;
    resetVmImage(): void;
    get vmImageInput(): NotebooksEnvironmentVmImage | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
