import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#id PubsubTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the Cloud KMS CryptoKey to be used to protect access
  to messages published on this topic. Your project's PubSub service account
  ('service-{{PROJECT_NUMBER}}@gcp-sa-pubsub.iam.gserviceaccount.com') must have
  'roles/cloudkms.cryptoKeyEncrypterDecrypter' to use this feature.
  The expected format is 'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#kms_key_name PubsubTopic#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * A set of key/value label pairs to assign to this Topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#labels PubsubTopic#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Indicates the minimum duration to retain a message after it is published
  to the topic. If this field is set, messages published to the topic in
  the last messageRetentionDuration are always available to subscribers.
  For instance, it allows any attached subscription to seek to a timestamp
  that is up to messageRetentionDuration in the past. If this field is not
  set, message retention is controlled by settings on individual subscriptions.
  Cannot be more than 31 days or less than 10 minutes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#message_retention_duration PubsubTopic#message_retention_duration}
    */
    readonly messageRetentionDuration?: string;
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#name PubsubTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#project PubsubTopic#project}
    */
    readonly project?: string;
    /**
    * message_storage_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#message_storage_policy PubsubTopic#message_storage_policy}
    */
    readonly messageStoragePolicy?: PubsubTopicMessageStoragePolicy;
    /**
    * schema_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#schema_settings PubsubTopic#schema_settings}
    */
    readonly schemaSettings?: PubsubTopicSchemaSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#timeouts PubsubTopic#timeouts}
    */
    readonly timeouts?: PubsubTopicTimeouts;
}
export interface PubsubTopicMessageStoragePolicy {
    /**
    * A list of IDs of GCP regions where messages that are published to
  the topic may be persisted in storage. Messages published by
  publishers running in non-allowed GCP regions (or running outside
  of GCP altogether) will be routed for storage in one of the
  allowed regions. An empty list means that no regions are allowed,
  and is not a valid configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#allowed_persistence_regions PubsubTopic#allowed_persistence_regions}
    */
    readonly allowedPersistenceRegions: string[];
}
export declare function pubsubTopicMessageStoragePolicyToTerraform(struct?: PubsubTopicMessageStoragePolicyOutputReference | PubsubTopicMessageStoragePolicy): any;
export declare class PubsubTopicMessageStoragePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubTopicMessageStoragePolicy | undefined;
    set internalValue(value: PubsubTopicMessageStoragePolicy | undefined);
    private _allowedPersistenceRegions?;
    get allowedPersistenceRegions(): string[];
    set allowedPersistenceRegions(value: string[]);
    get allowedPersistenceRegionsInput(): string[] | undefined;
}
export interface PubsubTopicSchemaSettings {
    /**
    * The encoding of messages validated against schema. Default value: "ENCODING_UNSPECIFIED" Possible values: ["ENCODING_UNSPECIFIED", "JSON", "BINARY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#encoding PubsubTopic#encoding}
    */
    readonly encoding?: string;
    /**
    * The name of the schema that messages published should be
  validated against. Format is projects/{project}/schemas/{schema}.
  The value of this field will be _deleted-schema_
  if the schema has been deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#schema PubsubTopic#schema}
    */
    readonly schema: string;
}
export declare function pubsubTopicSchemaSettingsToTerraform(struct?: PubsubTopicSchemaSettingsOutputReference | PubsubTopicSchemaSettings): any;
export declare class PubsubTopicSchemaSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubTopicSchemaSettings | undefined;
    set internalValue(value: PubsubTopicSchemaSettings | undefined);
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
}
export interface PubsubTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#create PubsubTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#delete PubsubTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic#update PubsubTopic#update}
    */
    readonly update?: string;
}
export declare function pubsubTopicTimeoutsToTerraform(struct?: PubsubTopicTimeoutsOutputReference | PubsubTopicTimeouts | cdktf.IResolvable): any;
export declare class PubsubTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PubsubTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic google_pubsub_topic}
*/
export declare class PubsubTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_topic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_topic google_pubsub_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubTopicConfig
    */
    constructor(scope: Construct, id: string, config: PubsubTopicConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    get messageRetentionDuration(): string;
    set messageRetentionDuration(value: string);
    resetMessageRetentionDuration(): void;
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _messageStoragePolicy;
    get messageStoragePolicy(): PubsubTopicMessageStoragePolicyOutputReference;
    putMessageStoragePolicy(value: PubsubTopicMessageStoragePolicy): void;
    resetMessageStoragePolicy(): void;
    get messageStoragePolicyInput(): PubsubTopicMessageStoragePolicy | undefined;
    private _schemaSettings;
    get schemaSettings(): PubsubTopicSchemaSettingsOutputReference;
    putSchemaSettings(value: PubsubTopicSchemaSettings): void;
    resetSchemaSettings(): void;
    get schemaSettingsInput(): PubsubTopicSchemaSettings | undefined;
    private _timeouts;
    get timeouts(): PubsubTopicTimeoutsOutputReference;
    putTimeouts(value: PubsubTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PubsubTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
