import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The MySQL, PostgreSQL or SQL Server (beta) version to use. Supported values include MYSQL_5_6, MYSQL_5_7, MYSQL_8_0, POSTGRES_9_6, POSTGRES_10, POSTGRES_11, POSTGRES_12, POSTGRES_13, POSTGRES_14, SQLSERVER_2017_STANDARD, SQLSERVER_2017_ENTERPRISE, SQLSERVER_2017_EXPRESS, SQLSERVER_2017_WEB. Database Version Policies includes an up-to-date reference of supported versions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#database_version SqlDatabaseInstance#database_version}
    */
    readonly databaseVersion: string;
    /**
    * Used to block Terraform from deleting a SQL Instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#deletion_protection SqlDatabaseInstance#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#encryption_key_name SqlDatabaseInstance#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#id SqlDatabaseInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the instance that will act as the master in the replication setup. Note, this requires the master to have binary_log_enabled set, as well as existing backups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#master_instance_name SqlDatabaseInstance#master_instance_name}
    */
    readonly masterInstanceName?: string;
    /**
    * The name of the instance. If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}
    */
    readonly name?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#project SqlDatabaseInstance#project}
    */
    readonly project?: string;
    /**
    * The region the instance will sit in. Note, Cloud SQL is not available in all regions. A valid region must be provided to use this resource. If a region is not provided in the resource definition, the provider region will be used instead, but this will be an apply-time error for instances if the provider region is not supported with Cloud SQL. If you choose not to provide the region argument for this resource, make sure you understand this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#region SqlDatabaseInstance#region}
    */
    readonly region?: string;
    /**
    * Initial root password. Required for MS SQL Server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#root_password SqlDatabaseInstance#root_password}
    */
    readonly rootPassword?: string;
    /**
    * clone block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#clone SqlDatabaseInstance#clone}
    */
    readonly clone?: SqlDatabaseInstanceClone;
    /**
    * replica_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#replica_configuration SqlDatabaseInstance#replica_configuration}
    */
    readonly replicaConfiguration?: SqlDatabaseInstanceReplicaConfiguration;
    /**
    * restore_backup_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#restore_backup_context SqlDatabaseInstance#restore_backup_context}
    */
    readonly restoreBackupContext?: SqlDatabaseInstanceRestoreBackupContext;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#settings SqlDatabaseInstance#settings}
    */
    readonly settings?: SqlDatabaseInstanceSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#timeouts SqlDatabaseInstance#timeouts}
    */
    readonly timeouts?: SqlDatabaseInstanceTimeouts;
}
export interface SqlDatabaseInstanceIpAddress {
}
export declare function sqlDatabaseInstanceIpAddressToTerraform(struct?: SqlDatabaseInstanceIpAddress): any;
export declare class SqlDatabaseInstanceIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlDatabaseInstanceIpAddress | undefined;
    set internalValue(value: SqlDatabaseInstanceIpAddress | undefined);
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class SqlDatabaseInstanceIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlDatabaseInstanceIpAddressOutputReference;
}
export interface SqlDatabaseInstanceServerCaCert {
}
export declare function sqlDatabaseInstanceServerCaCertToTerraform(struct?: SqlDatabaseInstanceServerCaCert): any;
export declare class SqlDatabaseInstanceServerCaCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlDatabaseInstanceServerCaCert | undefined;
    set internalValue(value: SqlDatabaseInstanceServerCaCert | undefined);
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class SqlDatabaseInstanceServerCaCertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlDatabaseInstanceServerCaCertOutputReference;
}
export interface SqlDatabaseInstanceClone {
    /**
    * The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#allocated_ip_range SqlDatabaseInstance#allocated_ip_range}
    */
    readonly allocatedIpRange?: string;
    /**
    * The timestamp of the point in time that should be restored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#point_in_time SqlDatabaseInstance#point_in_time}
    */
    readonly pointInTime?: string;
    /**
    * The name of the instance from which the point in time should be restored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#source_instance_name SqlDatabaseInstance#source_instance_name}
    */
    readonly sourceInstanceName: string;
}
export declare function sqlDatabaseInstanceCloneToTerraform(struct?: SqlDatabaseInstanceCloneOutputReference | SqlDatabaseInstanceClone): any;
export declare class SqlDatabaseInstanceCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceClone | undefined;
    set internalValue(value: SqlDatabaseInstanceClone | undefined);
    private _allocatedIpRange?;
    get allocatedIpRange(): string;
    set allocatedIpRange(value: string);
    resetAllocatedIpRange(): void;
    get allocatedIpRangeInput(): string | undefined;
    private _pointInTime?;
    get pointInTime(): string;
    set pointInTime(value: string);
    resetPointInTime(): void;
    get pointInTimeInput(): string | undefined;
    private _sourceInstanceName?;
    get sourceInstanceName(): string;
    set sourceInstanceName(value: string);
    get sourceInstanceNameInput(): string | undefined;
}
export interface SqlDatabaseInstanceReplicaConfiguration {
    /**
    * PEM representation of the trusted CA's x509 certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ca_certificate SqlDatabaseInstance#ca_certificate}
    */
    readonly caCertificate?: string;
    /**
    * PEM representation of the replica's x509 certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#client_certificate SqlDatabaseInstance#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#client_key SqlDatabaseInstance#client_key}
    */
    readonly clientKey?: string;
    /**
    * The number of seconds between connect retries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#connect_retry_interval SqlDatabaseInstance#connect_retry_interval}
    */
    readonly connectRetryInterval?: number;
    /**
    * Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#dump_file_path SqlDatabaseInstance#dump_file_path}
    */
    readonly dumpFilePath?: string;
    /**
    * Specifies if the replica is the failover target. If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#failover_target SqlDatabaseInstance#failover_target}
    */
    readonly failoverTarget?: boolean | cdktf.IResolvable;
    /**
    * Time in ms between replication heartbeats.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#master_heartbeat_period SqlDatabaseInstance#master_heartbeat_period}
    */
    readonly masterHeartbeatPeriod?: number;
    /**
    * Password for the replication connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#password SqlDatabaseInstance#password}
    */
    readonly password?: string;
    /**
    * Permissible ciphers for use in SSL encryption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ssl_cipher SqlDatabaseInstance#ssl_cipher}
    */
    readonly sslCipher?: string;
    /**
    * Username for replication connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#username SqlDatabaseInstance#username}
    */
    readonly username?: string;
    /**
    * True if the master's common name value is checked during the SSL handshake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#verify_server_certificate SqlDatabaseInstance#verify_server_certificate}
    */
    readonly verifyServerCertificate?: boolean | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceReplicaConfigurationToTerraform(struct?: SqlDatabaseInstanceReplicaConfigurationOutputReference | SqlDatabaseInstanceReplicaConfiguration): any;
export declare class SqlDatabaseInstanceReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    set internalValue(value: SqlDatabaseInstanceReplicaConfiguration | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _connectRetryInterval?;
    get connectRetryInterval(): number;
    set connectRetryInterval(value: number);
    resetConnectRetryInterval(): void;
    get connectRetryIntervalInput(): number | undefined;
    private _dumpFilePath?;
    get dumpFilePath(): string;
    set dumpFilePath(value: string);
    resetDumpFilePath(): void;
    get dumpFilePathInput(): string | undefined;
    private _failoverTarget?;
    get failoverTarget(): boolean | cdktf.IResolvable;
    set failoverTarget(value: boolean | cdktf.IResolvable);
    resetFailoverTarget(): void;
    get failoverTargetInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHeartbeatPeriod?;
    get masterHeartbeatPeriod(): number;
    set masterHeartbeatPeriod(value: number);
    resetMasterHeartbeatPeriod(): void;
    get masterHeartbeatPeriodInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _sslCipher?;
    get sslCipher(): string;
    set sslCipher(value: string);
    resetSslCipher(): void;
    get sslCipherInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _verifyServerCertificate?;
    get verifyServerCertificate(): boolean | cdktf.IResolvable;
    set verifyServerCertificate(value: boolean | cdktf.IResolvable);
    resetVerifyServerCertificate(): void;
    get verifyServerCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SqlDatabaseInstanceRestoreBackupContext {
    /**
    * The ID of the backup run to restore from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_run_id SqlDatabaseInstance#backup_run_id}
    */
    readonly backupRunId: number;
    /**
    * The ID of the instance that the backup was taken from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#instance_id SqlDatabaseInstance#instance_id}
    */
    readonly instanceId?: string;
    /**
    * The full project ID of the source instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#project SqlDatabaseInstance#project}
    */
    readonly project?: string;
}
export declare function sqlDatabaseInstanceRestoreBackupContextToTerraform(struct?: SqlDatabaseInstanceRestoreBackupContextOutputReference | SqlDatabaseInstanceRestoreBackupContext): any;
export declare class SqlDatabaseInstanceRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    set internalValue(value: SqlDatabaseInstanceRestoreBackupContext | undefined);
    private _backupRunId?;
    get backupRunId(): number;
    set backupRunId(value: number);
    get backupRunIdInput(): number | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsActiveDirectoryConfig {
    /**
    * Domain name of the Active Directory for SQL Server (e.g., mydomain.com).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#domain SqlDatabaseInstance#domain}
    */
    readonly domain: string;
}
export declare function sqlDatabaseInstanceSettingsActiveDirectoryConfigToTerraform(struct?: SqlDatabaseInstanceSettingsActiveDirectoryConfigOutputReference | SqlDatabaseInstanceSettingsActiveDirectoryConfig): any;
export declare class SqlDatabaseInstanceSettingsActiveDirectoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsActiveDirectoryConfig | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsActiveDirectoryConfig | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
    /**
    * Number of backups to retain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#retained_backups SqlDatabaseInstance#retained_backups}
    */
    readonly retainedBackups: number;
    /**
    * The unit that 'retainedBackups' represents. Defaults to COUNT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#retention_unit SqlDatabaseInstance#retention_unit}
    */
    readonly retentionUnit?: string;
}
export declare function sqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsToTerraform(struct?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference | SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): any;
export declare class SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined);
    private _retainedBackups?;
    get retainedBackups(): number;
    set retainedBackups(value: number);
    get retainedBackupsInput(): number | undefined;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    resetRetentionUnit(): void;
    get retentionUnitInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsBackupConfiguration {
    /**
    * True if binary logging is enabled. If settings.backup_configuration.enabled is false, this must be as well. Can only be used with MySQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#binary_log_enabled SqlDatabaseInstance#binary_log_enabled}
    */
    readonly binaryLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * True if backup configuration is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#enabled SqlDatabaseInstance#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Location of the backup configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#location SqlDatabaseInstance#location}
    */
    readonly location?: string;
    /**
    * True if Point-in-time recovery is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#point_in_time_recovery_enabled SqlDatabaseInstance#point_in_time_recovery_enabled}
    */
    readonly pointInTimeRecoveryEnabled?: boolean | cdktf.IResolvable;
    /**
    * HH:MM format time indicating when backup configuration starts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#start_time SqlDatabaseInstance#start_time}
    */
    readonly startTime?: string;
    /**
    * The number of days of transaction logs we retain for point in time restore, from 1-7.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#transaction_log_retention_days SqlDatabaseInstance#transaction_log_retention_days}
    */
    readonly transactionLogRetentionDays?: number;
    /**
    * backup_retention_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_retention_settings SqlDatabaseInstance#backup_retention_settings}
    */
    readonly backupRetentionSettings?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings;
}
export declare function sqlDatabaseInstanceSettingsBackupConfigurationToTerraform(struct?: SqlDatabaseInstanceSettingsBackupConfigurationOutputReference | SqlDatabaseInstanceSettingsBackupConfiguration): any;
export declare class SqlDatabaseInstanceSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsBackupConfiguration | undefined);
    private _binaryLogEnabled?;
    get binaryLogEnabled(): boolean | cdktf.IResolvable;
    set binaryLogEnabled(value: boolean | cdktf.IResolvable);
    resetBinaryLogEnabled(): void;
    get binaryLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _pointInTimeRecoveryEnabled?;
    get pointInTimeRecoveryEnabled(): boolean | cdktf.IResolvable;
    set pointInTimeRecoveryEnabled(value: boolean | cdktf.IResolvable);
    resetPointInTimeRecoveryEnabled(): void;
    get pointInTimeRecoveryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _transactionLogRetentionDays?;
    get transactionLogRetentionDays(): number;
    set transactionLogRetentionDays(value: number);
    resetTransactionLogRetentionDays(): void;
    get transactionLogRetentionDaysInput(): number | undefined;
    private _backupRetentionSettings;
    get backupRetentionSettings(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
    putBackupRetentionSettings(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings): void;
    resetBackupRetentionSettings(): void;
    get backupRetentionSettingsInput(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
}
export interface SqlDatabaseInstanceSettingsDatabaseFlags {
    /**
    * Name of the flag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}
    */
    readonly name: string;
    /**
    * Value of the flag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#value SqlDatabaseInstance#value}
    */
    readonly value: string;
}
export declare function sqlDatabaseInstanceSettingsDatabaseFlagsToTerraform(struct?: SqlDatabaseInstanceSettingsDatabaseFlags | cdktf.IResolvable): any;
export declare class SqlDatabaseInstanceSettingsDatabaseFlagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlDatabaseInstanceSettingsDatabaseFlags | cdktf.IResolvable | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsDatabaseFlags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SqlDatabaseInstanceSettingsDatabaseFlagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlDatabaseInstanceSettingsDatabaseFlagsOutputReference;
}
export interface SqlDatabaseInstanceSettingsInsightsConfig {
    /**
    * True if Query Insights feature is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#query_insights_enabled SqlDatabaseInstance#query_insights_enabled}
    */
    readonly queryInsightsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#query_string_length SqlDatabaseInstance#query_string_length}
    */
    readonly queryStringLength?: number;
    /**
    * True if Query Insights will record application tags from query when enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#record_application_tags SqlDatabaseInstance#record_application_tags}
    */
    readonly recordApplicationTags?: boolean | cdktf.IResolvable;
    /**
    * True if Query Insights will record client address when enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#record_client_address SqlDatabaseInstance#record_client_address}
    */
    readonly recordClientAddress?: boolean | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceSettingsInsightsConfigToTerraform(struct?: SqlDatabaseInstanceSettingsInsightsConfigOutputReference | SqlDatabaseInstanceSettingsInsightsConfig): any;
export declare class SqlDatabaseInstanceSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsInsightsConfig | undefined);
    private _queryInsightsEnabled?;
    get queryInsightsEnabled(): boolean | cdktf.IResolvable;
    set queryInsightsEnabled(value: boolean | cdktf.IResolvable);
    resetQueryInsightsEnabled(): void;
    get queryInsightsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringLength?;
    get queryStringLength(): number;
    set queryStringLength(value: number);
    resetQueryStringLength(): void;
    get queryStringLengthInput(): number | undefined;
    private _recordApplicationTags?;
    get recordApplicationTags(): boolean | cdktf.IResolvable;
    set recordApplicationTags(value: boolean | cdktf.IResolvable);
    resetRecordApplicationTags(): void;
    get recordApplicationTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _recordClientAddress?;
    get recordClientAddress(): boolean | cdktf.IResolvable;
    set recordClientAddress(value: boolean | cdktf.IResolvable);
    resetRecordClientAddress(): void;
    get recordClientAddressInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#expiration_time SqlDatabaseInstance#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#name SqlDatabaseInstance#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#value SqlDatabaseInstance#value}
    */
    readonly value: string;
}
export declare function sqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksToTerraform(struct?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | cdktf.IResolvable): any;
export declare class SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks | cdktf.IResolvable | undefined);
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksOutputReference;
}
export interface SqlDatabaseInstanceSettingsIpConfiguration {
    /**
    * The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#allocated_ip_range SqlDatabaseInstance#allocated_ip_range}
    */
    readonly allocatedIpRange?: string;
    /**
    * Whether this Cloud SQL instance should be assigned a public IPV4 address. At least ipv4_enabled must be enabled or a private_network must be configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ipv4_enabled SqlDatabaseInstance#ipv4_enabled}
    */
    readonly ipv4Enabled?: boolean | cdktf.IResolvable;
    /**
    * The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#private_network SqlDatabaseInstance#private_network}
    */
    readonly privateNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#require_ssl SqlDatabaseInstance#require_ssl}
    */
    readonly requireSsl?: boolean | cdktf.IResolvable;
    /**
    * authorized_networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#authorized_networks SqlDatabaseInstance#authorized_networks}
    */
    readonly authorizedNetworks?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable;
}
export declare function sqlDatabaseInstanceSettingsIpConfigurationToTerraform(struct?: SqlDatabaseInstanceSettingsIpConfigurationOutputReference | SqlDatabaseInstanceSettingsIpConfiguration): any;
export declare class SqlDatabaseInstanceSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsIpConfiguration | undefined);
    private _allocatedIpRange?;
    get allocatedIpRange(): string;
    set allocatedIpRange(value: string);
    resetAllocatedIpRange(): void;
    get allocatedIpRangeInput(): string | undefined;
    private _ipv4Enabled?;
    get ipv4Enabled(): boolean | cdktf.IResolvable;
    set ipv4Enabled(value: boolean | cdktf.IResolvable);
    resetIpv4Enabled(): void;
    get ipv4EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateNetwork?;
    get privateNetwork(): string;
    set privateNetwork(value: string);
    resetPrivateNetwork(): void;
    get privateNetworkInput(): string | undefined;
    private _requireSsl?;
    get requireSsl(): boolean | cdktf.IResolvable;
    set requireSsl(value: boolean | cdktf.IResolvable);
    resetRequireSsl(): void;
    get requireSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizedNetworks;
    get authorizedNetworks(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworksList;
    putAuthorizedNetworks(value: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | cdktf.IResolvable): void;
    resetAuthorizedNetworks(): void;
    get authorizedNetworksInput(): cdktf.IResolvable | SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
}
export interface SqlDatabaseInstanceSettingsLocationPreference {
    /**
    * A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#follow_gae_application SqlDatabaseInstance#follow_gae_application}
    */
    readonly followGaeApplication?: string;
    /**
    * The preferred Compute Engine zone for the secondary/failover
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#secondary_zone SqlDatabaseInstance#secondary_zone}
    */
    readonly secondaryZone?: string;
    /**
    * The preferred compute engine zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#zone SqlDatabaseInstance#zone}
    */
    readonly zone?: string;
}
export declare function sqlDatabaseInstanceSettingsLocationPreferenceToTerraform(struct?: SqlDatabaseInstanceSettingsLocationPreferenceOutputReference | SqlDatabaseInstanceSettingsLocationPreference): any;
export declare class SqlDatabaseInstanceSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsLocationPreference | undefined);
    private _followGaeApplication?;
    get followGaeApplication(): string;
    set followGaeApplication(value: string);
    resetFollowGaeApplication(): void;
    get followGaeApplicationInput(): string | undefined;
    private _secondaryZone?;
    get secondaryZone(): string;
    set secondaryZone(value: string);
    resetSecondaryZone(): void;
    get secondaryZoneInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsMaintenanceWindow {
    /**
    * Day of week (1-7), starting on Monday
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#day SqlDatabaseInstance#day}
    */
    readonly day?: number;
    /**
    * Hour of day (0-23), ignored if day not set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#hour SqlDatabaseInstance#hour}
    */
    readonly hour?: number;
    /**
    * Receive updates earlier (canary) or later (stable)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#update_track SqlDatabaseInstance#update_track}
    */
    readonly updateTrack?: string;
}
export declare function sqlDatabaseInstanceSettingsMaintenanceWindowToTerraform(struct?: SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference | SqlDatabaseInstanceSettingsMaintenanceWindow): any;
export declare class SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsMaintenanceWindow | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    resetDay(): void;
    get dayInput(): number | undefined;
    private _hour?;
    get hour(): number;
    set hour(value: number);
    resetHour(): void;
    get hourInput(): number | undefined;
    private _updateTrack?;
    get updateTrack(): string;
    set updateTrack(value: string);
    resetUpdateTrack(): void;
    get updateTrackInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettingsPasswordValidationPolicy {
    /**
    * Password complexity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#complexity SqlDatabaseInstance#complexity}
    */
    readonly complexity?: string;
    /**
    * Disallow username as a part of the password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disallow_username_substring SqlDatabaseInstance#disallow_username_substring}
    */
    readonly disallowUsernameSubstring?: boolean | cdktf.IResolvable;
    /**
    * Whether the password policy is enabled or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#enable_password_policy SqlDatabaseInstance#enable_password_policy}
    */
    readonly enablePasswordPolicy: boolean | cdktf.IResolvable;
    /**
    * Minimum number of characters allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#min_length SqlDatabaseInstance#min_length}
    */
    readonly minLength?: number;
    /**
    * Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#password_change_interval SqlDatabaseInstance#password_change_interval}
    */
    readonly passwordChangeInterval?: string;
    /**
    * Number of previous passwords that cannot be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#reuse_interval SqlDatabaseInstance#reuse_interval}
    */
    readonly reuseInterval?: number;
}
export declare function sqlDatabaseInstanceSettingsPasswordValidationPolicyToTerraform(struct?: SqlDatabaseInstanceSettingsPasswordValidationPolicyOutputReference | SqlDatabaseInstanceSettingsPasswordValidationPolicy): any;
export declare class SqlDatabaseInstanceSettingsPasswordValidationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsPasswordValidationPolicy | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsPasswordValidationPolicy | undefined);
    private _complexity?;
    get complexity(): string;
    set complexity(value: string);
    resetComplexity(): void;
    get complexityInput(): string | undefined;
    private _disallowUsernameSubstring?;
    get disallowUsernameSubstring(): boolean | cdktf.IResolvable;
    set disallowUsernameSubstring(value: boolean | cdktf.IResolvable);
    resetDisallowUsernameSubstring(): void;
    get disallowUsernameSubstringInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePasswordPolicy?;
    get enablePasswordPolicy(): boolean | cdktf.IResolvable;
    set enablePasswordPolicy(value: boolean | cdktf.IResolvable);
    get enablePasswordPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _passwordChangeInterval?;
    get passwordChangeInterval(): string;
    set passwordChangeInterval(value: string);
    resetPasswordChangeInterval(): void;
    get passwordChangeIntervalInput(): string | undefined;
    private _reuseInterval?;
    get reuseInterval(): number;
    set reuseInterval(value: number);
    resetReuseInterval(): void;
    get reuseIntervalInput(): number | undefined;
}
export interface SqlDatabaseInstanceSettingsSqlServerAuditConfig {
    /**
    * The name of the destination bucket (e.g., gs://mybucket).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#bucket SqlDatabaseInstance#bucket}
    */
    readonly bucket: string;
    /**
    * How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#retention_interval SqlDatabaseInstance#retention_interval}
    */
    readonly retentionInterval?: string;
    /**
    * How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#upload_interval SqlDatabaseInstance#upload_interval}
    */
    readonly uploadInterval?: string;
}
export declare function sqlDatabaseInstanceSettingsSqlServerAuditConfigToTerraform(struct?: SqlDatabaseInstanceSettingsSqlServerAuditConfigOutputReference | SqlDatabaseInstanceSettingsSqlServerAuditConfig): any;
export declare class SqlDatabaseInstanceSettingsSqlServerAuditConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettingsSqlServerAuditConfig | undefined;
    set internalValue(value: SqlDatabaseInstanceSettingsSqlServerAuditConfig | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _retentionInterval?;
    get retentionInterval(): string;
    set retentionInterval(value: string);
    resetRetentionInterval(): void;
    get retentionIntervalInput(): string | undefined;
    private _uploadInterval?;
    get uploadInterval(): string;
    set uploadInterval(value: string);
    resetUploadInterval(): void;
    get uploadIntervalInput(): string | undefined;
}
export interface SqlDatabaseInstanceSettings {
    /**
    * This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#activation_policy SqlDatabaseInstance#activation_policy}
    */
    readonly activationPolicy?: string;
    /**
    * The availability type of the Cloud SQL instance, high availability
  (REGIONAL) or single zone (ZONAL). For all instances, ensure that
  settings.backup_configuration.enabled is set to true.
  For MySQL instances, ensure that settings.backup_configuration.binary_log_enabled is set to true.
  For Postgres instances, ensure that settings.backup_configuration.point_in_time_recovery_enabled
  is set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#availability_type SqlDatabaseInstance#availability_type}
    */
    readonly availabilityType?: string;
    /**
    * The name of server instance collation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#collation SqlDatabaseInstance#collation}
    */
    readonly collation?: string;
    /**
    * Enables auto-resizing of the storage size. Defaults to true. Set to false if you want to set disk_size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_autoresize SqlDatabaseInstance#disk_autoresize}
    */
    readonly diskAutoresize?: boolean | cdktf.IResolvable;
    /**
    * The maximum size, in GB, to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_autoresize_limit SqlDatabaseInstance#disk_autoresize_limit}
    */
    readonly diskAutoresizeLimit?: number;
    /**
    * The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. If you want to set this field, set disk_autoresize to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_size SqlDatabaseInstance#disk_size}
    */
    readonly diskSize?: number;
    /**
    * The type of data disk: PD_SSD or PD_HDD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#disk_type SqlDatabaseInstance#disk_type}
    */
    readonly diskType?: string;
    /**
    * Pricing plan for this instance, can only be PER_USE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#pricing_plan SqlDatabaseInstance#pricing_plan}
    */
    readonly pricingPlan?: string;
    /**
    * The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#tier SqlDatabaseInstance#tier}
    */
    readonly tier: string;
    /**
    * A set of key/value user label pairs to assign to the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#user_labels SqlDatabaseInstance#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * active_directory_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#active_directory_config SqlDatabaseInstance#active_directory_config}
    */
    readonly activeDirectoryConfig?: SqlDatabaseInstanceSettingsActiveDirectoryConfig;
    /**
    * backup_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#backup_configuration SqlDatabaseInstance#backup_configuration}
    */
    readonly backupConfiguration?: SqlDatabaseInstanceSettingsBackupConfiguration;
    /**
    * database_flags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#database_flags SqlDatabaseInstance#database_flags}
    */
    readonly databaseFlags?: SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable;
    /**
    * insights_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#insights_config SqlDatabaseInstance#insights_config}
    */
    readonly insightsConfig?: SqlDatabaseInstanceSettingsInsightsConfig;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#ip_configuration SqlDatabaseInstance#ip_configuration}
    */
    readonly ipConfiguration?: SqlDatabaseInstanceSettingsIpConfiguration;
    /**
    * location_preference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#location_preference SqlDatabaseInstance#location_preference}
    */
    readonly locationPreference?: SqlDatabaseInstanceSettingsLocationPreference;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#maintenance_window SqlDatabaseInstance#maintenance_window}
    */
    readonly maintenanceWindow?: SqlDatabaseInstanceSettingsMaintenanceWindow;
    /**
    * password_validation_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#password_validation_policy SqlDatabaseInstance#password_validation_policy}
    */
    readonly passwordValidationPolicy?: SqlDatabaseInstanceSettingsPasswordValidationPolicy;
    /**
    * sql_server_audit_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#sql_server_audit_config SqlDatabaseInstance#sql_server_audit_config}
    */
    readonly sqlServerAuditConfig?: SqlDatabaseInstanceSettingsSqlServerAuditConfig;
}
export declare function sqlDatabaseInstanceSettingsToTerraform(struct?: SqlDatabaseInstanceSettingsOutputReference | SqlDatabaseInstanceSettings): any;
export declare class SqlDatabaseInstanceSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceSettings | undefined;
    set internalValue(value: SqlDatabaseInstanceSettings | undefined);
    private _activationPolicy?;
    get activationPolicy(): string;
    set activationPolicy(value: string);
    resetActivationPolicy(): void;
    get activationPolicyInput(): string | undefined;
    private _availabilityType?;
    get availabilityType(): string;
    set availabilityType(value: string);
    resetAvailabilityType(): void;
    get availabilityTypeInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _diskAutoresize?;
    get diskAutoresize(): boolean | cdktf.IResolvable;
    set diskAutoresize(value: boolean | cdktf.IResolvable);
    resetDiskAutoresize(): void;
    get diskAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresizeLimit?;
    get diskAutoresizeLimit(): number;
    set diskAutoresizeLimit(value: number);
    resetDiskAutoresizeLimit(): void;
    get diskAutoresizeLimitInput(): number | undefined;
    private _diskSize?;
    get diskSize(): number;
    set diskSize(value: number);
    resetDiskSize(): void;
    get diskSizeInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _pricingPlan?;
    get pricingPlan(): string;
    set pricingPlan(value: string);
    resetPricingPlan(): void;
    get pricingPlanInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get version(): number;
    private _activeDirectoryConfig;
    get activeDirectoryConfig(): SqlDatabaseInstanceSettingsActiveDirectoryConfigOutputReference;
    putActiveDirectoryConfig(value: SqlDatabaseInstanceSettingsActiveDirectoryConfig): void;
    resetActiveDirectoryConfig(): void;
    get activeDirectoryConfigInput(): SqlDatabaseInstanceSettingsActiveDirectoryConfig | undefined;
    private _backupConfiguration;
    get backupConfiguration(): SqlDatabaseInstanceSettingsBackupConfigurationOutputReference;
    putBackupConfiguration(value: SqlDatabaseInstanceSettingsBackupConfiguration): void;
    resetBackupConfiguration(): void;
    get backupConfigurationInput(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    private _databaseFlags;
    get databaseFlags(): SqlDatabaseInstanceSettingsDatabaseFlagsList;
    putDatabaseFlags(value: SqlDatabaseInstanceSettingsDatabaseFlags[] | cdktf.IResolvable): void;
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): cdktf.IResolvable | SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    private _insightsConfig;
    get insightsConfig(): SqlDatabaseInstanceSettingsInsightsConfigOutputReference;
    putInsightsConfig(value: SqlDatabaseInstanceSettingsInsightsConfig): void;
    resetInsightsConfig(): void;
    get insightsConfigInput(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    private _ipConfiguration;
    get ipConfiguration(): SqlDatabaseInstanceSettingsIpConfigurationOutputReference;
    putIpConfiguration(value: SqlDatabaseInstanceSettingsIpConfiguration): void;
    resetIpConfiguration(): void;
    get ipConfigurationInput(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    private _locationPreference;
    get locationPreference(): SqlDatabaseInstanceSettingsLocationPreferenceOutputReference;
    putLocationPreference(value: SqlDatabaseInstanceSettingsLocationPreference): void;
    resetLocationPreference(): void;
    get locationPreferenceInput(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: SqlDatabaseInstanceSettingsMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
    private _passwordValidationPolicy;
    get passwordValidationPolicy(): SqlDatabaseInstanceSettingsPasswordValidationPolicyOutputReference;
    putPasswordValidationPolicy(value: SqlDatabaseInstanceSettingsPasswordValidationPolicy): void;
    resetPasswordValidationPolicy(): void;
    get passwordValidationPolicyInput(): SqlDatabaseInstanceSettingsPasswordValidationPolicy | undefined;
    private _sqlServerAuditConfig;
    get sqlServerAuditConfig(): SqlDatabaseInstanceSettingsSqlServerAuditConfigOutputReference;
    putSqlServerAuditConfig(value: SqlDatabaseInstanceSettingsSqlServerAuditConfig): void;
    resetSqlServerAuditConfig(): void;
    get sqlServerAuditConfigInput(): SqlDatabaseInstanceSettingsSqlServerAuditConfig | undefined;
}
export interface SqlDatabaseInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#create SqlDatabaseInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#delete SqlDatabaseInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance#update SqlDatabaseInstance#update}
    */
    readonly update?: string;
}
export declare function sqlDatabaseInstanceTimeoutsToTerraform(struct?: SqlDatabaseInstanceTimeoutsOutputReference | SqlDatabaseInstanceTimeouts | cdktf.IResolvable): any;
export declare class SqlDatabaseInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlDatabaseInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance google_sql_database_instance}
*/
export declare class SqlDatabaseInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_database_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance google_sql_database_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlDatabaseInstanceConfig
    */
    constructor(scope: Construct, id: string, config: SqlDatabaseInstanceConfig);
    get connectionName(): string;
    private _databaseVersion?;
    get databaseVersion(): string;
    set databaseVersion(value: string);
    get databaseVersionInput(): string | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    get firstIpAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress;
    get ipAddress(): SqlDatabaseInstanceIpAddressList;
    private _masterInstanceName?;
    get masterInstanceName(): string;
    set masterInstanceName(value: string);
    resetMasterInstanceName(): void;
    get masterInstanceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicIpAddress(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rootPassword?;
    get rootPassword(): string;
    set rootPassword(value: string);
    resetRootPassword(): void;
    get rootPasswordInput(): string | undefined;
    get selfLink(): string;
    private _serverCaCert;
    get serverCaCert(): SqlDatabaseInstanceServerCaCertList;
    get serviceAccountEmailAddress(): string;
    private _clone;
    get clone(): SqlDatabaseInstanceCloneOutputReference;
    putClone(value: SqlDatabaseInstanceClone): void;
    resetClone(): void;
    get cloneInput(): SqlDatabaseInstanceClone | undefined;
    private _replicaConfiguration;
    get replicaConfiguration(): SqlDatabaseInstanceReplicaConfigurationOutputReference;
    putReplicaConfiguration(value: SqlDatabaseInstanceReplicaConfiguration): void;
    resetReplicaConfiguration(): void;
    get replicaConfigurationInput(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    private _restoreBackupContext;
    get restoreBackupContext(): SqlDatabaseInstanceRestoreBackupContextOutputReference;
    putRestoreBackupContext(value: SqlDatabaseInstanceRestoreBackupContext): void;
    resetRestoreBackupContext(): void;
    get restoreBackupContextInput(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    private _settings;
    get settings(): SqlDatabaseInstanceSettingsOutputReference;
    putSettings(value: SqlDatabaseInstanceSettings): void;
    resetSettings(): void;
    get settingsInput(): SqlDatabaseInstanceSettings | undefined;
    private _timeouts;
    get timeouts(): SqlDatabaseInstanceTimeoutsOutputReference;
    putTimeouts(value: SqlDatabaseInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlDatabaseInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
