import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The charset value. See MySQL's
  [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
  and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
  for more details and supported values. Postgres databases only support
  a value of 'UTF8' at creation time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#charset SqlDatabase#charset}
    */
    readonly charset?: string;
    /**
    * The collation value. See MySQL's
  [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
  and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
  for more details and supported values. Postgres databases only support
  a value of 'en_US.UTF8' at creation time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#collation SqlDatabase#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#id SqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. This does not include the project
  ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#instance SqlDatabase#instance}
    */
    readonly instance: string;
    /**
    * The name of the database in the Cloud SQL instance.
  This does not include the project ID or instance name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#name SqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#project SqlDatabase#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#timeouts SqlDatabase#timeouts}
    */
    readonly timeouts?: SqlDatabaseTimeouts;
}
export interface SqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#create SqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#delete SqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database#update SqlDatabase#update}
    */
    readonly update?: string;
}
export declare function sqlDatabaseTimeoutsToTerraform(struct?: SqlDatabaseTimeoutsOutputReference | SqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class SqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database google_sql_database}
*/
export declare class SqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database google_sql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: SqlDatabaseConfig);
    private _charset?;
    get charset(): string;
    set charset(value: string);
    resetCharset(): void;
    get charsetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): SqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: SqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
