import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#bucket StorageBucketIamMember#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#id StorageBucketIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#member StorageBucketIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#role StorageBucketIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#condition StorageBucketIamMember#condition}
    */
    readonly condition?: StorageBucketIamMemberCondition;
}
export interface StorageBucketIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#description StorageBucketIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#expression StorageBucketIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member#title StorageBucketIamMember#title}
    */
    readonly title: string;
}
export declare function storageBucketIamMemberConditionToTerraform(struct?: StorageBucketIamMemberConditionOutputReference | StorageBucketIamMemberCondition): any;
export declare class StorageBucketIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketIamMemberCondition | undefined;
    set internalValue(value: StorageBucketIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member google_storage_bucket_iam_member}
*/
export declare class StorageBucketIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_member google_storage_bucket_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketIamMemberConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): StorageBucketIamMemberConditionOutputReference;
    putCondition(value: StorageBucketIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): StorageBucketIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
