import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageTransferJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique description to identify the Transfer Job.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#description StorageTransferJob#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#id StorageTransferJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#project StorageTransferJob#project}
    */
    readonly project?: string;
    /**
    * Status of the job. Default: ENABLED. NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#status StorageTransferJob#status}
    */
    readonly status?: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#schedule StorageTransferJob#schedule}
    */
    readonly schedule?: StorageTransferJobSchedule;
    /**
    * transfer_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#transfer_spec StorageTransferJob#transfer_spec}
    */
    readonly transferSpec: StorageTransferJobTransferSpec;
}
export interface StorageTransferJobScheduleScheduleEndDate {
    /**
    * Day of month. Must be from 1 to 31 and valid for the year and month.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#day StorageTransferJob#day}
    */
    readonly day: number;
    /**
    * Month of year. Must be from 1 to 12.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#month StorageTransferJob#month}
    */
    readonly month: number;
    /**
    * Year of date. Must be from 1 to 9999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#year StorageTransferJob#year}
    */
    readonly year: number;
}
export declare function storageTransferJobScheduleScheduleEndDateToTerraform(struct?: StorageTransferJobScheduleScheduleEndDateOutputReference | StorageTransferJobScheduleScheduleEndDate): any;
export declare class StorageTransferJobScheduleScheduleEndDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobScheduleScheduleEndDate | undefined;
    set internalValue(value: StorageTransferJobScheduleScheduleEndDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface StorageTransferJobScheduleScheduleStartDate {
    /**
    * Day of month. Must be from 1 to 31 and valid for the year and month.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#day StorageTransferJob#day}
    */
    readonly day: number;
    /**
    * Month of year. Must be from 1 to 12.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#month StorageTransferJob#month}
    */
    readonly month: number;
    /**
    * Year of date. Must be from 1 to 9999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#year StorageTransferJob#year}
    */
    readonly year: number;
}
export declare function storageTransferJobScheduleScheduleStartDateToTerraform(struct?: StorageTransferJobScheduleScheduleStartDateOutputReference | StorageTransferJobScheduleScheduleStartDate): any;
export declare class StorageTransferJobScheduleScheduleStartDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobScheduleScheduleStartDate | undefined;
    set internalValue(value: StorageTransferJobScheduleScheduleStartDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface StorageTransferJobScheduleStartTimeOfDay {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#hours StorageTransferJob#hours}
    */
    readonly hours: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#minutes StorageTransferJob#minutes}
    */
    readonly minutes: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#nanos StorageTransferJob#nanos}
    */
    readonly nanos: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#seconds StorageTransferJob#seconds}
    */
    readonly seconds: number;
}
export declare function storageTransferJobScheduleStartTimeOfDayToTerraform(struct?: StorageTransferJobScheduleStartTimeOfDayOutputReference | StorageTransferJobScheduleStartTimeOfDay): any;
export declare class StorageTransferJobScheduleStartTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobScheduleStartTimeOfDay | undefined;
    set internalValue(value: StorageTransferJobScheduleStartTimeOfDay | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface StorageTransferJobSchedule {
    /**
    * Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#repeat_interval StorageTransferJob#repeat_interval}
    */
    readonly repeatInterval?: string;
    /**
    * schedule_end_date block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#schedule_end_date StorageTransferJob#schedule_end_date}
    */
    readonly scheduleEndDate?: StorageTransferJobScheduleScheduleEndDate;
    /**
    * schedule_start_date block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#schedule_start_date StorageTransferJob#schedule_start_date}
    */
    readonly scheduleStartDate: StorageTransferJobScheduleScheduleStartDate;
    /**
    * start_time_of_day block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#start_time_of_day StorageTransferJob#start_time_of_day}
    */
    readonly startTimeOfDay?: StorageTransferJobScheduleStartTimeOfDay;
}
export declare function storageTransferJobScheduleToTerraform(struct?: StorageTransferJobScheduleOutputReference | StorageTransferJobSchedule): any;
export declare class StorageTransferJobScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobSchedule | undefined;
    set internalValue(value: StorageTransferJobSchedule | undefined);
    private _repeatInterval?;
    get repeatInterval(): string;
    set repeatInterval(value: string);
    resetRepeatInterval(): void;
    get repeatIntervalInput(): string | undefined;
    private _scheduleEndDate;
    get scheduleEndDate(): StorageTransferJobScheduleScheduleEndDateOutputReference;
    putScheduleEndDate(value: StorageTransferJobScheduleScheduleEndDate): void;
    resetScheduleEndDate(): void;
    get scheduleEndDateInput(): StorageTransferJobScheduleScheduleEndDate | undefined;
    private _scheduleStartDate;
    get scheduleStartDate(): StorageTransferJobScheduleScheduleStartDateOutputReference;
    putScheduleStartDate(value: StorageTransferJobScheduleScheduleStartDate): void;
    get scheduleStartDateInput(): StorageTransferJobScheduleScheduleStartDate | undefined;
    private _startTimeOfDay;
    get startTimeOfDay(): StorageTransferJobScheduleStartTimeOfDayOutputReference;
    putStartTimeOfDay(value: StorageTransferJobScheduleStartTimeOfDay): void;
    resetStartTimeOfDay(): void;
    get startTimeOfDayInput(): StorageTransferJobScheduleStartTimeOfDay | undefined;
}
export interface StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey {
    /**
    * AWS Key ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#access_key_id StorageTransferJob#access_key_id}
    */
    readonly accessKeyId: string;
    /**
    * AWS Secret Access Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#secret_access_key StorageTransferJob#secret_access_key}
    */
    readonly secretAccessKey: string;
}
export declare function storageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyToTerraform(struct?: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference | StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): any;
export declare class StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
    set internalValue(value: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecAwsS3DataSource {
    /**
    * S3 Bucket name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#bucket_name StorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#role_arn StorageTransferJob#role_arn}
    */
    readonly roleArn?: string;
    /**
    * aws_access_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#aws_access_key StorageTransferJob#aws_access_key}
    */
    readonly awsAccessKey?: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey;
}
export declare function storageTransferJobTransferSpecAwsS3DataSourceToTerraform(struct?: StorageTransferJobTransferSpecAwsS3DataSourceOutputReference | StorageTransferJobTransferSpecAwsS3DataSource): any;
export declare class StorageTransferJobTransferSpecAwsS3DataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecAwsS3DataSource | undefined;
    set internalValue(value: StorageTransferJobTransferSpecAwsS3DataSource | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    private _awsAccessKey;
    get awsAccessKey(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference;
    putAwsAccessKey(value: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): void;
    resetAwsAccessKey(): void;
    get awsAccessKeyInput(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
}
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials {
    /**
    * Azure shared access signature.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#sas_token StorageTransferJob#sas_token}
    */
    readonly sasToken: string;
}
export declare function storageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsToTerraform(struct?: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference | StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): any;
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
    set internalValue(value: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined);
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    get sasTokenInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSource {
    /**
    * The container to transfer from the Azure Storage account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#container StorageTransferJob#container}
    */
    readonly container: string;
    /**
    * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#path StorageTransferJob#path}
    */
    readonly path?: string;
    /**
    * The name of the Azure Storage account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#storage_account StorageTransferJob#storage_account}
    */
    readonly storageAccount: string;
    /**
    * azure_credentials block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#azure_credentials StorageTransferJob#azure_credentials}
    */
    readonly azureCredentials: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials;
}
export declare function storageTransferJobTransferSpecAzureBlobStorageDataSourceToTerraform(struct?: StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference | StorageTransferJobTransferSpecAzureBlobStorageDataSource): any;
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    set internalValue(value: StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _storageAccount?;
    get storageAccount(): string;
    set storageAccount(value: string);
    get storageAccountInput(): string | undefined;
    private _azureCredentials;
    get azureCredentials(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference;
    putAzureCredentials(value: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): void;
    get azureCredentialsInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
}
export interface StorageTransferJobTransferSpecGcsDataSink {
    /**
    * Google Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#bucket_name StorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Google Cloud Storage path in bucket to transfer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#path StorageTransferJob#path}
    */
    readonly path?: string;
}
export declare function storageTransferJobTransferSpecGcsDataSinkToTerraform(struct?: StorageTransferJobTransferSpecGcsDataSinkOutputReference | StorageTransferJobTransferSpecGcsDataSink): any;
export declare class StorageTransferJobTransferSpecGcsDataSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecGcsDataSink | undefined;
    set internalValue(value: StorageTransferJobTransferSpecGcsDataSink | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecGcsDataSource {
    /**
    * Google Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#bucket_name StorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Google Cloud Storage path in bucket to transfer
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#path StorageTransferJob#path}
    */
    readonly path?: string;
}
export declare function storageTransferJobTransferSpecGcsDataSourceToTerraform(struct?: StorageTransferJobTransferSpecGcsDataSourceOutputReference | StorageTransferJobTransferSpecGcsDataSource): any;
export declare class StorageTransferJobTransferSpecGcsDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecGcsDataSource | undefined;
    set internalValue(value: StorageTransferJobTransferSpecGcsDataSource | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecHttpDataSource {
    /**
    * The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#list_url StorageTransferJob#list_url}
    */
    readonly listUrl: string;
}
export declare function storageTransferJobTransferSpecHttpDataSourceToTerraform(struct?: StorageTransferJobTransferSpecHttpDataSourceOutputReference | StorageTransferJobTransferSpecHttpDataSource): any;
export declare class StorageTransferJobTransferSpecHttpDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecHttpDataSource | undefined;
    set internalValue(value: StorageTransferJobTransferSpecHttpDataSource | undefined);
    private _listUrl?;
    get listUrl(): string;
    set listUrl(value: string);
    get listUrlInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecObjectConditions {
    /**
    * exclude_prefixes must follow the requirements described for include_prefixes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#exclude_prefixes StorageTransferJob#exclude_prefixes}
    */
    readonly excludePrefixes?: string[];
    /**
    * If include_refixes is specified, objects that satisfy the object conditions must have names that start with one of the include_prefixes and that do not start with any of the exclude_prefixes. If include_prefixes is not specified, all objects except those that have names starting with one of the exclude_prefixes must satisfy the object conditions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#include_prefixes StorageTransferJob#include_prefixes}
    */
    readonly includePrefixes?: string[];
    /**
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#max_time_elapsed_since_last_modification StorageTransferJob#max_time_elapsed_since_last_modification}
    */
    readonly maxTimeElapsedSinceLastModification?: string;
    /**
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#min_time_elapsed_since_last_modification StorageTransferJob#min_time_elapsed_since_last_modification}
    */
    readonly minTimeElapsedSinceLastModification?: string;
}
export declare function storageTransferJobTransferSpecObjectConditionsToTerraform(struct?: StorageTransferJobTransferSpecObjectConditionsOutputReference | StorageTransferJobTransferSpecObjectConditions): any;
export declare class StorageTransferJobTransferSpecObjectConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecObjectConditions | undefined;
    set internalValue(value: StorageTransferJobTransferSpecObjectConditions | undefined);
    private _excludePrefixes?;
    get excludePrefixes(): string[];
    set excludePrefixes(value: string[]);
    resetExcludePrefixes(): void;
    get excludePrefixesInput(): string[] | undefined;
    private _includePrefixes?;
    get includePrefixes(): string[];
    set includePrefixes(value: string[]);
    resetIncludePrefixes(): void;
    get includePrefixesInput(): string[] | undefined;
    private _maxTimeElapsedSinceLastModification?;
    get maxTimeElapsedSinceLastModification(): string;
    set maxTimeElapsedSinceLastModification(value: string);
    resetMaxTimeElapsedSinceLastModification(): void;
    get maxTimeElapsedSinceLastModificationInput(): string | undefined;
    private _minTimeElapsedSinceLastModification?;
    get minTimeElapsedSinceLastModification(): string;
    set minTimeElapsedSinceLastModification(value: string);
    resetMinTimeElapsedSinceLastModification(): void;
    get minTimeElapsedSinceLastModificationInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecPosixDataSink {
    /**
    * Root directory path to the filesystem.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#root_directory StorageTransferJob#root_directory}
    */
    readonly rootDirectory: string;
}
export declare function storageTransferJobTransferSpecPosixDataSinkToTerraform(struct?: StorageTransferJobTransferSpecPosixDataSinkOutputReference | StorageTransferJobTransferSpecPosixDataSink): any;
export declare class StorageTransferJobTransferSpecPosixDataSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecPosixDataSink | undefined;
    set internalValue(value: StorageTransferJobTransferSpecPosixDataSink | undefined);
    private _rootDirectory?;
    get rootDirectory(): string;
    set rootDirectory(value: string);
    get rootDirectoryInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecPosixDataSource {
    /**
    * Root directory path to the filesystem.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#root_directory StorageTransferJob#root_directory}
    */
    readonly rootDirectory: string;
}
export declare function storageTransferJobTransferSpecPosixDataSourceToTerraform(struct?: StorageTransferJobTransferSpecPosixDataSourceOutputReference | StorageTransferJobTransferSpecPosixDataSource): any;
export declare class StorageTransferJobTransferSpecPosixDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecPosixDataSource | undefined;
    set internalValue(value: StorageTransferJobTransferSpecPosixDataSource | undefined);
    private _rootDirectory?;
    get rootDirectory(): string;
    set rootDirectory(value: string);
    get rootDirectoryInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecTransferOptions {
    /**
    * Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and delete_objects_unique_in_sink are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#delete_objects_from_source_after_transfer StorageTransferJob#delete_objects_from_source_after_transfer}
    */
    readonly deleteObjectsFromSourceAfterTransfer?: boolean | cdktf.IResolvable;
    /**
    * Whether objects that exist only in the sink should be deleted. Note that this option and delete_objects_from_source_after_transfer are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#delete_objects_unique_in_sink StorageTransferJob#delete_objects_unique_in_sink}
    */
    readonly deleteObjectsUniqueInSink?: boolean | cdktf.IResolvable;
    /**
    * Whether overwriting objects that already exist in the sink is allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#overwrite_objects_already_existing_in_sink StorageTransferJob#overwrite_objects_already_existing_in_sink}
    */
    readonly overwriteObjectsAlreadyExistingInSink?: boolean | cdktf.IResolvable;
    /**
    * When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwriteObjectsAlreadyExistingInSink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#overwrite_when StorageTransferJob#overwrite_when}
    */
    readonly overwriteWhen?: string;
}
export declare function storageTransferJobTransferSpecTransferOptionsToTerraform(struct?: StorageTransferJobTransferSpecTransferOptionsOutputReference | StorageTransferJobTransferSpecTransferOptions): any;
export declare class StorageTransferJobTransferSpecTransferOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpecTransferOptions | undefined;
    set internalValue(value: StorageTransferJobTransferSpecTransferOptions | undefined);
    private _deleteObjectsFromSourceAfterTransfer?;
    get deleteObjectsFromSourceAfterTransfer(): boolean | cdktf.IResolvable;
    set deleteObjectsFromSourceAfterTransfer(value: boolean | cdktf.IResolvable);
    resetDeleteObjectsFromSourceAfterTransfer(): void;
    get deleteObjectsFromSourceAfterTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteObjectsUniqueInSink?;
    get deleteObjectsUniqueInSink(): boolean | cdktf.IResolvable;
    set deleteObjectsUniqueInSink(value: boolean | cdktf.IResolvable);
    resetDeleteObjectsUniqueInSink(): void;
    get deleteObjectsUniqueInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteObjectsAlreadyExistingInSink?;
    get overwriteObjectsAlreadyExistingInSink(): boolean | cdktf.IResolvable;
    set overwriteObjectsAlreadyExistingInSink(value: boolean | cdktf.IResolvable);
    resetOverwriteObjectsAlreadyExistingInSink(): void;
    get overwriteObjectsAlreadyExistingInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteWhen?;
    get overwriteWhen(): string;
    set overwriteWhen(value: string);
    resetOverwriteWhen(): void;
    get overwriteWhenInput(): string | undefined;
}
export interface StorageTransferJobTransferSpec {
    /**
    * aws_s3_data_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#aws_s3_data_source StorageTransferJob#aws_s3_data_source}
    */
    readonly awsS3DataSource?: StorageTransferJobTransferSpecAwsS3DataSource;
    /**
    * azure_blob_storage_data_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#azure_blob_storage_data_source StorageTransferJob#azure_blob_storage_data_source}
    */
    readonly azureBlobStorageDataSource?: StorageTransferJobTransferSpecAzureBlobStorageDataSource;
    /**
    * gcs_data_sink block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#gcs_data_sink StorageTransferJob#gcs_data_sink}
    */
    readonly gcsDataSink?: StorageTransferJobTransferSpecGcsDataSink;
    /**
    * gcs_data_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#gcs_data_source StorageTransferJob#gcs_data_source}
    */
    readonly gcsDataSource?: StorageTransferJobTransferSpecGcsDataSource;
    /**
    * http_data_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#http_data_source StorageTransferJob#http_data_source}
    */
    readonly httpDataSource?: StorageTransferJobTransferSpecHttpDataSource;
    /**
    * object_conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#object_conditions StorageTransferJob#object_conditions}
    */
    readonly objectConditions?: StorageTransferJobTransferSpecObjectConditions;
    /**
    * posix_data_sink block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#posix_data_sink StorageTransferJob#posix_data_sink}
    */
    readonly posixDataSink?: StorageTransferJobTransferSpecPosixDataSink;
    /**
    * posix_data_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#posix_data_source StorageTransferJob#posix_data_source}
    */
    readonly posixDataSource?: StorageTransferJobTransferSpecPosixDataSource;
    /**
    * transfer_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job#transfer_options StorageTransferJob#transfer_options}
    */
    readonly transferOptions?: StorageTransferJobTransferSpecTransferOptions;
}
export declare function storageTransferJobTransferSpecToTerraform(struct?: StorageTransferJobTransferSpecOutputReference | StorageTransferJobTransferSpec): any;
export declare class StorageTransferJobTransferSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageTransferJobTransferSpec | undefined;
    set internalValue(value: StorageTransferJobTransferSpec | undefined);
    private _awsS3DataSource;
    get awsS3DataSource(): StorageTransferJobTransferSpecAwsS3DataSourceOutputReference;
    putAwsS3DataSource(value: StorageTransferJobTransferSpecAwsS3DataSource): void;
    resetAwsS3DataSource(): void;
    get awsS3DataSourceInput(): StorageTransferJobTransferSpecAwsS3DataSource | undefined;
    private _azureBlobStorageDataSource;
    get azureBlobStorageDataSource(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference;
    putAzureBlobStorageDataSource(value: StorageTransferJobTransferSpecAzureBlobStorageDataSource): void;
    resetAzureBlobStorageDataSource(): void;
    get azureBlobStorageDataSourceInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    private _gcsDataSink;
    get gcsDataSink(): StorageTransferJobTransferSpecGcsDataSinkOutputReference;
    putGcsDataSink(value: StorageTransferJobTransferSpecGcsDataSink): void;
    resetGcsDataSink(): void;
    get gcsDataSinkInput(): StorageTransferJobTransferSpecGcsDataSink | undefined;
    private _gcsDataSource;
    get gcsDataSource(): StorageTransferJobTransferSpecGcsDataSourceOutputReference;
    putGcsDataSource(value: StorageTransferJobTransferSpecGcsDataSource): void;
    resetGcsDataSource(): void;
    get gcsDataSourceInput(): StorageTransferJobTransferSpecGcsDataSource | undefined;
    private _httpDataSource;
    get httpDataSource(): StorageTransferJobTransferSpecHttpDataSourceOutputReference;
    putHttpDataSource(value: StorageTransferJobTransferSpecHttpDataSource): void;
    resetHttpDataSource(): void;
    get httpDataSourceInput(): StorageTransferJobTransferSpecHttpDataSource | undefined;
    private _objectConditions;
    get objectConditions(): StorageTransferJobTransferSpecObjectConditionsOutputReference;
    putObjectConditions(value: StorageTransferJobTransferSpecObjectConditions): void;
    resetObjectConditions(): void;
    get objectConditionsInput(): StorageTransferJobTransferSpecObjectConditions | undefined;
    private _posixDataSink;
    get posixDataSink(): StorageTransferJobTransferSpecPosixDataSinkOutputReference;
    putPosixDataSink(value: StorageTransferJobTransferSpecPosixDataSink): void;
    resetPosixDataSink(): void;
    get posixDataSinkInput(): StorageTransferJobTransferSpecPosixDataSink | undefined;
    private _posixDataSource;
    get posixDataSource(): StorageTransferJobTransferSpecPosixDataSourceOutputReference;
    putPosixDataSource(value: StorageTransferJobTransferSpecPosixDataSource): void;
    resetPosixDataSource(): void;
    get posixDataSourceInput(): StorageTransferJobTransferSpecPosixDataSource | undefined;
    private _transferOptions;
    get transferOptions(): StorageTransferJobTransferSpecTransferOptionsOutputReference;
    putTransferOptions(value: StorageTransferJobTransferSpecTransferOptions): void;
    resetTransferOptions(): void;
    get transferOptionsInput(): StorageTransferJobTransferSpecTransferOptions | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job google_storage_transfer_job}
*/
export declare class StorageTransferJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_transfer_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job google_storage_transfer_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageTransferJobConfig
    */
    constructor(scope: Construct, id: string, config: StorageTransferJobConfig);
    get creationTime(): string;
    get deletionTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastModificationTime(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _schedule;
    get schedule(): StorageTransferJobScheduleOutputReference;
    putSchedule(value: StorageTransferJobSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): StorageTransferJobSchedule | undefined;
    private _transferSpec;
    get transferSpec(): StorageTransferJobTransferSpecOutputReference;
    putTransferSpec(value: StorageTransferJobTransferSpec): void;
    get transferSpecInput(): StorageTransferJobTransferSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
