# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/verifiable-credentials/v1/verifiable-credentials.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class IssueRequest(betterproto.Message):
    document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class IssueResponse(betterproto.Message):
    signed_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class IssueFromTemplateRequest(betterproto.Message):
    template_id: str = betterproto.string_field(1)
    values_json: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class IssueFromTemplateResponse(betterproto.Message):
    document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CreateProofRequest(betterproto.Message):
    """Create Proof"""

    # Optional document that describes which fields should be revealed in the
    # generated proof. If specified, this document must be a valid JSON-LD frame.
    # If this field is not specified, a default reveal document will be used and
    # all fields in the signed document will be revealed
    reveal_document_json: str = betterproto.string_field(1)
    # The item identifier that contains a record with a verifiable credential to
    # be used for generating the proof.
    item_id: str = betterproto.string_field(2, group="proof")
    # A document that contains a valid verifiable credential with an unbound
    # signature. The proof will be derived from this document directly. The
    # document will not be stored in the wallet.
    document_json: str = betterproto.string_field(3, group="proof")


@dataclass(eq=False, repr=False)
class CreateProofResponse(betterproto.Message):
    proof_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class VerifyProofRequest(betterproto.Message):
    """Verify Proof"""

    proof_document_json: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class VerifyProofResponse(betterproto.Message):
    # Indicates if the proof is valid
    is_valid: bool = betterproto.bool_field(1)
    validation_messages: List[str] = betterproto.string_field(2)
    # Validation messages that describe invalid verifications based on different
    # factors, such as schema validation, proof verification, revocation registry
    # membership, etc. If the proof is not valid, this field will contain
    # detailed results where this verification failed.
    validation_results: Dict[str, "ValidationMessage"] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.validation_messages:
            warnings.warn(
                "VerifyProofResponse.validation_messages is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class ValidationMessage(betterproto.Message):
    """validation message that contains results and error messages"""

    # the validation result
    is_valid: bool = betterproto.bool_field(1)
    # set of messages that contain validation results
    messages: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SendRequest(betterproto.Message):
    email: str = betterproto.string_field(1, group="delivery_method")
    did_uri: str = betterproto.string_field(2, group="delivery_method")
    didcomm_invitation_json: str = betterproto.string_field(3, group="delivery_method")
    document_json: str = betterproto.string_field(100)


@dataclass(eq=False, repr=False)
class SendResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateStatusRequest(betterproto.Message):
    """request object to update the status of the revocation entry"""

    # the credential status id
    credential_status_id: str = betterproto.string_field(1)
    # indicates if the status is revoked
    revoked: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class UpdateStatusResponse(betterproto.Message):
    """response object for update of status of revocation entry"""

    pass


@dataclass(eq=False, repr=False)
class CheckStatusRequest(betterproto.Message):
    """request object to check the status of the revocation entry"""

    # the credential status id
    credential_status_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CheckStatusResponse(betterproto.Message):
    """response object for checking the status of revocation entry"""

    # indicates if the status is revoked
    revoked: bool = betterproto.bool_field(1)


class VerifiableCredentialStub(betterproto.ServiceStub):
    async def issue(self, issue_request: "IssueRequest") -> "IssueResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/Issue",
            issue_request,
            IssueResponse,
        )

    async def issue_from_template(
        self, issue_from_template_request: "IssueFromTemplateRequest"
    ) -> "IssueFromTemplateResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/IssueFromTemplate",
            issue_from_template_request,
            IssueFromTemplateResponse,
        )

    async def check_status(
        self, check_status_request: "CheckStatusRequest"
    ) -> "CheckStatusResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/CheckStatus",
            check_status_request,
            CheckStatusResponse,
        )

    async def update_status(
        self, update_status_request: "UpdateStatusRequest"
    ) -> "UpdateStatusResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/UpdateStatus",
            update_status_request,
            UpdateStatusResponse,
        )

    async def create_proof(
        self, create_proof_request: "CreateProofRequest"
    ) -> "CreateProofResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/CreateProof",
            create_proof_request,
            CreateProofResponse,
        )

    async def verify_proof(
        self, verify_proof_request: "VerifyProofRequest"
    ) -> "VerifyProofResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/VerifyProof",
            verify_proof_request,
            VerifyProofResponse,
        )

    async def send(self, send_request: "SendRequest") -> "SendResponse":
        return await self._unary_unary(
            "/services.verifiablecredentials.v1.VerifiableCredential/Send",
            send_request,
            SendResponse,
        )


class VerifiableCredentialBase(ServiceBase):
    async def issue(self, issue_request: "IssueRequest") -> "IssueResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def issue_from_template(
        self, issue_from_template_request: "IssueFromTemplateRequest"
    ) -> "IssueFromTemplateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_status(
        self, check_status_request: "CheckStatusRequest"
    ) -> "CheckStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_status(
        self, update_status_request: "UpdateStatusRequest"
    ) -> "UpdateStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_proof(
        self, create_proof_request: "CreateProofRequest"
    ) -> "CreateProofResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def verify_proof(
        self, verify_proof_request: "VerifyProofRequest"
    ) -> "VerifyProofResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def send(self, send_request: "SendRequest") -> "SendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_issue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.issue(request)
        await stream.send_message(response)

    async def __rpc_issue_from_template(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.issue_from_template(request)
        await stream.send_message(response)

    async def __rpc_check_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.check_status(request)
        await stream.send_message(response)

    async def __rpc_update_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.update_status(request)
        await stream.send_message(response)

    async def __rpc_create_proof(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.create_proof(request)
        await stream.send_message(response)

    async def __rpc_verify_proof(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.verify_proof(request)
        await stream.send_message(response)

    async def __rpc_send(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.send(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.verifiablecredentials.v1.VerifiableCredential/Issue": grpclib.const.Handler(
                self.__rpc_issue,
                grpclib.const.Cardinality.UNARY_UNARY,
                IssueRequest,
                IssueResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/IssueFromTemplate": grpclib.const.Handler(
                self.__rpc_issue_from_template,
                grpclib.const.Cardinality.UNARY_UNARY,
                IssueFromTemplateRequest,
                IssueFromTemplateResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/CheckStatus": grpclib.const.Handler(
                self.__rpc_check_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckStatusRequest,
                CheckStatusResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/UpdateStatus": grpclib.const.Handler(
                self.__rpc_update_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateStatusRequest,
                UpdateStatusResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/CreateProof": grpclib.const.Handler(
                self.__rpc_create_proof,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateProofRequest,
                CreateProofResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/VerifyProof": grpclib.const.Handler(
                self.__rpc_verify_proof,
                grpclib.const.Cardinality.UNARY_UNARY,
                VerifyProofRequest,
                VerifyProofResponse,
            ),
            "/services.verifiablecredentials.v1.VerifiableCredential/Send": grpclib.const.Handler(
                self.__rpc_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                SendRequest,
                SendResponse,
            ),
        }
