function test_suite=test_assert_elements_almost_equal()
    try % assignment of 'localfunctions' is necessary in Matlab >= 2016
        test_functions=localfunctions();
    catch % no problem; early Matlab versions can use initTestSuite fine
    end
    initTestSuite;

function test_assert_elements_almost_equal_exceptions
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                [],'a'),...
                                'assertElementsAlmostEqual:sizeMismatch');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                [1 2],[1;2]),...
                                'assertElementsAlmostEqual:sizeMismatch');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                [1 2],[1 3]),...
                                'assertElementsAlmostEqual:tolExceeded');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                0,1e-10,'absolute',1e-11),...
                                'assertElementsAlmostEqual:tolExceeded');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                0,1e-24,'relative',0,0),...
                                'assertElementsAlmostEqual:tolExceeded');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                NaN,Inf),...
                                'assertElementsAlmostEqual:tolExceeded');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                -Inf,Inf),...
                                'assertElementsAlmostEqual:tolExceeded');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                struct(),struct()),...
                                'assertElementsAlmostEqual:notFloat');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                {1,'a'},{1,'a'}),...
                                'assertElementsAlmostEqual:notFloat');
    assertExceptionThrown(@()assertElementsAlmostEqual(...
                                1,1,'foo',1),...
                                'compareFloats:unrecognizedToleranceType');




function test_assert_elements_almost_equal_passes
    assertElementsAlmostEqual(0,0);
    assertElementsAlmostEqual(0,1e-10);
    assertElementsAlmostEqual(0,1,'relative',1);
    assertElementsAlmostEqual(0,1,'absolute',1);
    assertElementsAlmostEqual(1:6,1e-10+(1:6));
    assertElementsAlmostEqual([1 2;3 4],1e-10+[1 2; 3 4]);
    assertElementsAlmostEqual(NaN,NaN);
    assertElementsAlmostEqual(NaN,NaN,'relative',0);
    assertElementsAlmostEqual(NaN,NaN,'absolute',0);
    assertElementsAlmostEqual(Inf,Inf);
    assertElementsAlmostEqual([-Inf,Inf,NaN,2],[-Inf,Inf,NaN,2]);
    assertElementsAlmostEqual(0,sparse(0));
    assertElementsAlmostEqual(double(0),single(0));

