"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonSchemaType = exports.JsonSchemaVersion = void 0;
var JsonSchemaVersion;
(function (JsonSchemaVersion) {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    JsonSchemaVersion["DRAFT4"] = "http://json-schema.org/draft-04/schema#";
    JsonSchemaVersion["DRAFT7"] = "http://json-schema.org/draft-07/schema#";
})(JsonSchemaVersion = exports.JsonSchemaVersion || (exports.JsonSchemaVersion = {}));
var JsonSchemaType;
(function (JsonSchemaType) {
    JsonSchemaType["NULL"] = "null";
    JsonSchemaType["BOOLEAN"] = "boolean";
    JsonSchemaType["OBJECT"] = "object";
    JsonSchemaType["ARRAY"] = "array";
    JsonSchemaType["NUMBER"] = "number";
    JsonSchemaType["INTEGER"] = "integer";
    JsonSchemaType["STRING"] = "string";
})(JsonSchemaType = exports.JsonSchemaType || (exports.JsonSchemaType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoianNvbi1zY2hlbWEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJqc29uLXNjaGVtYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxJQUFZLGlCQU9YO0FBUEQsV0FBWSxpQkFBaUI7SUFDM0I7OztPQUdHO0lBQ0gsdUVBQWtELENBQUE7SUFDbEQsdUVBQWtELENBQUE7QUFDcEQsQ0FBQyxFQVBXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBTzVCO0FBRUQsSUFBWSxjQVFYO0FBUkQsV0FBWSxjQUFjO0lBQ3hCLCtCQUFhLENBQUE7SUFDYixxQ0FBbUIsQ0FBQTtJQUNuQixtQ0FBaUIsQ0FBQTtJQUNqQixpQ0FBZSxDQUFBO0lBQ2YsbUNBQWlCLENBQUE7SUFDakIscUNBQW1CLENBQUE7SUFDbkIsbUNBQWlCLENBQUE7QUFDbkIsQ0FBQyxFQVJXLGNBQWMsR0FBZCxzQkFBYyxLQUFkLHNCQUFjLFFBUXpCIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGVudW0gSnNvblNjaGVtYVZlcnNpb24ge1xuICAvKipcbiAgICogSW4gQVBJIEdhdGV3YXkgbW9kZWxzIGFyZSBkZWZpbmVkIHVzaW5nIHRoZSBKU09OIHNjaGVtYSBkcmFmdCA0LlxuICAgKiBAc2VlIGh0dHBzOi8vdG9vbHMuaWV0Zi5vcmcvaHRtbC9kcmFmdC16eXAtanNvbi1zY2hlbWEtMDRcbiAgICovXG4gIERSQUZUNCA9ICdodHRwOi8vanNvbi1zY2hlbWEub3JnL2RyYWZ0LTA0L3NjaGVtYSMnLFxuICBEUkFGVDcgPSAnaHR0cDovL2pzb24tc2NoZW1hLm9yZy9kcmFmdC0wNy9zY2hlbWEjJ1xufVxuXG5leHBvcnQgZW51bSBKc29uU2NoZW1hVHlwZSB7XG4gIE5VTEwgPSAnbnVsbCcsXG4gIEJPT0xFQU4gPSAnYm9vbGVhbicsXG4gIE9CSkVDVCA9ICdvYmplY3QnLFxuICBBUlJBWSA9ICdhcnJheScsXG4gIE5VTUJFUiA9ICdudW1iZXInLFxuICBJTlRFR0VSID0gJ2ludGVnZXInLFxuICBTVFJJTkcgPSAnc3RyaW5nJ1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYSBKU09OIHNjaGVtYSBkZWZpbml0aW9uIG9mIHRoZSBzdHJ1Y3R1cmUgb2YgYVxuICogUkVTVCBBUEkgbW9kZWwuIENvcGllZCBmcm9tIG5wbSBtb2R1bGUganNvbnNjaGVtYS5cbiAqXG4gKiBAc2VlIGh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvXG4gKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS90ZGVncnVudC9qc29uc2NoZW1hXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSnNvblNjaGVtYSB7XG4gIC8vIFNwZWNpYWwga2V5d29yZHNcbiAgcmVhZG9ubHkgc2NoZW1hPzogSnNvblNjaGVtYVZlcnNpb247XG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICByZWFkb25seSByZWY/OiBzdHJpbmc7XG5cbiAgLy8gQ29tbW9uIHByb3BlcnRpZXNcbiAgcmVhZG9ubHkgdHlwZT86IEpzb25TY2hlbWFUeXBlIHwgSnNvblNjaGVtYVR5cGVbXTtcbiAgcmVhZG9ubHkgdGl0bGU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuICByZWFkb25seSAnZW51bSc/OiBhbnlbXTtcbiAgLyoqXG4gICAqIFRoZSBkZWZhdWx0IHZhbHVlIGlmIHlvdSB1c2UgYW4gZW51bS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub3Qgc2V0XG4gICAqL1xuICByZWFkb25seSBkZWZhdWx0PzogYW55O1xuICByZWFkb25seSBmb3JtYXQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlZmluaXRpb25zPzogeyBbbmFtZTogc3RyaW5nXTogSnNvblNjaGVtYSB9O1xuXG4gIC8vIE51bWJlciBvciBJbnRlZ2VyXG4gIHJlYWRvbmx5IG11bHRpcGxlT2Y/OiBudW1iZXI7XG4gIHJlYWRvbmx5IG1heGltdW0/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGV4Y2x1c2l2ZU1heGltdW0/OiBib29sZWFuO1xuICByZWFkb25seSBtaW5pbXVtPzogbnVtYmVyO1xuICByZWFkb25seSBleGNsdXNpdmVNaW5pbXVtPzogYm9vbGVhbjtcblxuICAvLyBTdHJpbmdcbiAgcmVhZG9ubHkgbWF4TGVuZ3RoPzogbnVtYmVyO1xuICByZWFkb25seSBtaW5MZW5ndGg/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHBhdHRlcm4/OiBzdHJpbmc7XG5cbiAgLy8gQXJyYXlcbiAgcmVhZG9ubHkgaXRlbXM/OiBKc29uU2NoZW1hIHwgSnNvblNjaGVtYVtdO1xuICByZWFkb25seSBhZGRpdGlvbmFsSXRlbXM/OiBKc29uU2NoZW1hW107XG4gIHJlYWRvbmx5IG1heEl0ZW1zPzogbnVtYmVyO1xuICByZWFkb25seSBtaW5JdGVtcz86IG51bWJlcjtcbiAgcmVhZG9ubHkgdW5pcXVlSXRlbXM/OiBib29sZWFuO1xuICByZWFkb25seSBjb250YWlucz86IEpzb25TY2hlbWEgfCBKc29uU2NoZW1hW107XG5cbiAgLy8gT2JqZWN0XG4gIHJlYWRvbmx5IG1heFByb3BlcnRpZXM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IG1pblByb3BlcnRpZXM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHJlcXVpcmVkPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IHByb3BlcnRpZXM/OiB7IFtuYW1lOiBzdHJpbmddOiBKc29uU2NoZW1hIH07XG4gIHJlYWRvbmx5IGFkZGl0aW9uYWxQcm9wZXJ0aWVzPzogSnNvblNjaGVtYSB8IGJvb2xlYW47XG4gIHJlYWRvbmx5IHBhdHRlcm5Qcm9wZXJ0aWVzPzogeyBbbmFtZTogc3RyaW5nXTogSnNvblNjaGVtYSB9O1xuICByZWFkb25seSBkZXBlbmRlbmNpZXM/OiB7IFtuYW1lOiBzdHJpbmddOiBKc29uU2NoZW1hIHwgc3RyaW5nW10gfTtcbiAgcmVhZG9ubHkgcHJvcGVydHlOYW1lcz86IEpzb25TY2hlbWE7XG5cbiAgLy8gQ29uZGl0aW9uYWxcbiAgcmVhZG9ubHkgYWxsT2Y/OiBKc29uU2NoZW1hW107XG4gIHJlYWRvbmx5IGFueU9mPzogSnNvblNjaGVtYVtdO1xuICByZWFkb25seSBvbmVPZj86IEpzb25TY2hlbWFbXTtcbiAgcmVhZG9ubHkgbm90PzogSnNvblNjaGVtYTtcbn1cbiJdfQ==