#!/usr/bin/env python

# from the Python Standard Library (2.5)
import sys

from pycryptopp.hash import sha256

def main():
    for fn in sys.argv[1:]:
        fobj = open(fn, "r")
        hasher = sha256.SHA256()
        data = fobj.read(65536)
        while data:
            hasher.update(data)
            data = fobj.read(65536)
        digest = hasher.digest()
        print sha256.SHA256(digest).hexdigest()
 
if __name__ == '__main__':
    main()
