#!/usr/bin/env python
"""\
Test time_format.py
"""

import unittest

from pyutil import time_format, increasing_timer

class TimeUtilTestCase(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_iso8601_utc_time(self, timer=increasing_timer.timer):
        ts1 = time_format.iso_utc(timer.time() - 20)
        ts2 = time_format.iso_utc()
        assert ts1 < ts2, "failed: %s < %s" % (ts1, ts2)
        ts3 = time_format.iso_utc(timer.time() + 20)
        assert ts2 < ts3, "failed: %s < %s" % (ts2, ts3)

    def test_iso_utc_time_to_localseconds(self, timer=increasing_timer.timer):
        # test three times of the year so that a DST problem would hopefully be triggered
        t1 = int(timer.time() - 365*3600/3)
        iso_utc_t1 = time_format.iso_utc(t1)
        t1_2 = time_format.iso_utc_time_to_localseconds(iso_utc_t1)
        assert t1 == t1_2, (t1, t1_2)
        t1 = int(timer.time() - (365*3600*2/3))
        iso_utc_t1 = time_format.iso_utc(t1)
        t1_2 = time_format.iso_utc_time_to_localseconds(iso_utc_t1)
        self.failUnlessEqual(t1, t1_2)
        t1 = int(timer.time())
        iso_utc_t1 = time_format.iso_utc(t1)
        t1_2 = time_format.iso_utc_time_to_localseconds(iso_utc_t1)
        self.failUnlessEqual(t1, t1_2)
