import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service cassandra
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonkeyspacesforapachecassandra.html
 */
export declare class Cassandra extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service cassandra
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonkeyspacesforapachecassandra.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to alter a keyspace or table
     *
     * Access Level: Write
     */
    alter(): this;
    /**
     * Grants permission to create a keyspace or table
     *
     * Access Level: Write
     */
    create(): this;
    /**
     * Grants permission to drop a keyspace or table
     *
     * Access Level: Write
     */
    drop(): this;
    /**
     * Grants permission to INSERT, UPDATE or DELETE data in a table
     *
     * Access Level: Write
     */
    modify(): this;
    /**
     * Grants permission to SELECT data from a table
     *
     * Access Level: Read
     */
    select(): this;
    /**
     * Grants permission to tag a keyspace or table
     *
     * Access Level: Tagging
     */
    tagResource(): this;
    /**
     * Grants permission to untag a keyspace or table
     *
     * Access Level: Tagging
     */
    untagResource(): this;
    /**
     * Adds a resource of type keyspace to the statement
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/what-is.html
     *
     * @param keyspaceName - Identifier for the keyspaceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onKeyspace(keyspaceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/keyspaces/latest/devguide/what-is.html
     *
     * @param keyspaceName - Identifier for the keyspaceName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onTable(keyspaceName: string, tableName: string, account?: string, region?: string, partition?: string): this;
}
