"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service mechanicalturk
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmechanicalturk.html
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * Action provider for service mechanicalturk
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmechanicalturk.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mechanicalturk';
        this.actions = {
            "AcceptQualificationRequest": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html",
                "description": "The AcceptQualificationRequest operation grants a Worker's request for a Qualification",
                "accessLevel": "Write"
            },
            "ApproveAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html",
                "description": "The ApproveAssignment operation approves the results of a completed assignment",
                "accessLevel": "Write"
            },
            "AssociateQualificationWithWorker": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html",
                "description": "The AssociateQualificationWithWorker operation gives a Worker a Qualification",
                "accessLevel": "Write"
            },
            "CreateAdditionalAssignmentsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html",
                "description": "The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT",
                "accessLevel": "Write"
            },
            "CreateHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html",
                "description": "The CreateHIT operation creates a new HIT (Human Intelligence Task)",
                "accessLevel": "Write"
            },
            "CreateHITType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html",
                "description": "The CreateHITType operation creates a new HIT type",
                "accessLevel": "Write"
            },
            "CreateHITWithHITType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html",
                "description": "The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation",
                "accessLevel": "Write"
            },
            "CreateQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html",
                "description": "The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure",
                "accessLevel": "Write"
            },
            "CreateWorkerBlock": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html",
                "description": "The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs",
                "accessLevel": "Write"
            },
            "DeleteHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html",
                "description": "The DeleteHIT operation disposes of a HIT that is no longer needed",
                "accessLevel": "Write"
            },
            "DeleteQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html",
                "description": "The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type",
                "accessLevel": "Write"
            },
            "DeleteWorkerBlock": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html",
                "description": "The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs",
                "accessLevel": "Write"
            },
            "DisassociateQualificationFromWorker": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html",
                "description": "The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user",
                "accessLevel": "Write"
            },
            "GetAccountBalance": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html",
                "description": "The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account",
                "accessLevel": "Read"
            },
            "GetAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html",
                "description": "The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID",
                "accessLevel": "Read"
            },
            "GetFileUploadURL": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html",
                "description": "The GetFileUploadURL operation generates and returns a temporary URL",
                "accessLevel": "Read"
            },
            "GetHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html",
                "description": "The GetHIT operation retrieves the details of the specified HIT",
                "accessLevel": "Read"
            },
            "GetQualificationScore": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html",
                "description": "The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type",
                "accessLevel": "Read"
            },
            "GetQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html",
                "description": "The GetQualificationType operation retrieves information about a Qualification type using its ID",
                "accessLevel": "Read"
            },
            "ListAssignmentsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html",
                "description": "The ListAssignmentsForHIT operation retrieves completed assignments for a HIT",
                "accessLevel": "List"
            },
            "ListBonusPayments": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html",
                "description": "The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment",
                "accessLevel": "List"
            },
            "ListHITs": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html",
                "description": "The ListHITs operation returns all of a Requester's HITs",
                "accessLevel": "List"
            },
            "ListHITsForQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html",
                "description": "The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement",
                "accessLevel": "List"
            },
            "ListQualificationRequests": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html",
                "description": "The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type",
                "accessLevel": "List"
            },
            "ListQualificationTypes": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html",
                "description": "The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types",
                "accessLevel": "List"
            },
            "ListReviewPolicyResultsForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html",
                "description": "The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation",
                "accessLevel": "List"
            },
            "ListReviewableHITs": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html",
                "description": "The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected",
                "accessLevel": "List"
            },
            "ListWorkerBlocks": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html",
                "description": "The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs",
                "accessLevel": "List"
            },
            "ListWorkersWithQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html",
                "description": "The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type",
                "accessLevel": "List"
            },
            "NotifyWorkers": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html",
                "description": "The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID",
                "accessLevel": "Write"
            },
            "RejectAssignment": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html",
                "description": "The RejectAssignment operation rejects the results of a completed assignment",
                "accessLevel": "Write"
            },
            "RejectQualificationRequest": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html",
                "description": "The RejectQualificationRequest operation rejects a user's request for a Qualification",
                "accessLevel": "Write"
            },
            "SendBonus": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html",
                "description": "The SendBonus operation issues a payment of money from your account to a Worker",
                "accessLevel": "Write"
            },
            "SendTestEventNotification": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html",
                "description": "The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification",
                "accessLevel": "Write"
            },
            "UpdateExpirationForHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html",
                "description": "The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately",
                "accessLevel": "Write"
            },
            "UpdateHITReviewStatus": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html",
                "description": "The UpdateHITReviewStatus operation toggles the status of a HIT",
                "accessLevel": "Write"
            },
            "UpdateHITTypeOfHIT": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html",
                "description": "The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT",
                "accessLevel": "Write"
            },
            "UpdateNotificationSettings": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html",
                "description": "The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type",
                "accessLevel": "Write"
            },
            "UpdateQualificationType": {
                "url": "https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html",
                "description": "The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    acceptQualificationRequest() {
        this.add('mechanicalturk:AcceptQualificationRequest');
        return this;
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    approveAssignment() {
        this.add('mechanicalturk:ApproveAssignment');
        return this;
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    associateQualificationWithWorker() {
        this.add('mechanicalturk:AssociateQualificationWithWorker');
        return this;
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    createAdditionalAssignmentsForHIT() {
        this.add('mechanicalturk:CreateAdditionalAssignmentsForHIT');
        return this;
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    createHIT() {
        this.add('mechanicalturk:CreateHIT');
        return this;
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    createHITType() {
        this.add('mechanicalturk:CreateHITType');
        return this;
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    createHITWithHITType() {
        this.add('mechanicalturk:CreateHITWithHITType');
        return this;
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    createQualificationType() {
        this.add('mechanicalturk:CreateQualificationType');
        return this;
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    createWorkerBlock() {
        this.add('mechanicalturk:CreateWorkerBlock');
        return this;
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    deleteHIT() {
        this.add('mechanicalturk:DeleteHIT');
        return this;
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    deleteQualificationType() {
        this.add('mechanicalturk:DeleteQualificationType');
        return this;
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    deleteWorkerBlock() {
        this.add('mechanicalturk:DeleteWorkerBlock');
        return this;
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    disassociateQualificationFromWorker() {
        this.add('mechanicalturk:DisassociateQualificationFromWorker');
        return this;
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    getAccountBalance() {
        this.add('mechanicalturk:GetAccountBalance');
        return this;
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    getAssignment() {
        this.add('mechanicalturk:GetAssignment');
        return this;
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    getFileUploadURL() {
        this.add('mechanicalturk:GetFileUploadURL');
        return this;
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    getHIT() {
        this.add('mechanicalturk:GetHIT');
        return this;
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    getQualificationScore() {
        this.add('mechanicalturk:GetQualificationScore');
        return this;
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    getQualificationType() {
        this.add('mechanicalturk:GetQualificationType');
        return this;
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    listAssignmentsForHIT() {
        this.add('mechanicalturk:ListAssignmentsForHIT');
        return this;
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    listBonusPayments() {
        this.add('mechanicalturk:ListBonusPayments');
        return this;
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    listHITs() {
        this.add('mechanicalturk:ListHITs');
        return this;
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    listHITsForQualificationType() {
        this.add('mechanicalturk:ListHITsForQualificationType');
        return this;
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    listQualificationRequests() {
        this.add('mechanicalturk:ListQualificationRequests');
        return this;
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    listQualificationTypes() {
        this.add('mechanicalturk:ListQualificationTypes');
        return this;
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    listReviewPolicyResultsForHIT() {
        this.add('mechanicalturk:ListReviewPolicyResultsForHIT');
        return this;
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    listReviewableHITs() {
        this.add('mechanicalturk:ListReviewableHITs');
        return this;
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    listWorkerBlocks() {
        this.add('mechanicalturk:ListWorkerBlocks');
        return this;
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    listWorkersWithQualificationType() {
        this.add('mechanicalturk:ListWorkersWithQualificationType');
        return this;
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    notifyWorkers() {
        this.add('mechanicalturk:NotifyWorkers');
        return this;
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    rejectAssignment() {
        this.add('mechanicalturk:RejectAssignment');
        return this;
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    rejectQualificationRequest() {
        this.add('mechanicalturk:RejectQualificationRequest');
        return this;
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    sendBonus() {
        this.add('mechanicalturk:SendBonus');
        return this;
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    sendTestEventNotification() {
        this.add('mechanicalturk:SendTestEventNotification');
        return this;
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    updateExpirationForHIT() {
        this.add('mechanicalturk:UpdateExpirationForHIT');
        return this;
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    updateHITReviewStatus() {
        this.add('mechanicalturk:UpdateHITReviewStatus');
        return this;
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    updateHITTypeOfHIT() {
        this.add('mechanicalturk:UpdateHITTypeOfHIT');
        return this;
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    updateNotificationSettings() {
        this.add('mechanicalturk:UpdateNotificationSettings');
        return this;
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    updateQualificationType() {
        this.add('mechanicalturk:UpdateQualificationType');
        return this;
    }
}
exports.Mechanicalturk = Mechanicalturk;
//# sourceMappingURL=data:application/json;base64,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