"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service ec2messages
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * Action provider for service ec2messages
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'ec2messages';
        this.actions = {
            "AcknowledgeMessage": {
                "url": "",
                "description": "Acknowledges a message, ensuring it will not be delivered again",
                "accessLevel": "Write"
            },
            "DeleteMessage": {
                "url": "",
                "description": "Deletes a message",
                "accessLevel": "Write"
            },
            "FailMessage": {
                "url": "",
                "description": "Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again",
                "accessLevel": "Write"
            },
            "GetEndpoint": {
                "url": "",
                "description": "Routes traffic to the correct endpoint based on the given destination for the messages",
                "accessLevel": "Read"
            },
            "GetMessages": {
                "url": "",
                "description": "Delivers messages to clients/instances using long polling",
                "accessLevel": "Read"
            },
            "SendReply": {
                "url": "",
                "description": "Sends replies from clients/instances to upstream service",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    acknowledgeMessage() {
        this.add('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    deleteMessage() {
        this.add('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    failMessage() {
        this.add('ec2messages:FailMessage');
        return this;
    }
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    getEndpoint() {
        this.add('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    getMessages() {
        this.add('ec2messages:GetMessages');
        return this;
    }
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    sendReply() {
        this.add('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,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