import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service mobileanalytics
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html
 */
export declare class Mobileanalytics extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service mobileanalytics
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grant access to financial metrics for an app
     *
     * Access Level: Read
     */
    getFinancialReports(): this;
    /**
     * Grant access to standard metrics for an app
     *
     * Access Level: Read
     */
    getReports(): this;
    /**
     * The PutEvents operation records one or more events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     */
    putEvents(): this;
}
