"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service rds-data
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonrdsdataapi.html
 */
class RdsData extends shared_1.PolicyStatement {
    /**
     * Action provider for service rds-data
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonrdsdataapi.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'rds-data';
        this.actions = {
            "BatchExecuteStatement": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html",
                "description": "Runs a batch SQL statement over an array of data.",
                "accessLevel": "Write"
            },
            "BeginTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html",
                "description": "Starts a SQL transaction.",
                "accessLevel": "Write"
            },
            "CommitTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html",
                "description": "Ends a SQL transaction started with the BeginTransaction operation and commits the changes.",
                "accessLevel": "Write"
            },
            "ExecuteSql": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html",
                "description": "Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.",
                "accessLevel": "Write"
            },
            "ExecuteStatement": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html",
                "description": "Runs a SQL statement against a database.",
                "accessLevel": "Write"
            },
            "RollbackTransaction": {
                "url": "https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html",
                "description": "Performs a rollback of a transaction. Rolling back a transaction cancels its changes.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Runs a batch SQL statement over an array of data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BatchExecuteStatement.html
     */
    batchExecuteStatement() {
        this.add('rds-data:BatchExecuteStatement');
        return this;
    }
    /**
     * Starts a SQL transaction.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_BeginTransaction.html
     */
    beginTransaction() {
        this.add('rds-data:BeginTransaction');
        return this;
    }
    /**
     * Ends a SQL transaction started with the BeginTransaction operation and commits the changes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_CommitTransaction.html
     */
    commitTransaction() {
        this.add('rds-data:CommitTransaction');
        return this;
    }
    /**
     * Runs one or more SQL statements. This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteSql.html
     */
    executeSql() {
        this.add('rds-data:ExecuteSql');
        return this;
    }
    /**
     * Runs a SQL statement against a database.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_ExecuteStatement.html
     */
    executeStatement() {
        this.add('rds-data:ExecuteStatement');
        return this;
    }
    /**
     * Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rdsdataservice/latest/APIReference/API_RollbackTransaction.html
     */
    rollbackTransaction() {
        this.add('rds-data:RollbackTransaction');
        return this;
    }
}
exports.RdsData = RdsData;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW1hem9ucmRzZGF0YWFwaS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFtYXpvbnJkc2RhdGFhcGkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzQ0FBb0U7QUFHcEU7Ozs7R0FJRztBQUNILE1BQWEsT0FBUSxTQUFRLHdCQUFlO0lBb0MxQzs7OztPQUlHO0lBQ0gsWUFBYSxLQUE0QjtRQUN2QyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUF6Q1Isa0JBQWEsR0FBRyxVQUFVLENBQUM7UUFDM0IsWUFBTyxHQUFZO1lBQ3hCLHVCQUF1QixFQUFFO2dCQUN2QixLQUFLLEVBQUUsK0ZBQStGO2dCQUN0RyxhQUFhLEVBQUUsbURBQW1EO2dCQUNsRSxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsMEZBQTBGO2dCQUNqRyxhQUFhLEVBQUUsMkJBQTJCO2dCQUMxQyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELG1CQUFtQixFQUFFO2dCQUNuQixLQUFLLEVBQUUsMkZBQTJGO2dCQUNsRyxhQUFhLEVBQUUsNkZBQTZGO2dCQUM1RyxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsb0ZBQW9GO2dCQUMzRixhQUFhLEVBQUUsNkhBQTZIO2dCQUM1SSxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsMEZBQTBGO2dCQUNqRyxhQUFhLEVBQUUsMENBQTBDO2dCQUN6RCxhQUFhLEVBQUUsT0FBTzthQUN2QjtZQUNELHFCQUFxQixFQUFFO2dCQUNyQixLQUFLLEVBQUUsNkZBQTZGO2dCQUNwRyxhQUFhLEVBQUUsdUZBQXVGO2dCQUN0RyxhQUFhLEVBQUUsT0FBTzthQUN2QjtTQUNGLENBQUM7UUFDSyxrQkFBYSxHQUFrQixFQUFFLENBQUM7SUFTekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFVBQVU7UUFDZixJQUFJLENBQUMsR0FBRyxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDaEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBcEhELDBCQW9IQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjdGlvbnMsIFBvbGljeVN0YXRlbWVudCwgUmVzb3VyY2VUeXBlcyB9IGZyb20gXCIuLi9zaGFyZWRcIjtcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudFByb3BzIH0gZnJvbSBcIkBhd3MtY2RrL2F3cy1pYW1cIjtcblxuLyoqXG4gKiBBY3Rpb24gcHJvdmlkZXIgZm9yIHNlcnZpY2UgcmRzLWRhdGFcbiAqXG4gKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hbWF6b25yZHNkYXRhYXBpLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIFJkc0RhdGEgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdyZHMtZGF0YSc7XG4gIHB1YmxpYyBhY3Rpb25zOiBBY3Rpb25zID0ge1xuICAgIFwiQmF0Y2hFeGVjdXRlU3RhdGVtZW50XCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Jkc2RhdGFzZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0JhdGNoRXhlY3V0ZVN0YXRlbWVudC5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUnVucyBhIGJhdGNoIFNRTCBzdGF0ZW1lbnQgb3ZlciBhbiBhcnJheSBvZiBkYXRhLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiQmVnaW5UcmFuc2FjdGlvblwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CZWdpblRyYW5zYWN0aW9uLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJTdGFydHMgYSBTUUwgdHJhbnNhY3Rpb24uXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH0sXG4gICAgXCJDb21taXRUcmFuc2FjdGlvblwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db21taXRUcmFuc2FjdGlvbi5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiRW5kcyBhIFNRTCB0cmFuc2FjdGlvbiBzdGFydGVkIHdpdGggdGhlIEJlZ2luVHJhbnNhY3Rpb24gb3BlcmF0aW9uIGFuZCBjb21taXRzIHRoZSBjaGFuZ2VzLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiRXhlY3V0ZVNxbFwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeGVjdXRlU3FsLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJSdW5zIG9uZSBvciBtb3JlIFNRTCBzdGF0ZW1lbnRzLiBUaGlzIG9wZXJhdGlvbiBpcyBkZXByZWNhdGVkLiBVc2UgdGhlIEJhdGNoRXhlY3V0ZVN0YXRlbWVudCBvciBFeGVjdXRlU3RhdGVtZW50IG9wZXJhdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfSxcbiAgICBcIkV4ZWN1dGVTdGF0ZW1lbnRcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmRzZGF0YXNlcnZpY2UvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRXhlY3V0ZVN0YXRlbWVudC5odG1sXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiUnVucyBhIFNRTCBzdGF0ZW1lbnQgYWdhaW5zdCBhIGRhdGFiYXNlLlwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiUm9sbGJhY2tUcmFuc2FjdGlvblwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Sb2xsYmFja1RyYW5zYWN0aW9uLmh0bWxcIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJQZXJmb3JtcyBhIHJvbGxiYWNrIG9mIGEgdHJhbnNhY3Rpb24uIFJvbGxpbmcgYmFjayBhIHRyYW5zYWN0aW9uIGNhbmNlbHMgaXRzIGNoYW5nZXMuXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiV3JpdGVcIlxuICAgIH1cbiAgfTtcbiAgcHVibGljIHJlc291cmNlVHlwZXM6IFJlc291cmNlVHlwZXMgPSB7fTtcblxuICAvKipcbiAgICogQWN0aW9uIHByb3ZpZGVyIGZvciBzZXJ2aWNlIHJkcy1kYXRhXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2FtYXpvbnJkc2RhdGFhcGkuaHRtbFxuICAgKi9cbiAgY29uc3RydWN0b3IgKHByb3BzPzogUG9saWN5U3RhdGVtZW50UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogUnVucyBhIGJhdGNoIFNRTCBzdGF0ZW1lbnQgb3ZlciBhbiBhcnJheSBvZiBkYXRhLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CYXRjaEV4ZWN1dGVTdGF0ZW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIGJhdGNoRXhlY3V0ZVN0YXRlbWVudCgpIHtcbiAgICB0aGlzLmFkZCgncmRzLWRhdGE6QmF0Y2hFeGVjdXRlU3RhdGVtZW50Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU3RhcnRzIGEgU1FMIHRyYW5zYWN0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CZWdpblRyYW5zYWN0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyBiZWdpblRyYW5zYWN0aW9uKCkge1xuICAgIHRoaXMuYWRkKCdyZHMtZGF0YTpCZWdpblRyYW5zYWN0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRW5kcyBhIFNRTCB0cmFuc2FjdGlvbiBzdGFydGVkIHdpdGggdGhlIEJlZ2luVHJhbnNhY3Rpb24gb3BlcmF0aW9uIGFuZCBjb21taXRzIHRoZSBjaGFuZ2VzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZHNkYXRhc2VydmljZS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Db21taXRUcmFuc2FjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgY29tbWl0VHJhbnNhY3Rpb24oKSB7XG4gICAgdGhpcy5hZGQoJ3Jkcy1kYXRhOkNvbW1pdFRyYW5zYWN0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUnVucyBvbmUgb3IgbW9yZSBTUUwgc3RhdGVtZW50cy4gVGhpcyBvcGVyYXRpb24gaXMgZGVwcmVjYXRlZC4gVXNlIHRoZSBCYXRjaEV4ZWN1dGVTdGF0ZW1lbnQgb3IgRXhlY3V0ZVN0YXRlbWVudCBvcGVyYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Jkc2RhdGFzZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4ZWN1dGVTcWwuaHRtbFxuICAgKi9cbiAgcHVibGljIGV4ZWN1dGVTcWwoKSB7XG4gICAgdGhpcy5hZGQoJ3Jkcy1kYXRhOkV4ZWN1dGVTcWwnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSdW5zIGEgU1FMIHN0YXRlbWVudCBhZ2FpbnN0IGEgZGF0YWJhc2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Jkc2RhdGFzZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4ZWN1dGVTdGF0ZW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIGV4ZWN1dGVTdGF0ZW1lbnQoKSB7XG4gICAgdGhpcy5hZGQoJ3Jkcy1kYXRhOkV4ZWN1dGVTdGF0ZW1lbnQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBQZXJmb3JtcyBhIHJvbGxiYWNrIG9mIGEgdHJhbnNhY3Rpb24uIFJvbGxpbmcgYmFjayBhIHRyYW5zYWN0aW9uIGNhbmNlbHMgaXRzIGNoYW5nZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Jkc2RhdGFzZXJ2aWNlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1JvbGxiYWNrVHJhbnNhY3Rpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHJvbGxiYWNrVHJhbnNhY3Rpb24oKSB7XG4gICAgdGhpcy5hZGQoJ3Jkcy1kYXRhOlJvbGxiYWNrVHJhbnNhY3Rpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19