import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service textract
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html
 */
export declare class Textract extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service textract
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontextract.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Detects instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    analyzeDocument(): this;
    /**
     * Detects text in document images.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    detectDocumentText(): this;
    /**
     * Returns information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    getDocumentAnalysis(): this;
    /**
     * Returns information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    getDocumentTextDetection(): this;
    /**
     * Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    startDocumentAnalysis(): this;
    /**
     * Starts an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    startDocumentTextDetection(): this;
}
