"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service transcribe
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html
 */
class Transcribe extends shared_1.PolicyStatement {
    /**
     * Action provider for service transcribe
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'transcribe';
        this.actions = {
            "CreateMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html",
                "description": "Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.",
                "accessLevel": "Write"
            },
            "CreateVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html",
                "description": "Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.",
                "accessLevel": "Write"
            },
            "CreateVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html",
                "description": "Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe",
                "accessLevel": "Write"
            },
            "DeleteMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html",
                "description": "Grants permission to delete a previously submitted medical transcription job.",
                "accessLevel": "Write"
            },
            "DeleteMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html",
                "description": "Grants permission to delete a medical vocabulary from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "DeleteTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html",
                "description": "Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.",
                "accessLevel": "Write"
            },
            "DeleteVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html",
                "description": "Grants permission to delete a vocabulary from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "DeleteVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html",
                "description": "Grants permission to delete a vocabulary filter from Amazon Transcribe.",
                "accessLevel": "Write"
            },
            "GetMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html",
                "description": "Grants permission to return information about a medical transcription job.",
                "accessLevel": "Read"
            },
            "GetMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html",
                "description": "Grants permission to get information about a medical vocabulary.",
                "accessLevel": "Read"
            },
            "GetTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html",
                "description": "Grants permission to return information about a transcription job.",
                "accessLevel": "Read"
            },
            "GetVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html",
                "description": "Grants permission to to get information about a vocabulary.",
                "accessLevel": "Read"
            },
            "GetVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html",
                "description": "Grants permission to get information about a vocabulary filter.",
                "accessLevel": "Read"
            },
            "ListMedicalTranscriptionJobs": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html",
                "description": "Grants permission to list medical transcription jobs with the specified status.",
                "accessLevel": "List"
            },
            "ListMedicalVocabularies": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html",
                "description": "Grants permission to return a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.",
                "accessLevel": "List"
            },
            "ListTranscriptionJobs": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html",
                "description": "Grants permission to list transcription jobs with the specified status.",
                "accessLevel": "List"
            },
            "ListVocabularies": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html",
                "description": "Grants permission to return a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.",
                "accessLevel": "List"
            },
            "ListVocabularyFilters": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html",
                "description": "Grants permission to return a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters.",
                "accessLevel": "List"
            },
            "StartMedicalStreamTranscription": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html",
                "description": "Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.",
                "accessLevel": "Write"
            },
            "StartMedicalStreamTranscriptionWebSocket": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html",
                "description": "Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.",
                "accessLevel": "Write"
            },
            "StartMedicalTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html",
                "description": "Grants permission to start an asynchronous job to transcribe medical speech to text.",
                "accessLevel": "Write"
            },
            "StartStreamTranscription": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html",
                "description": "Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.",
                "accessLevel": "Write"
            },
            "StartStreamTranscriptionWebSocket": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html",
                "description": "Grants permission to start a websocket stream to transcribe speech to text in real time.",
                "accessLevel": "Write"
            },
            "StartTranscriptionJob": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html",
                "description": "Grants permission to start an asynchronous job to transcribe speech to text.",
                "accessLevel": "Write"
            },
            "UpdateMedicalVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html",
                "description": "Grants permission to update an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            },
            "UpdateVocabulary": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html",
                "description": "Grants permission to update an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            },
            "UpdateVocabularyFilter": {
                "url": "https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html",
                "description": "Grants permission to update an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     */
    createMedicalVocabulary() {
        this.add('transcribe:CreateMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     */
    createVocabulary() {
        this.add('transcribe:CreateVocabulary');
        return this;
    }
    /**
     * Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     */
    createVocabularyFilter() {
        this.add('transcribe:CreateVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to delete a previously submitted medical transcription job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     */
    deleteMedicalTranscriptionJob() {
        this.add('transcribe:DeleteMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to delete a medical vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     */
    deleteMedicalVocabulary() {
        this.add('transcribe:DeleteMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     */
    deleteTranscriptionJob() {
        this.add('transcribe:DeleteTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to delete a vocabulary from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     */
    deleteVocabulary() {
        this.add('transcribe:DeleteVocabulary');
        return this;
    }
    /**
     * Grants permission to delete a vocabulary filter from Amazon Transcribe.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     */
    deleteVocabularyFilter() {
        this.add('transcribe:DeleteVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to return information about a medical transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     */
    getMedicalTranscriptionJob() {
        this.add('transcribe:GetMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to get information about a medical vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     */
    getMedicalVocabulary() {
        this.add('transcribe:GetMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to return information about a transcription job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     */
    getTranscriptionJob() {
        this.add('transcribe:GetTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to to get information about a vocabulary.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     */
    getVocabulary() {
        this.add('transcribe:GetVocabulary');
        return this;
    }
    /**
     * Grants permission to get information about a vocabulary filter.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     */
    getVocabularyFilter() {
        this.add('transcribe:GetVocabularyFilter');
        return this;
    }
    /**
     * Grants permission to list medical transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     */
    listMedicalTranscriptionJobs() {
        this.add('transcribe:ListMedicalTranscriptionJobs');
        return this;
    }
    /**
     * Grants permission to return a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     */
    listMedicalVocabularies() {
        this.add('transcribe:ListMedicalVocabularies');
        return this;
    }
    /**
     * Grants permission to list transcription jobs with the specified status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     */
    listTranscriptionJobs() {
        this.add('transcribe:ListTranscriptionJobs');
        return this;
    }
    /**
     * Grants permission to return a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     */
    listVocabularies() {
        this.add('transcribe:ListVocabularies');
        return this;
    }
    /**
     * Grants permission to return a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     */
    listVocabularyFilters() {
        this.add('transcribe:ListVocabularyFilters');
        return this;
    }
    /**
     * Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     */
    startMedicalStreamTranscription() {
        this.add('transcribe:StartMedicalStreamTranscription');
        return this;
    }
    /**
     * Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     */
    startMedicalStreamTranscriptionWebSocket() {
        this.add('transcribe:StartMedicalStreamTranscriptionWebSocket');
        return this;
    }
    /**
     * Grants permission to start an asynchronous job to transcribe medical speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     */
    startMedicalTranscriptionJob() {
        this.add('transcribe:StartMedicalTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     */
    startStreamTranscription() {
        this.add('transcribe:StartStreamTranscription');
        return this;
    }
    /**
     * Grants permission to start a websocket stream to transcribe speech to text in real time.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     */
    startStreamTranscriptionWebSocket() {
        this.add('transcribe:StartStreamTranscriptionWebSocket');
        return this;
    }
    /**
     * Grants permission to start an asynchronous job to transcribe speech to text.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     */
    startTranscriptionJob() {
        this.add('transcribe:StartTranscriptionJob');
        return this;
    }
    /**
     * Grants permission to update an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     */
    updateMedicalVocabulary() {
        this.add('transcribe:UpdateMedicalVocabulary');
        return this;
    }
    /**
     * Grants permission to update an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     */
    updateVocabulary() {
        this.add('transcribe:UpdateVocabulary');
        return this;
    }
    /**
     * Grants permission to update an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     */
    updateVocabularyFilter() {
        this.add('transcribe:UpdateVocabularyFilter');
        return this;
    }
}
exports.Transcribe = Transcribe;
//# sourceMappingURL=data:application/json;base64,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