"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service translate
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Action provider for service translate
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranslate.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'translate';
        this.actions = {
            "DeleteTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html",
                "description": "A synchronous action that deletes a custom terminology.",
                "accessLevel": "Write"
            },
            "DescribeTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html",
                "description": "Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.",
                "accessLevel": "Read"
            },
            "GetTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html",
                "description": "Retrieves a custom terminology.",
                "accessLevel": "Read"
            },
            "ImportTerminology": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html",
                "description": "Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.",
                "accessLevel": "Write"
            },
            "ListTerminologies": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html",
                "description": "Provides a list of custom terminologies associated with your account.",
                "accessLevel": "Read"
            },
            "ListTextTranslationJobs": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html",
                "description": "Gets a list of the batch translation jobs that you have submitted.",
                "accessLevel": "Read"
            },
            "StartTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html",
                "description": "Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.",
                "accessLevel": "Write"
            },
            "StopTextTranslationJob": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html",
                "description": "Stops an asynchronous batch translation job that is in progress.",
                "accessLevel": "Write"
            },
            "TranslateText": {
                "url": "https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html",
                "description": "Translate text from a source language to a target language.",
                "accessLevel": "Read"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * A synchronous action that deletes a custom terminology.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    deleteTerminology() {
        this.add('translate:DeleteTerminology');
        return this;
    }
    /**
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    describeTextTranslationJob() {
        this.add('translate:DescribeTextTranslationJob');
        return this;
    }
    /**
     * Retrieves a custom terminology.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    getTerminology() {
        this.add('translate:GetTerminology');
        return this;
    }
    /**
     * Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    importTerminology() {
        this.add('translate:ImportTerminology');
        return this;
    }
    /**
     * Provides a list of custom terminologies associated with your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    listTerminologies() {
        this.add('translate:ListTerminologies');
        return this;
    }
    /**
     * Gets a list of the batch translation jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    listTextTranslationJobs() {
        this.add('translate:ListTextTranslationJobs');
        return this;
    }
    /**
     * Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    startTextTranslationJob() {
        this.add('translate:StartTextTranslationJob');
        return this;
    }
    /**
     * Stops an asynchronous batch translation job that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    stopTextTranslationJob() {
        this.add('translate:StopTextTranslationJob');
        return this;
    }
    /**
     * Translate text from a source language to a target language.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    translateText() {
        this.add('translate:TranslateText');
        return this;
    }
}
exports.Translate = Translate;
//# sourceMappingURL=data:application/json;base64,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