"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service workdocs
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkdocs.html
 */
class Workdocs extends shared_1.PolicyStatement {
    /**
     * Action provider for service workdocs
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkdocs.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'workdocs';
        this.actions = {
            "AbortDocumentVersionUpload": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html",
                "description": "Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload.",
                "accessLevel": "Write"
            },
            "ActivateUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html",
                "description": "Grants permission to activate the specified user. Only active users can access Amazon WorkDocs.",
                "accessLevel": "Write"
            },
            "AddResourcePermissions": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html",
                "description": "Grants permission to create a set of permissions for the specified folder or document.",
                "accessLevel": "Write"
            },
            "AddUserToGroup": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html",
                "description": "Grants permission to add a user to a group.",
                "accessLevel": "Write"
            },
            "CheckAlias": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html",
                "description": "Grants permission to check an alias.",
                "accessLevel": "Read"
            },
            "CreateComment": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html",
                "description": "Grants permission to add a new comment to the specified document version.",
                "accessLevel": "Write"
            },
            "CreateCustomMetadata": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html",
                "description": "Grants permission to add one or more custom properties to the specified resource.",
                "accessLevel": "Write"
            },
            "CreateFolder": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html",
                "description": "Grants permission to create a folder with the specified name and parent folder.",
                "accessLevel": "Write"
            },
            "CreateInstance": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html",
                "description": "Grants permission to create an instance.",
                "accessLevel": "Write"
            },
            "CreateLabels": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html",
                "description": "Grants permission to add labels to the given resource.",
                "accessLevel": "Write"
            },
            "CreateNotificationSubscription": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html",
                "description": "Grants permission to configure WorkDocs to use Amazon SNS notifications.",
                "accessLevel": "Write"
            },
            "CreateUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html",
                "description": "Grants permission to create a user in a Simple AD or Microsoft AD directory.",
                "accessLevel": "Write"
            },
            "DeactivateUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html",
                "description": "Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs.",
                "accessLevel": "Write"
            },
            "DeleteComment": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html",
                "description": "Grants permission to delete the specified comment from the document version.",
                "accessLevel": "Write"
            },
            "DeleteCustomMetadata": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html",
                "description": "Grants permission to delete custom metadata from the specified resource.",
                "accessLevel": "Write"
            },
            "DeleteDocument": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html",
                "description": "Grants permission to permanently delete the specified document and its associated metadata.",
                "accessLevel": "Write"
            },
            "DeleteFolder": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html",
                "description": "Grants permission to permanently delete the specified folder and its contents.",
                "accessLevel": "Write"
            },
            "DeleteFolderContents": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html",
                "description": "Grants permission to delete the contents of the specified folder.",
                "accessLevel": "Write"
            },
            "DeleteInstance": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site",
                "description": "Grants permission to delete an instance.",
                "accessLevel": "Write"
            },
            "DeleteLabels": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html",
                "description": "Grants permission to delete one or more labels from a resource.",
                "accessLevel": "Write"
            },
            "DeleteNotificationSubscription": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html",
                "description": "Grants permission to delete the specified subscription from the specified organization.",
                "accessLevel": "Write"
            },
            "DeleteUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html",
                "description": "Grants permission to delete the specified user from a Simple AD or Microsoft AD directory.",
                "accessLevel": "Write"
            },
            "DeregisterDirectory": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site",
                "description": "Grants permission to deregister a directory.",
                "accessLevel": "Write"
            },
            "DescribeActivities": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html",
                "description": "Grants permission to fetch user activities in a specified time period.",
                "accessLevel": "List"
            },
            "DescribeAvailableDirectories": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html",
                "description": "Grants permission to describe available directories.",
                "accessLevel": "List"
            },
            "DescribeComments": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html",
                "description": "Grants permission to list all the comments for the specified document version.",
                "accessLevel": "List"
            },
            "DescribeDocumentVersions": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html",
                "description": "Grants permission to retrieve the document versions for the specified document.",
                "accessLevel": "List"
            },
            "DescribeFolderContents": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html",
                "description": "Grants permission to describe the contents of the specified folder, including its documents and sub-folders.",
                "accessLevel": "List"
            },
            "DescribeGroups": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html",
                "description": "Grants permission to describe the user groups.",
                "accessLevel": "List"
            },
            "DescribeInstances": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html",
                "description": "Grants permission to describe instances.",
                "accessLevel": "List"
            },
            "DescribeNotificationSubscriptions": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html",
                "description": "Grants permission to list the specified notification subscriptions.",
                "accessLevel": "List"
            },
            "DescribeResourcePermissions": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html",
                "description": "Grants permission to view a description of a specified resource's permissions.",
                "accessLevel": "List"
            },
            "DescribeRootFolders": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html",
                "description": "Grants permission to describe the root folders.",
                "accessLevel": "List"
            },
            "DescribeUsers": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html",
                "description": "Grants permission to view a description of the specified users. You can describe all users or filter the results (for example, by status or organization).",
                "accessLevel": "List"
            },
            "DownloadDocumentVersion": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html",
                "description": "Grants permission to download a specified document version.",
                "accessLevel": "Read"
            },
            "GetCurrentUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html",
                "description": "Grants permission to retrieve the details of the current user.",
                "accessLevel": "Read"
            },
            "GetDocument": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html",
                "description": "Grants permission to retrieve the specified document object.",
                "accessLevel": "Read"
            },
            "GetDocumentPath": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html",
                "description": "Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document.",
                "accessLevel": "Read"
            },
            "GetDocumentVersion": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html",
                "description": "Grants permission to retrieve version metadata for the specified document.",
                "accessLevel": "Read"
            },
            "GetFolder": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html",
                "description": "Grants permission to retrieve the metadata of the specified folder.",
                "accessLevel": "Read"
            },
            "GetFolderPath": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html",
                "description": "Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder.",
                "accessLevel": "Read"
            },
            "GetResources": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html",
                "description": "Grants permission to get a collection of resources.",
                "accessLevel": "Read"
            },
            "InitiateDocumentVersionUpload": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html",
                "description": "Grants permission to create a new document object and version object.",
                "accessLevel": "Write"
            },
            "RegisterDirectory": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html",
                "description": "Grants permission to register a directory.",
                "accessLevel": "Write"
            },
            "RemoveAllResourcePermissions": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html",
                "description": "Grants permission to remove all the permissions from the specified resource.",
                "accessLevel": "Write"
            },
            "RemoveResourcePermission": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html",
                "description": "Grants permission to remove the permission for the specified principal from the specified resource.",
                "accessLevel": "Write"
            },
            "UpdateDocument": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html",
                "description": "Grants permission to update the specified attributes of the specified document.",
                "accessLevel": "Write"
            },
            "UpdateDocumentVersion": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html",
                "description": "Grants permission to change the status of the document version to ACTIVE.",
                "accessLevel": "Write"
            },
            "UpdateFolder": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html",
                "description": "Grants permission to update the specified attributes of the specified folder.",
                "accessLevel": "Write"
            },
            "UpdateInstanceAlias": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html",
                "description": "Grants permission to update an instance alias.",
                "accessLevel": "Write"
            },
            "UpdateUser": {
                "url": "https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html",
                "description": "Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html
     */
    abortDocumentVersionUpload() {
        this.add('workdocs:AbortDocumentVersionUpload');
        return this;
    }
    /**
     * Grants permission to activate the specified user. Only active users can access Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html
     */
    activateUser() {
        this.add('workdocs:ActivateUser');
        return this;
    }
    /**
     * Grants permission to create a set of permissions for the specified folder or document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html
     */
    addResourcePermissions() {
        this.add('workdocs:AddResourcePermissions');
        return this;
    }
    /**
     * Grants permission to add a user to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html
     */
    addUserToGroup() {
        this.add('workdocs:AddUserToGroup');
        return this;
    }
    /**
     * Grants permission to check an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html
     */
    checkAlias() {
        this.add('workdocs:CheckAlias');
        return this;
    }
    /**
     * Grants permission to add a new comment to the specified document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html
     */
    createComment() {
        this.add('workdocs:CreateComment');
        return this;
    }
    /**
     * Grants permission to add one or more custom properties to the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html
     */
    createCustomMetadata() {
        this.add('workdocs:CreateCustomMetadata');
        return this;
    }
    /**
     * Grants permission to create a folder with the specified name and parent folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html
     */
    createFolder() {
        this.add('workdocs:CreateFolder');
        return this;
    }
    /**
     * Grants permission to create an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    createInstance() {
        this.add('workdocs:CreateInstance');
        return this;
    }
    /**
     * Grants permission to add labels to the given resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html
     */
    createLabels() {
        this.add('workdocs:CreateLabels');
        return this;
    }
    /**
     * Grants permission to configure WorkDocs to use Amazon SNS notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html
     */
    createNotificationSubscription() {
        this.add('workdocs:CreateNotificationSubscription');
        return this;
    }
    /**
     * Grants permission to create a user in a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html
     */
    createUser() {
        this.add('workdocs:CreateUser');
        return this;
    }
    /**
     * Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html
     */
    deactivateUser() {
        this.add('workdocs:DeactivateUser');
        return this;
    }
    /**
     * Grants permission to delete the specified comment from the document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html
     */
    deleteComment() {
        this.add('workdocs:DeleteComment');
        return this;
    }
    /**
     * Grants permission to delete custom metadata from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html
     */
    deleteCustomMetadata() {
        this.add('workdocs:DeleteCustomMetadata');
        return this;
    }
    /**
     * Grants permission to permanently delete the specified document and its associated metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html
     */
    deleteDocument() {
        this.add('workdocs:DeleteDocument');
        return this;
    }
    /**
     * Grants permission to permanently delete the specified folder and its contents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html
     */
    deleteFolder() {
        this.add('workdocs:DeleteFolder');
        return this;
    }
    /**
     * Grants permission to delete the contents of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html
     */
    deleteFolderContents() {
        this.add('workdocs:DeleteFolderContents');
        return this;
    }
    /**
     * Grants permission to delete an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    deleteInstance() {
        this.add('workdocs:DeleteInstance');
        return this;
    }
    /**
     * Grants permission to delete one or more labels from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html
     */
    deleteLabels() {
        this.add('workdocs:DeleteLabels');
        return this;
    }
    /**
     * Grants permission to delete the specified subscription from the specified organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html
     */
    deleteNotificationSubscription() {
        this.add('workdocs:DeleteNotificationSubscription');
        return this;
    }
    /**
     * Grants permission to delete the specified user from a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html
     */
    deleteUser() {
        this.add('workdocs:DeleteUser');
        return this;
    }
    /**
     * Grants permission to deregister a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    deregisterDirectory() {
        this.add('workdocs:DeregisterDirectory');
        return this;
    }
    /**
     * Grants permission to fetch user activities in a specified time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html
     */
    describeActivities() {
        this.add('workdocs:DescribeActivities');
        return this;
    }
    /**
     * Grants permission to describe available directories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    describeAvailableDirectories() {
        this.add('workdocs:DescribeAvailableDirectories');
        return this;
    }
    /**
     * Grants permission to list all the comments for the specified document version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html
     */
    describeComments() {
        this.add('workdocs:DescribeComments');
        return this;
    }
    /**
     * Grants permission to retrieve the document versions for the specified document.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html
     */
    describeDocumentVersions() {
        this.add('workdocs:DescribeDocumentVersions');
        return this;
    }
    /**
     * Grants permission to describe the contents of the specified folder, including its documents and sub-folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html
     */
    describeFolderContents() {
        this.add('workdocs:DescribeFolderContents');
        return this;
    }
    /**
     * Grants permission to describe the user groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html
     */
    describeGroups() {
        this.add('workdocs:DescribeGroups');
        return this;
    }
    /**
     * Grants permission to describe instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    describeInstances() {
        this.add('workdocs:DescribeInstances');
        return this;
    }
    /**
     * Grants permission to list the specified notification subscriptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html
     */
    describeNotificationSubscriptions() {
        this.add('workdocs:DescribeNotificationSubscriptions');
        return this;
    }
    /**
     * Grants permission to view a description of a specified resource's permissions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html
     */
    describeResourcePermissions() {
        this.add('workdocs:DescribeResourcePermissions');
        return this;
    }
    /**
     * Grants permission to describe the root folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html
     */
    describeRootFolders() {
        this.add('workdocs:DescribeRootFolders');
        return this;
    }
    /**
     * Grants permission to view a description of the specified users. You can describe all users or filter the results (for example, by status or organization).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html
     */
    describeUsers() {
        this.add('workdocs:DescribeUsers');
        return this;
    }
    /**
     * Grants permission to download a specified document version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    downloadDocumentVersion() {
        this.add('workdocs:DownloadDocumentVersion');
        return this;
    }
    /**
     * Grants permission to retrieve the details of the current user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html
     */
    getCurrentUser() {
        this.add('workdocs:GetCurrentUser');
        return this;
    }
    /**
     * Grants permission to retrieve the specified document object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html
     */
    getDocument() {
        this.add('workdocs:GetDocument');
        return this;
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html
     */
    getDocumentPath() {
        this.add('workdocs:GetDocumentPath');
        return this;
    }
    /**
     * Grants permission to retrieve version metadata for the specified document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    getDocumentVersion() {
        this.add('workdocs:GetDocumentVersion');
        return this;
    }
    /**
     * Grants permission to retrieve the metadata of the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html
     */
    getFolder() {
        this.add('workdocs:GetFolder');
        return this;
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html
     */
    getFolderPath() {
        this.add('workdocs:GetFolderPath');
        return this;
    }
    /**
     * Grants permission to get a collection of resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html
     */
    getResources() {
        this.add('workdocs:GetResources');
        return this;
    }
    /**
     * Grants permission to create a new document object and version object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html
     */
    initiateDocumentVersionUpload() {
        this.add('workdocs:InitiateDocumentVersionUpload');
        return this;
    }
    /**
     * Grants permission to register a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html
     */
    registerDirectory() {
        this.add('workdocs:RegisterDirectory');
        return this;
    }
    /**
     * Grants permission to remove all the permissions from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html
     */
    removeAllResourcePermissions() {
        this.add('workdocs:RemoveAllResourcePermissions');
        return this;
    }
    /**
     * Grants permission to remove the permission for the specified principal from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html
     */
    removeResourcePermission() {
        this.add('workdocs:RemoveResourcePermission');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html
     */
    updateDocument() {
        this.add('workdocs:UpdateDocument');
        return this;
    }
    /**
     * Grants permission to change the status of the document version to ACTIVE.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html
     */
    updateDocumentVersion() {
        this.add('workdocs:UpdateDocumentVersion');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html
     */
    updateFolder() {
        this.add('workdocs:UpdateFolder');
        return this;
    }
    /**
     * Grants permission to update an instance alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    updateInstanceAlias() {
        this.add('workdocs:UpdateInstanceAlias');
        return this;
    }
    /**
     * Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html
     */
    updateUser() {
        this.add('workdocs:UpdateUser');
        return this;
    }
}
exports.Workdocs = Workdocs;
//# sourceMappingURL=data:application/json;base64,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