import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service wam
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkspacesapplicationmanager.html
 */
export declare class Wam extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service wam
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonworkspacesapplicationmanager.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Allows the Amazon WAM packaging instance to access your application package catalog.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wam/latest/adminguide/iam.html
     */
    authenticatePackager(): this;
}
