"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service application-autoscaling
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationautoscaling.html
 */
class ApplicationAutoscaling extends shared_1.PolicyStatement {
    /**
     * Action provider for service application-autoscaling
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationautoscaling.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'application-autoscaling';
        this.actions = {
            "DeleteScalingPolicy": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScalingPolicy.html",
                "description": "Deletes an Application Auto Scaling scaling policy that was previously created.",
                "accessLevel": "Write"
            },
            "DeleteScheduledAction": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScheduledAction.html",
                "description": "Deletes an Application Auto Scaling scheduled action that was previously created.",
                "accessLevel": "Write"
            },
            "DeregisterScalableTarget": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html",
                "description": "Deregisters a scalable target that was previously registered.",
                "accessLevel": "Write"
            },
            "DescribeScalableTargets": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html",
                "description": "Provides descriptive information for scalable targets with a specified service namespace.",
                "accessLevel": "Read"
            },
            "DescribeScalingActivities": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html",
                "description": "Provides descriptive information for scaling activities with a specified service namespace for the previous six weeks.",
                "accessLevel": "Read"
            },
            "DescribeScalingPolicies": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingPolicies.html",
                "description": "Provides descriptive information for scaling policies with a specified service namespace.",
                "accessLevel": "Read"
            },
            "DescribeScheduledActions": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScheduledActions.html",
                "description": "Provides descriptive information for scheduled actions with a specified service namespace.",
                "accessLevel": "Read"
            },
            "PutScalingPolicy": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html",
                "description": "Creates or updates a policy for an existing Application Auto Scaling scalable target.",
                "accessLevel": "Write"
            },
            "PutScheduledAction": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html",
                "description": "Creates or updates a scheduled action for an existing Application Auto Scaling scalable target.",
                "accessLevel": "Write"
            },
            "RegisterScalableTarget": {
                "url": "https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html",
                "description": "Registers or updates a scalable target. A scalable target is a resource that can be scaled out or in with Application Auto Scaling.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Deletes an Application Auto Scaling scaling policy that was previously created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScalingPolicy.html
     */
    deleteScalingPolicy() {
        this.add('application-autoscaling:DeleteScalingPolicy');
        return this;
    }
    /**
     * Deletes an Application Auto Scaling scheduled action that was previously created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScheduledAction.html
     */
    deleteScheduledAction() {
        this.add('application-autoscaling:DeleteScheduledAction');
        return this;
    }
    /**
     * Deregisters a scalable target that was previously registered.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html
     */
    deregisterScalableTarget() {
        this.add('application-autoscaling:DeregisterScalableTarget');
        return this;
    }
    /**
     * Provides descriptive information for scalable targets with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html
     */
    describeScalableTargets() {
        this.add('application-autoscaling:DescribeScalableTargets');
        return this;
    }
    /**
     * Provides descriptive information for scaling activities with a specified service namespace for the previous six weeks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html
     */
    describeScalingActivities() {
        this.add('application-autoscaling:DescribeScalingActivities');
        return this;
    }
    /**
     * Provides descriptive information for scaling policies with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingPolicies.html
     */
    describeScalingPolicies() {
        this.add('application-autoscaling:DescribeScalingPolicies');
        return this;
    }
    /**
     * Provides descriptive information for scheduled actions with a specified service namespace.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScheduledActions.html
     */
    describeScheduledActions() {
        this.add('application-autoscaling:DescribeScheduledActions');
        return this;
    }
    /**
     * Creates or updates a policy for an existing Application Auto Scaling scalable target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html
     */
    putScalingPolicy() {
        this.add('application-autoscaling:PutScalingPolicy');
        return this;
    }
    /**
     * Creates or updates a scheduled action for an existing Application Auto Scaling scalable target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html
     */
    putScheduledAction() {
        this.add('application-autoscaling:PutScheduledAction');
        return this;
    }
    /**
     * Registers or updates a scalable target. A scalable target is a resource that can be scaled out or in with Application Auto Scaling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     */
    registerScalableTarget() {
        this.add('application-autoscaling:RegisterScalableTarget');
        return this;
    }
}
exports.ApplicationAutoscaling = ApplicationAutoscaling;
//# sourceMappingURL=data:application/json;base64,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