import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service arsenal
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html
 */
export declare class Arsenal extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service arsenal
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscoveryarsenal.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to register AWS provided data collectors to the Application Discovery Service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/setting-up.html#setting-up-user-policy
     */
    registerOnPremisesAgent(): this;
}
