"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service autoscaling-plans
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsautoscaling.html
 */
class AutoscalingPlans extends shared_1.PolicyStatement {
    /**
     * Action provider for service autoscaling-plans
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsautoscaling.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'autoscaling-plans';
        this.actions = {
            "CreateScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html",
                "description": "Creates a scaling plan.",
                "accessLevel": "Write"
            },
            "DeleteScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html",
                "description": "Deletes the specified scaling plan.",
                "accessLevel": "Write"
            },
            "DescribeScalingPlanResources": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html",
                "description": "Describes the scalable resources in the specified scaling plan.",
                "accessLevel": "Read"
            },
            "DescribeScalingPlans": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html",
                "description": "Describes the specified scaling plans or all of your scaling plans.",
                "accessLevel": "Read"
            },
            "GetScalingPlanResourceForecastData": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html",
                "description": "Retrieves the forecast data for a scalable resource.",
                "accessLevel": "Read"
            },
            "UpdateScalingPlan": {
                "url": "https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html",
                "description": "Updates a scaling plan.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Creates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html
     */
    createScalingPlan() {
        this.add('autoscaling-plans:CreateScalingPlan');
        return this;
    }
    /**
     * Deletes the specified scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html
     */
    deleteScalingPlan() {
        this.add('autoscaling-plans:DeleteScalingPlan');
        return this;
    }
    /**
     * Describes the scalable resources in the specified scaling plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html
     */
    describeScalingPlanResources() {
        this.add('autoscaling-plans:DescribeScalingPlanResources');
        return this;
    }
    /**
     * Describes the specified scaling plans or all of your scaling plans.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html
     */
    describeScalingPlans() {
        this.add('autoscaling-plans:DescribeScalingPlans');
        return this;
    }
    /**
     * Retrieves the forecast data for a scalable resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html
     */
    getScalingPlanResourceForecastData() {
        this.add('autoscaling-plans:GetScalingPlanResourceForecastData');
        return this;
    }
    /**
     * Updates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html
     */
    updateScalingPlan() {
        this.add('autoscaling-plans:UpdateScalingPlan');
        return this;
    }
}
exports.AutoscalingPlans = AutoscalingPlans;
//# sourceMappingURL=data:application/json;base64,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