import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service iq
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiq.html
 */
export declare class Iq extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service iq
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiq.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Grants permission to submit new project requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    createProject(): this;
}
