import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service aws-marketplace-entitlement-service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceentitlementservice.html
 */
export declare class AwsMarketplaceEntitlementService extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service aws-marketplace-entitlement-service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceentitlementservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions
     *
     * Access Level: Read
     */
    getEntitlements(): this;
}
