import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service aws-marketplace-image-building-service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceimagebuildingservice.html
 */
export declare class AwsMarketplaceImageBuildingService extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service aws-marketplace-image-building-service
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceimagebuildingservice.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Describes Image Builds identified by a build Id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    describeBuilds(): this;
    /**
     * Lists Image Builds.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    listBuilds(): this;
    /**
     * Starts an Image Build
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    startBuild(): this;
}
