import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service aws-marketplace-management
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html
 */
export declare class AwsMarketplaceManagement extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service aws-marketplace-management
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplacemanagementportal.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Allows a user to access the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    uploadFiles(): this;
    /**
     * Allows a user to access the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewMarketing(): this;
    /**
     * Allows a user to access the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewReports(): this;
    /**
     * Allows a user to access the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSettings(): this;
    /**
     * Allows a user to access the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/controlling-access/marketplace-management-portal-user-access.html#detailed-management-portal-permissions
     */
    viewSupport(): this;
}
