import { Actions, PolicyStatement, ResourceTypes } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * Action provider for service purchase-orders
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awspurchaseordersconsole.html
 */
export declare class PurchaseOrders extends PolicyStatement {
    servicePrefix: string;
    actions: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Action provider for service purchase-orders
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awspurchaseordersconsole.html
     */
    constructor(props?: PolicyStatementProps);
    /**
     * Modify purchase orders and details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    modifyPurchaseOrders(): this;
    /**
     * View purchase orders and details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    viewPurchaseOrders(): this;
}
