"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shared_1 = require("../shared");
/**
 * Action provider for service datapipeline
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_datapipeline.html
 */
class Datapipeline extends shared_1.PolicyStatement {
    /**
     * Action provider for service datapipeline
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_datapipeline.html
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'datapipeline';
        this.actions = {
            "ActivatePipeline": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ActivatePipeline.html",
                "description": "Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation, activation fails.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag",
                    "datapipeline:workerGroup"
                ]
            },
            "AddTags": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_AddTags.html",
                "description": "Adds or modifies tags for the specified pipeline.",
                "accessLevel": "Tagging",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "CreatePipeline": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_CreatePipeline.html",
                "description": "Creates a new, empty pipeline.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:Tag"
                ]
            },
            "DeactivatePipeline": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DeactivatePipeline.html",
                "description": "Deactivates the specified running pipeline.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag",
                    "datapipeline:workerGroup"
                ]
            },
            "DeletePipeline": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DeletePipeline.html",
                "description": "Deletes a pipeline, its pipeline definition, and its run history.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "DescribeObjects": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DescribeObjects.html",
                "description": "Gets the object definitions for a set of objects associated with the pipeline.",
                "accessLevel": "Read",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "DescribePipelines": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DescribePipelines.html",
                "description": "Retrieves metadata about one or more pipelines.",
                "accessLevel": "List",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "EvaluateExpression": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_EvaluateExpression.html",
                "description": "Task runners call EvaluateExpression to evaluate a string in the context of the specified object.",
                "accessLevel": "Read",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "GetAccountLimits": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_GetAccountLimits.html",
                "description": "Description for GetAccountLimits",
                "accessLevel": "List"
            },
            "GetPipelineDefinition": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_GetPipelineDefinition.html",
                "description": "Gets the definition of the specified pipeline.",
                "accessLevel": "Read",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag",
                    "datapipeline:workerGroup"
                ]
            },
            "ListPipelines": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ListPipelines.html",
                "description": "Lists the pipeline identifiers for all active pipelines that you have permission to access.",
                "accessLevel": "List"
            },
            "PollForTask": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PollForTask.html",
                "description": "Task runners call PollForTask to receive a task to perform from AWS Data Pipeline.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:workerGroup"
                ]
            },
            "PutAccountLimits": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PutAccountLimits.html",
                "description": "Description for PutAccountLimits",
                "accessLevel": "Write"
            },
            "PutPipelineDefinition": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PutPipelineDefinition.html",
                "description": "Adds tasks, schedules, and preconditions to the specified pipeline.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag",
                    "datapipeline:workerGroup"
                ]
            },
            "QueryObjects": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_QueryObjects.html",
                "description": "Queries the specified pipeline for the names of objects that match the specified set of conditions.",
                "accessLevel": "Read",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "RemoveTags": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_RemoveTags.html",
                "description": "Removes existing tags from the specified pipeline.",
                "accessLevel": "Tagging",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "ReportTaskProgress": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ReportTaskProgress.html",
                "description": "Task runners call ReportTaskProgress when assigned a task to acknowledge that it has the task.",
                "accessLevel": "Write"
            },
            "ReportTaskRunnerHeartbeat": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ReportTaskRunnerHeartbeat.html",
                "description": "Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate that they are operational.",
                "accessLevel": "Write"
            },
            "SetStatus": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_SetStatus.html",
                "description": "Requests that the status of the specified physical or logical pipeline objects be updated in the specified pipeline.",
                "accessLevel": "Write",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag"
                ]
            },
            "SetTaskStatus": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_SetTaskStatus.html",
                "description": "Task runners call SetTaskStatus to notify AWS Data Pipeline that a task is completed and provide information about the final status.",
                "accessLevel": "Write"
            },
            "ValidatePipelineDefinition": {
                "url": "https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ValidatePipelineDefinition.html",
                "description": "Validates the specified pipeline definition to ensure that it is well formed and can be run without error.",
                "accessLevel": "Read",
                "conditions": [
                    "datapipeline:PipelineCreator",
                    "datapipeline:Tag",
                    "datapipeline:workerGroup"
                ]
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation, activation fails.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ActivatePipeline.html
     */
    activatePipeline() {
        this.add('datapipeline:ActivatePipeline');
        return this;
    }
    /**
     * Adds or modifies tags for the specified pipeline.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_AddTags.html
     */
    addTags() {
        this.add('datapipeline:AddTags');
        return this;
    }
    /**
     * Creates a new, empty pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_CreatePipeline.html
     */
    createPipeline() {
        this.add('datapipeline:CreatePipeline');
        return this;
    }
    /**
     * Deactivates the specified running pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DeactivatePipeline.html
     */
    deactivatePipeline() {
        this.add('datapipeline:DeactivatePipeline');
        return this;
    }
    /**
     * Deletes a pipeline, its pipeline definition, and its run history.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DeletePipeline.html
     */
    deletePipeline() {
        this.add('datapipeline:DeletePipeline');
        return this;
    }
    /**
     * Gets the object definitions for a set of objects associated with the pipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DescribeObjects.html
     */
    describeObjects() {
        this.add('datapipeline:DescribeObjects');
        return this;
    }
    /**
     * Retrieves metadata about one or more pipelines.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_DescribePipelines.html
     */
    describePipelines() {
        this.add('datapipeline:DescribePipelines');
        return this;
    }
    /**
     * Task runners call EvaluateExpression to evaluate a string in the context of the specified object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_EvaluateExpression.html
     */
    evaluateExpression() {
        this.add('datapipeline:EvaluateExpression');
        return this;
    }
    /**
     * Description for GetAccountLimits
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_GetAccountLimits.html
     */
    getAccountLimits() {
        this.add('datapipeline:GetAccountLimits');
        return this;
    }
    /**
     * Gets the definition of the specified pipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_GetPipelineDefinition.html
     */
    getPipelineDefinition() {
        this.add('datapipeline:GetPipelineDefinition');
        return this;
    }
    /**
     * Lists the pipeline identifiers for all active pipelines that you have permission to access.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ListPipelines.html
     */
    listPipelines() {
        this.add('datapipeline:ListPipelines');
        return this;
    }
    /**
     * Task runners call PollForTask to receive a task to perform from AWS Data Pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PollForTask.html
     */
    pollForTask() {
        this.add('datapipeline:PollForTask');
        return this;
    }
    /**
     * Description for PutAccountLimits
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PutAccountLimits.html
     */
    putAccountLimits() {
        this.add('datapipeline:PutAccountLimits');
        return this;
    }
    /**
     * Adds tasks, schedules, and preconditions to the specified pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_PutPipelineDefinition.html
     */
    putPipelineDefinition() {
        this.add('datapipeline:PutPipelineDefinition');
        return this;
    }
    /**
     * Queries the specified pipeline for the names of objects that match the specified set of conditions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_QueryObjects.html
     */
    queryObjects() {
        this.add('datapipeline:QueryObjects');
        return this;
    }
    /**
     * Removes existing tags from the specified pipeline.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_RemoveTags.html
     */
    removeTags() {
        this.add('datapipeline:RemoveTags');
        return this;
    }
    /**
     * Task runners call ReportTaskProgress when assigned a task to acknowledge that it has the task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ReportTaskProgress.html
     */
    reportTaskProgress() {
        this.add('datapipeline:ReportTaskProgress');
        return this;
    }
    /**
     * Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate that they are operational.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ReportTaskRunnerHeartbeat.html
     */
    reportTaskRunnerHeartbeat() {
        this.add('datapipeline:ReportTaskRunnerHeartbeat');
        return this;
    }
    /**
     * Requests that the status of the specified physical or logical pipeline objects be updated in the specified pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_SetStatus.html
     */
    setStatus() {
        this.add('datapipeline:SetStatus');
        return this;
    }
    /**
     * Task runners call SetTaskStatus to notify AWS Data Pipeline that a task is completed and provide information about the final status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_SetTaskStatus.html
     */
    setTaskStatus() {
        this.add('datapipeline:SetTaskStatus');
        return this;
    }
    /**
     * Validates the specified pipeline definition to ensure that it is well formed and can be run without error.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datapipeline/latest/APIReference/API_ValidatePipelineDefinition.html
     */
    validatePipelineDefinition() {
        this.add('datapipeline:ValidatePipelineDefinition');
        return this;
    }
    /**
     * The IAM user that created the pipeline.
     *
     * https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-example-tag-policies.html#ex3
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnEquals`
     */
    ifPipelineCreator(value, operator) {
        return this.if(`datapipeline:PipelineCreator`, value, operator || 'ArnEquals');
    }
    /**
     * A customer-specified key/value pair that can be attached to a resource.
     *
     * https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-resourcebased-access.html#dp-control-access-tags
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnEquals`
     */
    ifTag(value, operator) {
        return this.if(`datapipeline:Tag`, value, operator || 'ArnEquals');
    }
    /**
     * The name of a worker group for which a Task Runner retrieves work.
     *
     * https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-resourcebased-access.html#dp-control-access-workergroup
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnEquals`
     */
    ifWorkerGroup(value, operator) {
        return this.if(`datapipeline:workerGroup`, value, operator || 'ArnEquals');
    }
}
exports.Datapipeline = Datapipeline;
//# sourceMappingURL=data:application/json;base64,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