# -*- coding: utf-8 -*-
# Autogenerated on 15:42:03 2016/04/18
# flake8: noqa
import logging
from wbia.algo.detect import grabmodels
from wbia.algo.detect import randomforest
from wbia.algo.detect import yolo

# from wbia.algo.detect import selectivesearch
# from wbia.algo.detect import ssd
# from wbia.algo.detect import fasterrcnn
# from wbia.algo.detect import darknet
import utool

print, rrr, profile = utool.inject2(__name__)
logger = logging.getLogger('wbia')


def reassign_submodule_attributes(verbose=True):
    """
    why reloading all the modules doesnt do this I don't know
    """
    import sys

    if verbose and '--quiet' not in sys.argv:
        print('dev reimport')
    # Self import
    import wbia.algo.detect

    # Implicit reassignment.
    seen_ = set([])
    for tup in IMPORT_TUPLES:
        if len(tup) > 2 and tup[2]:
            continue  # dont import package names
        submodname, fromimports = tup[0:2]
        submod = getattr(wbia.algo.detect, submodname)
        for attr in dir(submod):
            if attr.startswith('_'):
                continue
            if attr in seen_:
                # This just holds off bad behavior
                # but it does mimic normal util_import behavior
                # which is good
                continue
            seen_.add(attr)
            setattr(wbia.algo.detect, attr, getattr(submod, attr))


def reload_subs(verbose=True):
    """ Reloads wbia.algo.detect and submodules """
    if verbose:
        print('Reloading submodules')
    rrr(verbose=verbose)

    def wrap_fbrrr(mod):
        def fbrrr(*args, **kwargs):
            """ fallback reload """
            if verbose:
                print('No fallback relaod for mod=%r' % (mod,))
            # Breaks ut.Pref (which should be depricated anyway)
            # import imp
            # imp.reload(mod)

        return fbrrr

    def get_rrr(mod):
        if hasattr(mod, 'rrr'):
            return mod.rrr
        else:
            return wrap_fbrrr(mod)

    def get_reload_subs(mod):
        return getattr(mod, 'reload_subs', wrap_fbrrr(mod))

    get_rrr(grabmodels)(verbose=verbose)
    get_rrr(randomforest)(verbose=verbose)
    get_rrr(yolo)(verbose=verbose)
    # get_rrr(selectivesearch)(verbose=verbose)
    # get_rrr(ssd)(verbose=verbose)
    # get_rrr(fasterrcnn)(verbose=verbose)
    # get_rrr(darknet)(verbose=verbose)
    rrr(verbose=verbose)
    try:
        # hackish way of propogating up the new reloaded submodule attributes
        reassign_submodule_attributes(verbose=verbose)
    except Exception as ex:
        print(ex)


rrrr = reload_subs

IMPORT_TUPLES = [
    ('grabmodels', None),
    ('randomforest', None),
    ('yolo', None),
    # ('selectivesearch', None),
    # ('ssd', None),
    # ('fasterrcnn', None),
    # ('darknet', None),
]
"""
Regen Command:
    cd /Users/bluemellophone/code/wbia/wbia/algo/detect
    makeinit.py --modname=wbia.algo.detect
"""
