# AUTOGENERATED! DO NOT EDIT! File to edit: 06rics.ipynb (unless otherwise specified).

__all__ = ['real_rand_ket', 'real_rand_dm', 'rand_symmetric', 'rand_orthogonal', 'maxim_states', 'maxim_povm']

# Cell
import numpy as np
import qutip as qt
from scipy.stats import ortho_group

from .povm import *
from .random import *
from .kraus import *

# Cell
def real_rand_ket(d):
    r"""
    Generates a random ket in real Hilbert space of dimension $d$.
    """
    return qt.Qobj(np.random.randn(d)).unit()

# Cell
def real_rand_dm(d):
    r"""
    Generates a random density matrix for a real Hilbert space of dimension $d$.
    """
    return qt.Qobj(qt.rand_dm(d).full().real)

# Cell
def rand_symmetric(d):
    r"""
    Generates a random $d \times d$ symmetric matrix. These matrices correspond to observables in real quantum mechanics, being the real analogue of Hermitian matrices: $\hat{S} = \hat{S}^{T}$.
    """
    M = qt.Qobj(np.random.randn(d,d))
    return M*M.trans() + M.trans()*M

# Cell
def rand_orthogonal(d):
    r"""
    Generates a random $d \times d$ orthogonal matrix. These matrices correspond to time evolution in real quantum mechanics, being the real analogue of unitary matrices: $\hat{S}\hat{S}^{T} = \hat{I}$.
    """
    return qt.Qobj(ortho_group.rvs(d))

# Cell
def maxim_states():
    r"""
    The 10 real vectors corresponding to the Maxim RIC.
    """
    return [qt.Qobj(np.array(state)) for state in
                [[0, 0, 0, 1],
                [0, 0, np.sqrt(3)/2, 1/2],
                [0, 0, np.sqrt(3)/2, -1/2],
                [0, np.sqrt(2/3), -1/np.sqrt(3), 0],
                [0, np.sqrt(2/3), 1/(2*np.sqrt(3)), 1/2],
                [0, np.sqrt(2/3), 1/(2*np.sqrt(3)), -1/2],
                [np.sqrt(5/2)/2, -np.sqrt(3/2)/2, 0, 0],
                [np.sqrt(5/2)/2, 1/(2*np.sqrt(6)), -1/np.sqrt(3), 0],
                [np.sqrt(5/2)/2, 1/(2*np.sqrt(6)), 1/(2*np.sqrt(3)), 1/2],
                [np.sqrt(5/2)/2, 1/(2*np.sqrt(6)), 1/(2*np.sqrt(3)), -1/2]]]

# Cell
def maxim_povm():
    r"""
    The Maxim RIC-POVM.
    """
    return [(2/5)*state*state.dag() for state in maxim_states()]