_base_ = [
    '../_base_/models/base_styleganv3.py',
    '../_base_/gen_default_runtime.py',
    '../_base_/datasets/unconditional_imgs_flip_lanczos_resize_256x256.py',
]

synthesis_cfg = {
    'type': 'SynthesisNetwork',
    'channel_base': 16384,
    'channel_max': 512,
    'magnitude_ema_beta': 0.999
}
model = dict(
    generator=dict(
        out_size=256,
        img_channels=3,
        rgb2bgr=True,
        synthesis_cfg=synthesis_cfg),
    discriminator=dict(in_size=256, channel_multiplier=1))

batch_size = 4
data_root = './data/ffhqu/images'

train_dataloader = dict(
    batch_size=batch_size, dataset=dict(data_root=data_root))

val_dataloader = dict(batch_size=batch_size, dataset=dict(data_root=data_root))

test_dataloader = dict(
    batch_size=batch_size, dataset=dict(data_root=data_root))

train_cfg = train_dataloader = optim_wrapper = None

metrics = [
    dict(
        type='FrechetInceptionDistance',
        prefix='FID-Full-50k',
        fake_nums=50000,
        inception_style='StyleGAN',
        sample_model='ema')
]
# NOTE: config for save multi best checkpoints
# default_hooks = dict(
#     checkpoint=dict(
#         save_best=['FID-Full-50k/fid', 'IS-50k/is'],
#         rule=['less', 'greater']))
default_hooks = dict(checkpoint=dict(save_best='FID-Full-50k/fid'))
val_evaluator = dict(metrics=metrics)
test_evaluator = dict(metrics=metrics)
