"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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