# Changelog

## Py-ART v1.14.1

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.14.0...v1.14.1))

### Enhancements made

- ENH: Add gatefilter to attenuation module [#1324](https://github.com/ARM-DOE/pyart/pull/1324) ([@mgrover1](https://github.com/mgrover1))
- ENH: Adding fields parameter to specify list of writing to file. [#1319](https://github.com/ARM-DOE/pyart/pull/1319) ([@zssherman](https://github.com/zssherman))
- ENH: Improved convective stratiform functions [#1314](https://github.com/ARM-DOE/pyart/pull/1314) ([@lauratomkins](https://github.com/lauratomkins))

### Other merged PRs

- ADD: Adding add_filter function to radar.py. [#1326](https://github.com/ARM-DOE/pyart/pull/1326) ([@zssherman](https://github.com/zssherman))
- Add Spectral-like colormaps based on pyart#1320 [#1325](https://github.com/ARM-DOE/pyart/pull/1325) ([@jthielen](https://github.com/jthielen))
- Add ci for Python 3.11 [#1303](https://github.com/ARM-DOE/pyart/pull/1303) ([@mgrover1](https://github.com/mgrover1))
- ADD: Colorbar Manipulation Example [#1300](https://github.com/ARM-DOE/pyart/pull/1300) ([@jrobrien91](https://github.com/jrobrien91))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-11-08&to=2022-11-16&type=c))

[@dopplerchase](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplerchase+updated%3A2022-11-08..2022-11-16&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2022-11-08..2022-11-16&type=Issues) | [@jrobrien91](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajrobrien91+updated%3A2022-11-08..2022-11-16&type=Issues) | [@jthielen](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajthielen+updated%3A2022-11-08..2022-11-16&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2022-11-08..2022-11-16&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-11-08..2022-11-16&type=Issues) | [@wx4stg](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awx4stg+updated%3A2022-11-08..2022-11-16&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-11-08..2022-11-16&type=Issues)


## Py-ART v1.14.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.13.3...v1.14.0))

### Enhancements made

- ENH: Adding simple antivirus workflow similiar to what Adam implemented in ACT. [#1307](https://github.com/ARM-DOE/pyart/pull/1307) ([@zssherman](https://github.com/zssherman))
- ENH: Add fix to blog post, add docs on how to write a blog post [#1299](https://github.com/ARM-DOE/pyart/pull/1299) ([@mgrover1](https://github.com/mgrover1))

### Bugs fixed

- FIX: Phase processing code throwing deprecation warnings for scipy.ndimage.filters.convolve1d [#1313](https://github.com/ARM-DOE/pyart/pull/1313) ([@rcjackson](https://github.com/rcjackson))
- FIX: Add check for when instrument parameters is None. [#1306](https://github.com/ARM-DOE/pyart/pull/1306) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Added two pyart examples (VAD and hydrometeors) [#1317](https://github.com/ARM-DOE/pyart/pull/1317) ([@wolfidan](https://github.com/wolfidan))

### Other merged PRs

- Plot grid modif [#1311](https://github.com/ARM-DOE/pyart/pull/1311) ([@jfigui](https://github.com/jfigui))
- Add image muting citation to function and example [#1304](https://github.com/ARM-DOE/pyart/pull/1304) ([@lauratomkins](https://github.com/lauratomkins))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-10-21&to=2022-11-08&type=c))

[@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2022-10-21..2022-11-08&type=Issues) | [@hhuangwx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ahhuangwx+updated%3A2022-10-21..2022-11-08&type=Issues) | [@jfigui](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajfigui+updated%3A2022-10-21..2022-11-08&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2022-10-21..2022-11-08&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2022-10-21..2022-11-08&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2022-10-21..2022-11-08&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2022-10-21..2022-11-08&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2022-10-21..2022-11-08&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-10-21..2022-11-08&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2022-10-21..2022-11-08&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2022-10-21..2022-11-08&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2022-10-21..2022-11-08&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2022-10-21..2022-11-08&type=Issues) | [@wolfidan](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awolfidan+updated%3A2022-10-21..2022-11-08&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-10-21..2022-11-08&type=Issues)


## Py-ART v1.13.3

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.13.2...v1.13.3))

### Enhancements made

- ENH: Add fix to blog post, add docs on how to write a blog post [#1299](https://github.com/ARM-DOE/pyart/pull/1299) ([@mgrover1](https://github.com/mgrover1))
- ENH: Check for sector scans and use ppi. [#1294](https://github.com/ARM-DOE/pyart/pull/1294) ([@zssherman](https://github.com/zssherman))
- ENH: Add cross section functionality [#1290](https://github.com/ARM-DOE/pyart/pull/1290) ([@mgrover1](https://github.com/mgrover1))

### Bugs fixed

- FIX: Remove old list of colormaps [#1285](https://github.com/ARM-DOE/pyart/pull/1285) ([@mgrover1](https://github.com/mgrover1))
- FIX: Use new api to toggle top and right labels [#1279](https://github.com/ARM-DOE/pyart/pull/1279) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix for backwards compatibility for matplotlib 3.6. [#1278](https://github.com/ARM-DOE/pyart/pull/1278) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Add a new colormap example [#1284](https://github.com/ARM-DOE/pyart/pull/1284) ([@mgrover1](https://github.com/mgrover1))

### Other merged PRs

- ADD: TRACER blog post [#1296](https://github.com/ARM-DOE/pyart/pull/1296) ([@rcjackson](https://github.com/rcjackson))
- Update join radar to account for target_scan_rate [#1292](https://github.com/ARM-DOE/pyart/pull/1292) ([@nguy](https://github.com/nguy))
- Fix title of dealias example [#1287](https://github.com/ARM-DOE/pyart/pull/1287) ([@mgrover1](https://github.com/mgrover1))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-09-26&to=2022-10-21&type=c))

[@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-09-26..2022-10-21&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2022-09-26..2022-10-21&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2022-09-26..2022-10-21&type=Issues) | [@review-notebook-app](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Areview-notebook-app+updated%3A2022-09-26..2022-10-21&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-09-26..2022-10-21&type=Issues)


## Py-ART v1.13.2

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.13.1...v1.13.2))

### Enhancements made

- ENH: Add cibuildwheel to build wheels [#1267](https://github.com/ARM-DOE/pyart/pull/1267) ([@mgrover1](https://github.com/mgrover1))

### Bugs fixed

- FIX: Fix for backwards compatibility for matplotlib 3.6. [#1278](https://github.com/ARM-DOE/pyart/pull/1278) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-09-26&to=2022-09-26&type=c))

[@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-09-26..2022-09-26&type=Issues) | [@ocefpaf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aocefpaf+updated%3A2022-09-26..2022-09-26&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-09-26..2022-09-26&type=Issues)


## Py-ART v1.13.1

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.13.0...v1.13.1))

### Enhancements made

- ENH: Add cibuildwheel to build wheels [#1267](https://github.com/ARM-DOE/pyart/pull/1267) ([@mgrover1](https://github.com/mgrover1))

### Maintenance and upkeep improvements

- MNT: Update to find namespace packages to fix setuptools warning. [#1275](https://github.com/ARM-DOE/pyart/pull/1275) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Update changelog for v1.13.0 [#1276](https://github.com/ARM-DOE/pyart/pull/1276) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add changelog from previous releases [#1265](https://github.com/ARM-DOE/pyart/pull/1265) ([@mgrover1](https://github.com/mgrover1))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-09-21&to=2022-09-26&type=c))

[@dcedgren](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adcedgren+updated%3A2022-09-21..2022-09-26&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2022-09-21..2022-09-26&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2022-09-21..2022-09-26&type=Issues) | [@jfigui](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajfigui+updated%3A2022-09-21..2022-09-26&type=Issues) | [@Jillinger](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AJillinger+updated%3A2022-09-21..2022-09-26&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2022-09-21..2022-09-26&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-09-21..2022-09-26&type=Issues) | [@ocefpaf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aocefpaf+updated%3A2022-09-21..2022-09-26&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2022-09-21..2022-09-26&type=Issues) | [@zhaobudaola](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azhaobudaola+updated%3A2022-09-21..2022-09-26&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-09-21..2022-09-26&type=Issues)

## Py-ART v1.13.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.7...v1.13.0))

### Enhancements made

- ENH: Add column example to docs [#1263](https://github.com/ARM-DOE/pyart/pull/1263) ([@mgrover1](https://github.com/mgrover1))
- ENH: Composite Reflectivity Function  [#1235](https://github.com/ARM-DOE/pyart/pull/1235) ([@dopplerchase](https://github.com/dopplerchase))
- ENH: Corrected Height Gates to be height above sea level [#1215](https://github.com/ARM-DOE/pyart/pull/1215) ([@jrobrien91](https://github.com/jrobrien91))

### Bugs fixed

- FIX: Make datetime parsing more general for columnsect [#1261](https://github.com/ARM-DOE/pyart/pull/1261) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix the reference documentation links [#1241](https://github.com/ARM-DOE/pyart/pull/1241) ([@mgrover1](https://github.com/mgrover1))
- FIX: Pin previous version of shapely [#1240](https://github.com/ARM-DOE/pyart/pull/1240) ([@mgrover1](https://github.com/mgrover1))
- FIX: Return zero phase for sweeps completely filtered out with gatefi… [#1226](https://github.com/ARM-DOE/pyart/pull/1226) ([@rcjackson](https://github.com/rcjackson))
- FIX: join_radar also joins pulse repititon times iparam [#1218](https://github.com/ARM-DOE/pyart/pull/1218) ([@wx4stg](https://github.com/wx4stg))
- FIX: fix writing IRIS sigmet files to UF [#1216](https://github.com/ARM-DOE/pyart/pull/1216) ([@wx4stg](https://github.com/wx4stg))

### Maintenance and upkeep improvements

- MNT: Remove trmm_rsl from CI optional, remove from debug info. [#1239](https://github.com/ARM-DOE/pyart/pull/1239) ([@zssherman](https://github.com/zssherman))
- MNT: Remove pinning for specific cftime [#1211](https://github.com/ARM-DOE/pyart/pull/1211) ([@mgrover1](https://github.com/mgrover1))

### Documentation improvements

- DOC: Updated pyart doc to include column code, fix incorrect syntax and more. [#1231](https://github.com/ARM-DOE/pyart/pull/1231) ([@zssherman](https://github.com/zssherman))
- DOC: Updating Py-ART's how to release doc and removing most of ci_setup doc [#1213](https://github.com/ARM-DOE/pyart/pull/1213) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- ADD: Add changelog from previous releases [#1265](https://github.com/ARM-DOE/pyart/pull/1265) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add composite reflectivity citation [#1264](https://github.com/ARM-DOE/pyart/pull/1264) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add xradar basic functions [#1251](https://github.com/ARM-DOE/pyart/pull/1251) ([@mgrover1](https://github.com/mgrover1))
- DEL: Remove load module section [#1234](https://github.com/ARM-DOE/pyart/pull/1234) ([@mgrover1](https://github.com/mgrover1))
- ADD: Trmm test [#1228](https://github.com/ARM-DOE/pyart/pull/1228) ([@zssherman](https://github.com/zssherman))
- ADD: addition of subset_radar function in radar_utils [#1227](https://github.com/ARM-DOE/pyart/pull/1227) ([@wolfidan](https://github.com/wolfidan))
- ADD: Add pyrad to the readme [#1220](https://github.com/ARM-DOE/pyart/pull/1220) ([@mgrover1](https://github.com/mgrover1))
- TST: Fix median filter depreciation warnings as well as more tests for simple moments. [#1214](https://github.com/ARM-DOE/pyart/pull/1214) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-07-19&to=2022-09-21&type=c))

[@dopplerchase](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplerchase+updated%3A2022-07-19..2022-09-21&type=Issues) | [@jfigui](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajfigui+updated%3A2022-07-19..2022-09-21&type=Issues) | [@jrobrien91](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajrobrien91+updated%3A2022-07-19..2022-09-21&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2022-07-19..2022-09-21&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-07-19..2022-09-21&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2022-07-19..2022-09-21&type=Issues) | [@srbrodzik](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Asrbrodzik+updated%3A2022-07-19..2022-09-21&type=Issues) | [@wolfidan](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awolfidan+updated%3A2022-07-19..2022-09-21&type=Issues) | [@wx4stg](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awx4stg+updated%3A2022-07-19..2022-09-21&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-07-19..2022-09-21&type=Issues)

## Py-ART v1.12.7

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.6...v1.12.7))

### Bugs fixed

- FIX: Fix for only python 3.10 being used. [#1208](https://github.com/ARM-DOE/pyart/pull/1208) ([@zssherman](https://github.com/zssherman))
- FIX: update join_radar to also append instrument parameters [#1204](https://github.com/ARM-DOE/pyart/pull/1204) ([@wolfidan](https://github.com/wolfidan))
- FIX: Fix link to cookbooks in user guide [#1201](https://github.com/ARM-DOE/pyart/pull/1201) ([@mgrover1](https://github.com/mgrover1))
- FIX: Str for warning of coefficient band used was wrong. [#1198](https://github.com/ARM-DOE/pyart/pull/1198) ([@zssherman](https://github.com/zssherman))
- FIX: C-band values being set by x-band. [#1196](https://github.com/ARM-DOE/pyart/pull/1196) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Added warning catch for axes. [#1191](https://github.com/ARM-DOE/pyart/pull/1191) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Remove pinning for specific cftime [#1211](https://github.com/ARM-DOE/pyart/pull/1211) ([@mgrover1](https://github.com/mgrover1))
- TST: Moving tests to test module within Py-ART main directory. [#1207](https://github.com/ARM-DOE/pyart/pull/1207) ([@zssherman](https://github.com/zssherman))
- ADD: Add pypi stats to readme [#1206](https://github.com/ARM-DOE/pyart/pull/1206) ([@mgrover1](https://github.com/mgrover1))
- TST: Adding unitests for rain rate module. [#1200](https://github.com/ARM-DOE/pyart/pull/1200) ([@zssherman](https://github.com/zssherman))
- ADD: Add cookbook section in user guide [#1199](https://github.com/ARM-DOE/pyart/pull/1199) ([@mgrover1](https://github.com/mgrover1))
- TST: Adding unit tests for whole echoclass module. [#1197](https://github.com/ARM-DOE/pyart/pull/1197) ([@zssherman](https://github.com/zssherman))
- DEL: Deleted convv.py, looks to be a test added awhile back. [#1195](https://github.com/ARM-DOE/pyart/pull/1195) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-06-29&to=2022-07-19&type=c))

[@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-06-29..2022-07-19&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2022-06-29..2022-07-19&type=Issues) | [@wolfidan](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awolfidan+updated%3A2022-06-29..2022-07-19&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-06-29..2022-07-19&type=Issues)

## Py-ART v1.12.6

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.5...v1.12.6))

### Bugs fixed

- FIX: Update requirements with cftime + numpy [#1190](https://github.com/ARM-DOE/pyart/pull/1190) ([@mgrover1](https://github.com/mgrover1))

### Other merged PRs

- ADD: Add in tests for KDP/PHI DP functions [#1184](https://github.com/ARM-DOE/pyart/pull/1184) ([@mgrover1](https://github.com/mgrover1))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-06-24&to=2022-06-29&type=c))

[@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-06-24..2022-06-29&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-06-24..2022-06-29&type=Issues)

## Py-ART v1.12.5

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.4...v1.12.5))

### Enhancements made

- ENH: Change default LP solver to pyglpk [#1183](https://github.com/ARM-DOE/pyart/pull/1183) ([@mgrover1](https://github.com/mgrover1))
- ENH: Addition of Time as a Coordinate within extracted column output [#1176](https://github.com/ARM-DOE/pyart/pull/1176) ([@jrobrien91](https://github.com/jrobrien91))

### Bugs fixed

- FIX: add pinned version of numpy [#1187](https://github.com/ARM-DOE/pyart/pull/1187) ([@mgrover1](https://github.com/mgrover1))
- FIX: Add revised fix for RHI near 270 [#1185](https://github.com/ARM-DOE/pyart/pull/1185) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix incorrect version showing up in docs (API) [#1181](https://github.com/ARM-DOE/pyart/pull/1181) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix rsl not running in test suite [#1178](https://github.com/ARM-DOE/pyart/pull/1178) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix sorting issue with elevations and azimuths [#1171](https://github.com/ARM-DOE/pyart/pull/1171) ([@mgrover1](https://github.com/mgrover1))

### Maintenance and upkeep improvements

- MNT: Update vmin vmax to make velocity plot more visible. [#1175](https://github.com/ARM-DOE/pyart/pull/1175) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Updating docs to represent python versions. [#1180](https://github.com/ARM-DOE/pyart/pull/1180) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- ADD: v1.12.4 section to changelog [#1177](https://github.com/ARM-DOE/pyart/pull/1177) ([@mgrover1](https://github.com/mgrover1))
- Update ARM name to remove climate [#1173](https://github.com/ARM-DOE/pyart/pull/1173) ([@mgrover1](https://github.com/mgrover1))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-06-10&to=2022-06-24&type=c))

[@jrobrien91](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajrobrien91+updated%3A2022-06-10..2022-06-24&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-06-10..2022-06-24&type=Issues) | [@sobitp59](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Asobitp59+updated%3A2022-06-10..2022-06-24&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-06-10..2022-06-24&type=Issues)

## PyART v1.12.4

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.2...7dc5d6b8deff4a2e42fd567588be65a88af07127))

### Bugs fixed

- FIX: Fix sorting issue with elevations and azimuths [#1171](https://github.com/ARM-DOE/pyart/pull/1171) ([@mgrover1](https://github.com/mgrover1))
- FIX: Sort elevations and fix rogue radial issue [#1170](https://github.com/ARM-DOE/pyart/pull/1170) ([@mgrover1](https://github.com/mgrover1))
- FIX: Read in remote compressed data by adding in default compression argument [#1160](https://github.com/ARM-DOE/pyart/pull/1160) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix rounding issue with mask arrays, using np.round instead. [#1152](https://github.com/ARM-DOE/pyart/pull/1152) ([@zssherman](https://github.com/zssherman))
- FIX: Fixes an issue with mismatch arrays. [#1151](https://github.com/ARM-DOE/pyart/pull/1151) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Update vmin vmax to make velocity plot more visible. [#1175](https://github.com/ARM-DOE/pyart/pull/1175) ([@zssherman](https://github.com/zssherman))
- MNT: Mispelling of embelish [#1158](https://github.com/ARM-DOE/pyart/pull/1158) ([@zssherman](https://github.com/zssherman))
- MNT: Changing dependency check to Cartopy. [#1148](https://github.com/ARM-DOE/pyart/pull/1148) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Update ARM name to remove climate [#1173](https://github.com/ARM-DOE/pyart/pull/1173) ([@mgrover1](https://github.com/mgrover1))
- Pin version of xarray [#1167](https://github.com/ARM-DOE/pyart/pull/1167) ([@mgrover1](https://github.com/mgrover1))
- ADD: Update Changelog for v1.12.2 [#1164](https://github.com/ARM-DOE/pyart/pull/1164) ([@mgrover1](https://github.com/mgrover1))
- Add Image muting plotting example to gallery [#1154](https://github.com/ARM-DOE/pyart/pull/1154) ([@lauratomkins](https://github.com/lauratomkins))
- TST: Adding unittest for correct bias function. [#1153](https://github.com/ARM-DOE/pyart/pull/1153) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-05-02&to=2022-06-21&type=c))

[@jrobrien91](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajrobrien91+updated%3A2022-05-02..2022-06-21&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2022-05-02..2022-06-21&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-05-02..2022-06-21&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-05-02..2022-06-21&type=Issues)

## PyART v1.12.2

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.12.0...v1.12.2))

### Enhancements made

- ENH: Remove versioneer and add scm [#1136](https://github.com/ARM-DOE/pyart/pull/1136) ([@mgrover1](https://github.com/mgrover1))
- ENH: Allow pypi to run by triggering manually [#1126](https://github.com/ARM-DOE/pyart/pull/1126) ([@mgrover1](https://github.com/mgrover1))
- ENH: Add a pypi release action [#1118](https://github.com/ARM-DOE/pyart/pull/1118) ([@mgrover1](https://github.com/mgrover1))
- ENH: Use fsspec for io in pyart.io.common to read both local and remote files [#1115](https://github.com/ARM-DOE/pyart/pull/1115) ([@mgrover1](https://github.com/mgrover1))
- ENH: Add ability to pass kwargs in for plots and change default [#1111](https://github.com/ARM-DOE/pyart/pull/1111) ([@mgrover1](https://github.com/mgrover1))

### Bugs fixed

- FIX: remove macos arm builds [#1147](https://github.com/ARM-DOE/pyart/pull/1147) ([@mgrover1](https://github.com/mgrover1))
- FIX: Add pruning back into workflows [#1143](https://github.com/ARM-DOE/pyart/pull/1143) ([@mgrover1](https://github.com/mgrover1))
- FIX: Use macOS build for pypi instead of linux [#1141](https://github.com/ARM-DOE/pyart/pull/1141) ([@mgrover1](https://github.com/mgrover1))
- FIX: Update requirements for many-linux build [#1140](https://github.com/ARM-DOE/pyart/pull/1140) ([@mgrover1](https://github.com/mgrover1))
- FIX: Use many linux build [#1139](https://github.com/ARM-DOE/pyart/pull/1139) ([@mgrover1](https://github.com/mgrover1))
- FIX: Only apply fix to the build wheel [#1137](https://github.com/ARM-DOE/pyart/pull/1137) ([@mgrover1](https://github.com/mgrover1))
- FIX: make sure release uploaded to pypi [#1131](https://github.com/ARM-DOE/pyart/pull/1131) ([@mgrover1](https://github.com/mgrover1))
- FIX: Make sure versions match for pypi [#1130](https://github.com/ARM-DOE/pyart/pull/1130) ([@mgrover1](https://github.com/mgrover1))
- FIX: Remove requirement for action to be push [#1129](https://github.com/ARM-DOE/pyart/pull/1129) ([@mgrover1](https://github.com/mgrover1))
- FIX: fix name of pyart in the pypi verification [#1128](https://github.com/ARM-DOE/pyart/pull/1128) ([@mgrover1](https://github.com/mgrover1))
- FIX: Add back in the python -m to fix the build [#1127](https://github.com/ARM-DOE/pyart/pull/1127) ([@mgrover1](https://github.com/mgrover1))
- FIX: fix the pypi build [#1125](https://github.com/ARM-DOE/pyart/pull/1125) ([@mgrover1](https://github.com/mgrover1))
- FIX: Make sure rsl is installed using python -m [#1124](https://github.com/ARM-DOE/pyart/pull/1124) ([@mgrover1](https://github.com/mgrover1))
- FIX: Make sure trmm rsl path is specified [#1123](https://github.com/ARM-DOE/pyart/pull/1123) ([@mgrover1](https://github.com/mgrover1))
- FIX: Add build package to pypi release [#1120](https://github.com/ARM-DOE/pyart/pull/1120) ([@mgrover1](https://github.com/mgrover1))
- FIX: Update pypi release to only run upon releases [#1119](https://github.com/ARM-DOE/pyart/pull/1119) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix IO for NEXRAD Level 3 instantaneous precipitation rate (DPR) [#1116](https://github.com/ARM-DOE/pyart/pull/1116) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix typo and back in postcard [#1104](https://github.com/ARM-DOE/pyart/pull/1104) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix the missing images in the blog post [#1103](https://github.com/ARM-DOE/pyart/pull/1103) ([@mgrover1](https://github.com/mgrover1))

### Maintenance and upkeep improvements

- MNT: Changing dependency check to Cartopy. [#1148](https://github.com/ARM-DOE/pyart/pull/1148) ([@zssherman](https://github.com/zssherman))
- MNT: Utilize conda for build due to trmm_rsl. [#1122](https://github.com/ARM-DOE/pyart/pull/1122) ([@zssherman](https://github.com/zssherman))
- MNT: Cartopy was not optional in the gridmapdisplay unit tests. [#1100](https://github.com/ARM-DOE/pyart/pull/1100) ([@zssherman](https://github.com/zssherman))
- MNT: Adding pytz as optional dependency. [#1099](https://github.com/ARM-DOE/pyart/pull/1099) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Quick change of a few Jupyter-Notebook cell types  [#1146](https://github.com/ARM-DOE/pyart/pull/1146) ([@jrobrien91](https://github.com/jrobrien91))
- DOC: Blog post on contributing a pull request  [#1145](https://github.com/ARM-DOE/pyart/pull/1145) ([@jrobrien91](https://github.com/jrobrien91))
- DOC: Update to readme and contributors guide [#1106](https://github.com/ARM-DOE/pyart/pull/1106) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Add Xarray to requirements [#1133](https://github.com/ARM-DOE/pyart/pull/1133) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add AWS NEXRAD example in new IO section [#1117](https://github.com/ARM-DOE/pyart/pull/1117) ([@mgrover1](https://github.com/mgrover1))
- ADD: Utility to subset a radar volume for the column above a location [#1113](https://github.com/ARM-DOE/pyart/pull/1113) ([@jrobrien91](https://github.com/jrobrien91))
- DEL: Deleting submodule setup.py. [#1110](https://github.com/ARM-DOE/pyart/pull/1110) ([@zssherman](https://github.com/zssherman))
- DEL: Deleting setup.py in each submodule. Was forgotten in setuptools PR. [#1109](https://github.com/ARM-DOE/pyart/pull/1109) ([@zssherman](https://github.com/zssherman))
- ADD: add verbose flag to qvp code [#1108](https://github.com/ARM-DOE/pyart/pull/1108) ([@dopplerchase](https://github.com/dopplerchase))
- ADD: Add more tests for test_echo_class [#1107](https://github.com/ARM-DOE/pyart/pull/1107) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add NEXRAD Blog Post [#1101](https://github.com/ARM-DOE/pyart/pull/1101) ([@mgrover1](https://github.com/mgrover1))
- ADD: Add changelog section [#1098](https://github.com/ARM-DOE/pyart/pull/1098) ([@mgrover1](https://github.com/mgrover1))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-04-06&to=2022-05-02&type=c))

[@dopplerchase](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplerchase+updated%3A2022-04-06..2022-05-02&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2022-04-06..2022-05-02&type=Issues) | [@jrobrien91](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajrobrien91+updated%3A2022-04-06..2022-05-02&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-04-06..2022-05-02&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-04-06..2022-05-02&type=Issues)

## PyART v1.12.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.8...v1.12.0))

### Bugs fixed

- FIX: Fix doc package version [#1097](https://github.com/ARM-DOE/pyart/pull/1097) ([@mgrover1](https://github.com/mgrover1))
- FIX: Add revisions to GateMapper example [#1094](https://github.com/ARM-DOE/pyart/pull/1094) ([@mgrover1](https://github.com/mgrover1))
- FIX: Fix for mac numpy error for masked array volume metadata. [#1080](https://github.com/ARM-DOE/pyart/pull/1080) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Fix for setup.py registry file. [#1087](https://github.com/ARM-DOE/pyart/pull/1087) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- INSTALL: Use Setuptools For Installation [#1096](https://github.com/ARM-DOE/pyart/pull/1096) ([@mgrover1](https://github.com/mgrover1))
- ADD: Time tolerance to GateMapper [#1093](https://github.com/ARM-DOE/pyart/pull/1093) ([@rcjackson](https://github.com/rcjackson))
- Rename Gatemapper Example to Execute [#1090](https://github.com/ARM-DOE/pyart/pull/1090) ([@mgrover1](https://github.com/mgrover1))
- Add plt.show() [#1089](https://github.com/ARM-DOE/pyart/pull/1089) ([@mgrover1](https://github.com/mgrover1))
- Add an example for Gatemapper [#1088](https://github.com/ARM-DOE/pyart/pull/1088) ([@mgrover1](https://github.com/mgrover1))
- This fixes the title of the blog post [#1085](https://github.com/ARM-DOE/pyart/pull/1085) ([@mgrover1](https://github.com/mgrover1))
- Add a blog post looking at KAZR data [#1084](https://github.com/ARM-DOE/pyart/pull/1084) ([@mgrover1](https://github.com/mgrover1))
- Fix bug in analytics ID [#1081](https://github.com/ARM-DOE/pyart/pull/1081) ([@mgrover1](https://github.com/mgrover1))
- Add new google analytics ID [#1079](https://github.com/ARM-DOE/pyart/pull/1079) ([@mgrover1](https://github.com/mgrover1))
- ADD: Gatefilter to GateMapper. [#1077](https://github.com/ARM-DOE/pyart/pull/1077) ([@rcjackson](https://github.com/rcjackson))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2022-03-15&to=2022-04-06&type=c))

[@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2022-03-15..2022-04-06&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2022-03-15..2022-04-06&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2022-03-15..2022-04-06&type=Issues)

## PyART v1.11.8

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.6...v1.11.8))

### Enhancements made

- ENH: Support for Sigmet PMI, LOG, CSP [#1018](https://github.com/ARM-DOE/pyart/pull/1018) ([@ritvje](https://github.com/ritvje))
- ENH: GAMIC's volume doesn't mandate a pulse_width field [#1014](https://github.com/ARM-DOE/pyart/pull/1014) ([@ReallyNiceGuy](https://github.com/ReallyNiceGuy))

### Bugs fixed

- FIX: Incorrect name used in hasattr. [#1034](https://github.com/ARM-DOE/pyart/pull/1034) ([@zssherman](https://github.com/zssherman))
- FIX: Fixes for overlapping axes in mapdisplay modules. [#1029](https://github.com/ARM-DOE/pyart/pull/1029) ([@zssherman](https://github.com/zssherman))
- FIX: Fix for azimuth_rhi_plot. [#1025](https://github.com/ARM-DOE/pyart/pull/1025) ([@zssherman](https://github.com/zssherman))
- FIX: Set minimum for cost function gradient INF norm to be nyquist interval [#1019](https://github.com/ARM-DOE/pyart/pull/1019) ([@rcjackson](https://github.com/rcjackson))

### Maintenance and upkeep improvements

- MNT: Some cleanup of rxm25 module. [#1075](https://github.com/ARM-DOE/pyart/pull/1075) ([@zssherman](https://github.com/zssherman))
- MNT: Removing pandas import and converters. [#1064](https://github.com/ARM-DOE/pyart/pull/1064) ([@zssherman](https://github.com/zssherman))
- MNT: Some style cleanup of mute_radar functions. [#1033](https://github.com/ARM-DOE/pyart/pull/1033) ([@zssherman](https://github.com/zssherman))
- MNT: Updating cfradial to include scan_name for ARM files. [#1030](https://github.com/ARM-DOE/pyart/pull/1030) ([@zssherman](https://github.com/zssherman))
- MNT: RadxGrid Fix for working with different files. [#1027](https://github.com/ARM-DOE/pyart/pull/1027) ([@zssherman](https://github.com/zssherman))
- MNT: Adds for default field names, horizontal and vertical additions. [#1026](https://github.com/ARM-DOE/pyart/pull/1026) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Adding roadmaps to main repo. [#1059](https://github.com/ARM-DOE/pyart/pull/1059) ([@zssherman](https://github.com/zssherman))
- DOC: Addition of references for rain rate methods. [#1043](https://github.com/ARM-DOE/pyart/pull/1043) ([@zssherman](https://github.com/zssherman))

### Deprecated features

- DEP: Multiple fixes for deprecation warnings. [#1032](https://github.com/ARM-DOE/pyart/pull/1032) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Add blog sidebar [#1074](https://github.com/ARM-DOE/pyart/pull/1074) ([@mgrover1](https://github.com/mgrover1))
- TST: Adding unitests for datetime_utils.py module. [#1072](https://github.com/ARM-DOE/pyart/pull/1072) ([@zssherman](https://github.com/zssherman))
- Added RXM-25 reader [#1071](https://github.com/ARM-DOE/pyart/pull/1071) ([@rtanamachi](https://github.com/rtanamachi))
- Update with PyData Theme [#1069](https://github.com/ARM-DOE/pyart/pull/1069) ([@mgrover1](https://github.com/mgrover1))
- Update examples data link to adc [#1068](https://github.com/ARM-DOE/pyart/pull/1068) ([@mgrover1](https://github.com/mgrover1))
- TST: Adding more tests to gatefilter. [#1067](https://github.com/ARM-DOE/pyart/pull/1067) ([@zssherman](https://github.com/zssherman))
- Add tests for simple moments [#1066](https://github.com/ARM-DOE/pyart/pull/1066) ([@mgrover1](https://github.com/mgrover1))
- Update issue with subplots in GridMapDisplay [#1063](https://github.com/ARM-DOE/pyart/pull/1063) ([@mgrover1](https://github.com/mgrover1))
- Fix codecov [#1061](https://github.com/ARM-DOE/pyart/pull/1061) ([@mgrover1](https://github.com/mgrover1))
- Add new CI workflow to run tests [#1060](https://github.com/ARM-DOE/pyart/pull/1060) ([@mgrover1](https://github.com/mgrover1))
- Update links to docs/examples [#1058](https://github.com/ARM-DOE/pyart/pull/1058) ([@mgrover1](https://github.com/mgrover1))
- Change which directory docs are in [#1056](https://github.com/ARM-DOE/pyart/pull/1056) ([@mgrover1](https://github.com/mgrover1))
- Fix missing images [#1055](https://github.com/ARM-DOE/pyart/pull/1055) ([@mgrover1](https://github.com/mgrover1))
- Remove Linear Programming Phase Processing Example for Now [#1053](https://github.com/ARM-DOE/pyart/pull/1053) ([@mgrover1](https://github.com/mgrover1))
- Fix non-example building [#1051](https://github.com/ARM-DOE/pyart/pull/1051) ([@mgrover1](https://github.com/mgrover1))
- Build Examples with Github Actions [#1050](https://github.com/ARM-DOE/pyart/pull/1050) ([@mgrover1](https://github.com/mgrover1))
- Add example data into testing module [#1048](https://github.com/ARM-DOE/pyart/pull/1048) ([@mgrover1](https://github.com/mgrover1))
- Fix incorrect branch name in action [#1040](https://github.com/ARM-DOE/pyart/pull/1040) ([@mgrover1](https://github.com/mgrover1))
- Use Github Actions for Building the Docs [#1039](https://github.com/ARM-DOE/pyart/pull/1039) ([@mgrover1](https://github.com/mgrover1))
- Add Google Analytics [#1038](https://github.com/ARM-DOE/pyart/pull/1038) ([@mgrover1](https://github.com/mgrover1))
- Add function to "image mute" radar object [#1031](https://github.com/ARM-DOE/pyart/pull/1031) ([@lauratomkins](https://github.com/lauratomkins))
- ADD: Adding a feature to map gates of approximately equivalent location from one radar geometry to another [#1024](https://github.com/ARM-DOE/pyart/pull/1024) ([@rcjackson](https://github.com/rcjackson))
- ADD: Options to select ODIM HDF5 datasets [#1020](https://github.com/ARM-DOE/pyart/pull/1020) ([@ritvje](https://github.com/ritvje))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2021-09-23&to=2022-03-15&type=c))

[@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2021-09-23..2022-03-15&type=Issues) | [@HumphreysCarter](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AHumphreysCarter+updated%3A2021-09-23..2022-03-15&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2021-09-23..2022-03-15&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2021-09-23..2022-03-15&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2021-09-23..2022-03-15&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2021-09-23..2022-03-15&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2021-09-23..2022-03-15&type=Issues) | [@ReallyNiceGuy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AReallyNiceGuy+updated%3A2021-09-23..2022-03-15&type=Issues) | [@ritvje](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aritvje+updated%3A2021-09-23..2022-03-15&type=Issues) | [@rtanamachi](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Artanamachi+updated%3A2021-09-23..2022-03-15&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2021-09-23..2022-03-15&type=Issues) | [@tkralphs](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atkralphs+updated%3A2021-09-23..2022-03-15&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2021-09-23..2022-03-15&type=Issues)

## PyART v1.11.6

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.5...v1.11.6))

### Enhancements made

- ENH: Default scan_rate to target_scan_rate [#1003](https://github.com/ARM-DOE/pyart/pull/1003) ([@ReallyNiceGuy](https://github.com/ReallyNiceGuy))
- ENH: Enable support for float32 data in GAMIC volume format [#1002](https://github.com/ARM-DOE/pyart/pull/1002) ([@ReallyNiceGuy](https://github.com/ReallyNiceGuy))
- ENH: Adding browning vad code as a replacement. [#997](https://github.com/ARM-DOE/pyart/pull/997) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: Remove xarray for 3.6 testing incompatible with python 3.6 [#1007](https://github.com/ARM-DOE/pyart/pull/1007) ([@zssherman](https://github.com/zssherman))
- FIX: Correctly decode format from bytes to str [#1001](https://github.com/ARM-DOE/pyart/pull/1001) ([@ReallyNiceGuy](https://github.com/ReallyNiceGuy))
- FIX: Fix for tick and ticklabs params. [#995](https://github.com/ARM-DOE/pyart/pull/995) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Updated cfradial to handle new arm kazr strings. [#1010](https://github.com/ARM-DOE/pyart/pull/1010) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Update of travis link. [#999](https://github.com/ARM-DOE/pyart/pull/999) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- STY: Fixes for PEP8 warnings. [#1009](https://github.com/ARM-DOE/pyart/pull/1009) ([@zssherman](https://github.com/zssherman))
- Radx grid [#1005](https://github.com/ARM-DOE/pyart/pull/1005) ([@zssherman](https://github.com/zssherman))
- Change default weighting function to Barnes2  [#988](https://github.com/ARM-DOE/pyart/pull/988) ([@Quba1](https://github.com/Quba1))
- Added additional colorbar functionality [#984](https://github.com/ARM-DOE/pyart/pull/984) ([@HumphreysCarter](https://github.com/HumphreysCarter))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2021-05-25&to=2021-09-23&type=c))

[@HumphreysCarter](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AHumphreysCarter+updated%3A2021-05-25..2021-09-23&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2021-05-25..2021-09-23&type=Issues) | [@Quba1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AQuba1+updated%3A2021-05-25..2021-09-23&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2021-05-25..2021-09-23&type=Issues) | [@ReallyNiceGuy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AReallyNiceGuy+updated%3A2021-05-25..2021-09-23&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2021-05-25..2021-09-23&type=Issues)


## PyART v1.11.5

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.3...v1.11.5))

### Enhancements made

- ENH: Addition of TDWR support. [#969](https://github.com/ARM-DOE/pyart/pull/969) ([@zssherman](https://github.com/zssherman))
- ENH: Adding copy_field_dtype to grid mapper. [#956](https://github.com/ARM-DOE/pyart/pull/956) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: Fix for cftime 1.5 release. [#994](https://github.com/ARM-DOE/pyart/pull/994) ([@zssherman](https://github.com/zssherman))
- FIX: Removal of warning to fix unit tests. [#979](https://github.com/ARM-DOE/pyart/pull/979) ([@zssherman](https://github.com/zssherman))
- FIX: Fix for h5py > 3.0 decoding of str. [#978](https://github.com/ARM-DOE/pyart/pull/978) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Update dep warning for June1st default switch to barnes2. [#989](https://github.com/ARM-DOE/pyart/pull/989) ([@zssherman](https://github.com/zssherman))
- MNT: Add all TDWR radar locations [#973](https://github.com/ARM-DOE/pyart/pull/973) ([@zssherman](https://github.com/zssherman))
- MAINT: Updated all cython files for python 3.9 [#966](https://github.com/ARM-DOE/pyart/pull/966) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Add check if radars tuple is not empty [#991](https://github.com/ARM-DOE/pyart/pull/991) ([@Quba1](https://github.com/Quba1))
- CI: More python 3.9 fixes and attempt to build 3.9. [#983](https://github.com/ARM-DOE/pyart/pull/983) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2020-11-11&to=2021-05-25&type=c))

[@amarouane-ABDELHAK](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aamarouane-ABDELHAK+updated%3A2020-11-11..2021-05-25&type=Issues) | [@bmgxyz](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Abmgxyz+updated%3A2020-11-11..2021-05-25&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2020-11-11..2021-05-25&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2020-11-11..2021-05-25&type=Issues) | [@Quba1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AQuba1+updated%3A2020-11-11..2021-05-25&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2020-11-11..2021-05-25&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2020-11-11..2021-05-25&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2020-11-11..2021-05-25&type=Issues)


## PyART v1.11.3

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.2...v1.11.3))

### Bugs fixed

- FIX: Fix addressed for #962 by mwilson14. [#963](https://github.com/ARM-DOE/pyart/pull/963) ([@zssherman](https://github.com/zssherman))
- FIX: A fix for the NoneType error with regards to nexrad 3 elevation. [#959](https://github.com/ARM-DOE/pyart/pull/959) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Update to default config to fix units, and add field info for attenuation fields. [#964](https://github.com/ARM-DOE/pyart/pull/964) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2020-09-02&to=2020-11-11&type=c))

[@bmgxyz](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Abmgxyz+updated%3A2020-09-02..2020-11-11&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2020-09-02..2020-11-11&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2020-09-02..2020-11-11&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2020-09-02..2020-11-11&type=Issues)


## PyART v1.11.2

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.1...v1.11.2))

### Enhancements made

- ENH: Support for Product 176 (DPR) - Instantaneous Precipitation Rate [#919](https://github.com/ARM-DOE/pyart/pull/919) ([@dcedgren](https://github.com/dcedgren))
- ENH: Updated nexrad for RDA build 19.0. [#903](https://github.com/ARM-DOE/pyart/pull/903) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: add_gate_area now returns only positive values [#950](https://github.com/ARM-DOE/pyart/pull/950) ([@rtanamachi](https://github.com/rtanamachi))
- FIX: Gate to grid map blotchy [#947](https://github.com/ARM-DOE/pyart/pull/947) ([@rcjackson](https://github.com/rcjackson))
- FIX: Fix for missing gatefilter in map_to_grid. [#946](https://github.com/ARM-DOE/pyart/pull/946) ([@zssherman](https://github.com/zssherman))
- FIX: Fixes boolean indexing error. [#944](https://github.com/ARM-DOE/pyart/pull/944) ([@zssherman](https://github.com/zssherman))
- FIX: Issue #694 when working with ODIM with empty moment. [#938](https://github.com/ARM-DOE/pyart/pull/938) ([@vlouf](https://github.com/vlouf))
- FIX: Nearest neighbor code [#934](https://github.com/ARM-DOE/pyart/pull/934) ([@rcjackson](https://github.com/rcjackson))
- FIX: Elevation Angle for some products [#925](https://github.com/ARM-DOE/pyart/pull/925) ([@dcedgren](https://github.com/dcedgren))
- FIX: This converts the nexrad altitude from feet to meters. [#924](https://github.com/ARM-DOE/pyart/pull/924) ([@zssherman](https://github.com/zssherman))
- FIX: A fix for reversed ngates and nrays. [#917](https://github.com/ARM-DOE/pyart/pull/917) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Attempt to fix appveyor path issue. [#937](https://github.com/ARM-DOE/pyart/pull/937) ([@zssherman](https://github.com/zssherman))
- MNT: Removing temp fix and using suggested cftime developer fix. [#927](https://github.com/ARM-DOE/pyart/pull/927) ([@zssherman](https://github.com/zssherman))
- MNT: New warnings on literals, and a fix for said warnings. [#914](https://github.com/ARM-DOE/pyart/pull/914) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- TST: Unit test of get_gate_area and some cleanup. [#949](https://github.com/ARM-DOE/pyart/pull/949) ([@zssherman](https://github.com/zssherman))
- add get_gate_area [#948](https://github.com/ARM-DOE/pyart/pull/948) ([@rtanamachi](https://github.com/rtanamachi))
- Fix in filter_psidp in case of scalar mask [#929](https://github.com/ARM-DOE/pyart/pull/929) ([@wolfidan](https://github.com/wolfidan))
- ADD: Nexrad Level 3 Product Version Checking [#926](https://github.com/ARM-DOE/pyart/pull/926) ([@dcedgren](https://github.com/dcedgren))
- ADD: Corner Reflector Raster Scan Plotting [#920](https://github.com/ARM-DOE/pyart/pull/920) ([@AdamTheisen](https://github.com/AdamTheisen))
- ADD: Adding more example notebooks. [#915](https://github.com/ARM-DOE/pyart/pull/915) ([@zssherman](https://github.com/zssherman))
- ADD: Adding a basic ingest using Py-ART's testing object example notebook. [#911](https://github.com/ARM-DOE/pyart/pull/911) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2020-03-20&to=2020-09-02&type=c))

[@AdamTheisen](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AAdamTheisen+updated%3A2020-03-20..2020-09-02&type=Issues) | [@dcedgren](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adcedgren+updated%3A2020-03-20..2020-09-02&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2020-03-20..2020-09-02&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2020-03-20..2020-09-02&type=Issues) | [@grwise1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agrwise1+updated%3A2020-03-20..2020-09-02&type=Issues) | [@hhuangwx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ahhuangwx+updated%3A2020-03-20..2020-09-02&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2020-03-20..2020-09-02&type=Issues) | [@jsignell](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajsignell+updated%3A2020-03-20..2020-09-02&type=Issues) | [@lauratomkins](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alauratomkins+updated%3A2020-03-20..2020-09-02&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2020-03-20..2020-09-02&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2020-03-20..2020-09-02&type=Issues) | [@rtanamachi](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Artanamachi+updated%3A2020-03-20..2020-09-02&type=Issues) | [@Rumpkie](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ARumpkie+updated%3A2020-03-20..2020-09-02&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2020-03-20..2020-09-02&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2020-03-20..2020-09-02&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2020-03-20..2020-09-02&type=Issues) | [@wolfidan](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awolfidan+updated%3A2020-03-20..2020-09-02&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2020-03-20..2020-09-02&type=Issues)


## PyART v1.11.1

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.11.0...v1.11.1))

### Bugs fixed

- FIX: A fix for the update in one of the datetime modules that broke CI [#913](https://github.com/ARM-DOE/pyart/pull/913) ([@zssherman](https://github.com/zssherman))
- FIX: Fix for msg29 function extra parameter. [#909](https://github.com/ARM-DOE/pyart/pull/909) ([@zssherman](https://github.com/zssherman))
- FIX: Fix to optional doc and warning message for attenuation code. [#907](https://github.com/ARM-DOE/pyart/pull/907) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Adding MPL framework classifier, addresses #910. [#912](https://github.com/ARM-DOE/pyart/pull/912) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Some documentation changes for new sphinx napoleon that was missed in previous pull request. [#902](https://github.com/ARM-DOE/pyart/pull/902) ([@zssherman](https://github.com/zssherman))
- DOC: Update to docs to use rtd theme and remove python 2 from docs. [#893](https://github.com/ARM-DOE/pyart/pull/893) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- ADD: Initial commit for radar spectra for KAZR. [#892](https://github.com/ARM-DOE/pyart/pull/892) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2020-01-30&to=2020-03-20&type=c))

[@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2020-01-30..2020-03-20&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2020-01-30..2020-03-20&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2020-01-30..2020-03-20&type=Issues)


## PyART v1.11.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.10.4...v1.11.0))

### Bugs fixed

- FIX: odimh5 range and azimuth sampling [#898](https://github.com/ARM-DOE/pyart/pull/898) ([@vlouf](https://github.com/vlouf))
- FIX: Closing ODIM h5 files. #895 [#896](https://github.com/ARM-DOE/pyart/pull/896) ([@vlouf](https://github.com/vlouf))

### Maintenance and upkeep improvements

- MNT: Suggested changes of automatically setting roi_func to constant if constant_roi is used. [#864](https://github.com/ARM-DOE/pyart/pull/864) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2020-01-15&to=2020-01-30&type=c))

[@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2020-01-15..2020-01-30&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2020-01-15..2020-01-30&type=Issues) | [@louiswicker](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alouiswicker+updated%3A2020-01-15..2020-01-30&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2020-01-15..2020-01-30&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2020-01-15..2020-01-30&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2020-01-15..2020-01-30&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2020-01-15..2020-01-30&type=Issues)


## PyART v1.10.4

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.10.3...v1.10.4))

### Enhancements made

- ENH: Speedup of hilderbrand code created by meteoswiss, I'm just committing. [#877](https://github.com/ARM-DOE/pyart/pull/877) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: Fixes possible geos update that broke point calculation for lambert ticks. [#886](https://github.com/ARM-DOE/pyart/pull/886) ([@zssherman](https://github.com/zssherman))
- FIX: Crash when only one region found in optimization loop for region… [#878](https://github.com/ARM-DOE/pyart/pull/878) ([@rcjackson](https://github.com/rcjackson))

### Other merged PRs

- fix(xarray): Gate xarray so its optional [#891](https://github.com/ARM-DOE/pyart/pull/891) ([@zflamig](https://github.com/zflamig))
- PY: Removing all futures relating to Python 2. [#890](https://github.com/ARM-DOE/pyart/pull/890) ([@zssherman](https://github.com/zssherman))
- PY: Removing Python 2.7 support from CI and documentation. [#889](https://github.com/ARM-DOE/pyart/pull/889) ([@zssherman](https://github.com/zssherman))
- Added option to ignore tilt angle in `plot_sweep_grid` [#885](https://github.com/ARM-DOE/pyart/pull/885) ([@dstex](https://github.com/dstex))
- CI: Adding CI for Python 3.8 as it is now on conda-forge. [#880](https://github.com/ARM-DOE/pyart/pull/880) ([@zssherman](https://github.com/zssherman))
- CI: Removing basemap as dependency in unit tests, support ends soon 2020, fails CI with 2.7. [#879](https://github.com/ARM-DOE/pyart/pull/879) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2019-10-28&to=2020-01-15&type=c))

[@dstex](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adstex+updated%3A2019-10-28..2020-01-15&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2019-10-28..2020-01-15&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2019-10-28..2020-01-15&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2019-10-28..2020-01-15&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2019-10-28..2020-01-15&type=Issues) | [@zflamig](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azflamig+updated%3A2019-10-28..2020-01-15&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2019-10-28..2020-01-15&type=Issues)


## PyART v1.10.3

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.10.2...v1.10.3))

### Enhancements made

- ENH: Added imshow as option for plot_grid and fixed bugs in to_xarray. [#873](https://github.com/ARM-DOE/pyart/pull/873) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: Fixes fill value issue with netCDF4. [#876](https://github.com/ARM-DOE/pyart/pull/876) ([@zssherman](https://github.com/zssherman))
- FIX: Fixed future warnings for elementwise comparison in colormap code [#867](https://github.com/ARM-DOE/pyart/pull/867) ([@AdamTheisen](https://github.com/AdamTheisen))

### Documentation improvements

- DOC: Adding some statements on Anaconda compilers and some FAQs from pyart google groups. [#868](https://github.com/ARM-DOE/pyart/pull/868) ([@zssherman](https://github.com/zssherman))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2019-09-17&to=2019-10-28&type=c))

[@AdamTheisen](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AAdamTheisen+updated%3A2019-09-17..2019-10-28&type=Issues) | [@Jillinger](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AJillinger+updated%3A2019-09-17..2019-10-28&type=Issues) | [@mvanlierwalq](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amvanlierwalq+updated%3A2019-09-17..2019-10-28&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2019-09-17..2019-10-28&type=Issues) | [@zhaobudaola](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azhaobudaola+updated%3A2019-09-17..2019-10-28&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2019-09-17..2019-10-28&type=Issues)


## PyART v1.10.2

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.10.1...v1.10.2))

### Enhancements made

- ENH: Adding ticks and ticklabs as parameters. [#848](https://github.com/ARM-DOE/pyart/pull/848) ([@zssherman](https://github.com/zssherman))
- ENH: Added argument in io/grid_io.py and core/grid.py   [#846](https://github.com/ARM-DOE/pyart/pull/846) ([@jhemedin](https://github.com/jhemedin))
- ENH: Adding get_gate_lat_lon_alt function. [#841](https://github.com/ARM-DOE/pyart/pull/841) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: ODIM reader with nbins being an array [#865](https://github.com/ARM-DOE/pyart/pull/865) ([@scollis](https://github.com/scollis))
- FIX: Fixes colormap issue for HomeyerRainbow colormap [#856](https://github.com/ARM-DOE/pyart/pull/856) ([@zssherman](https://github.com/zssherman))
- FIX: A fix for a bug in grid io which had dimensions out of order. [#840](https://github.com/ARM-DOE/pyart/pull/840) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: rounding is causing lat and lon lines with data outside plot. [#852](https://github.com/ARM-DOE/pyart/pull/852) ([@zssherman](https://github.com/zssherman))
- MAINT: Temp fix for warnings in colormap modules. [#849](https://github.com/ARM-DOE/pyart/pull/849) ([@zssherman](https://github.com/zssherman))
- MAINT: Moved get_dataset from gridmapdisplay.py to grid.py and renamed to to_xarray [#845](https://github.com/ARM-DOE/pyart/pull/845) ([@jhemedin](https://github.com/jhemedin))
- MNT: Doc cleanup, removal of unused variables, added docstrings. raise error fix and more. [#838](https://github.com/ARM-DOE/pyart/pull/838) ([@zssherman](https://github.com/zssherman))
- MNT: Add xarray and added path info for CyLP and removed older pythons in docs. [#836](https://github.com/ARM-DOE/pyart/pull/836) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Updated cheatsheet. [#847](https://github.com/ARM-DOE/pyart/pull/847) ([@zssherman](https://github.com/zssherman))
- DOC: Remove fortran bit and added info on conda environments. Removed nose from contr guide. [#843](https://github.com/ARM-DOE/pyart/pull/843) ([@zssherman](https://github.com/zssherman))
- DOC: FIxed spelling errors in example and doc string in gridmapdisplay.py. [#835](https://github.com/ARM-DOE/pyart/pull/835) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Allow read_d3r_gcpex_nc function to read the altitude variable from netCDF file [#842](https://github.com/ARM-DOE/pyart/pull/842) ([@amarouane-ABDELHAK](https://github.com/amarouane-ABDELHAK))
- Fix for reading ECCC ODIM files [#837](https://github.com/ARM-DOE/pyart/pull/837) ([@taylbm](https://github.com/taylbm))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2019-04-24&to=2019-09-17&type=c))

[@amarouane-ABDELHAK](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aamarouane-ABDELHAK+updated%3A2019-04-24..2019-09-17&type=Issues) | [@jhemedin](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajhemedin+updated%3A2019-04-24..2019-09-17&type=Issues) | [@kenkehoe](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akenkehoe+updated%3A2019-04-24..2019-09-17&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2019-04-24..2019-09-17&type=Issues) | [@mvanlierwalq](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amvanlierwalq+updated%3A2019-04-24..2019-09-17&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2019-04-24..2019-09-17&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2019-04-24..2019-09-17&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2019-04-24..2019-09-17&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2019-04-24..2019-09-17&type=Issues) | [@taylbm](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ataylbm+updated%3A2019-04-24..2019-09-17&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2019-04-24..2019-09-17&type=Issues)


## PyART v1.10.1

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.9.2-picasso...v1.10.1))

### Enhancements made

- ENH: Moved doc build to python 3.7 instead of python 2.7.  [#827](https://github.com/ARM-DOE/pyart/pull/827) ([@zssherman](https://github.com/zssherman))
- ENH: Added python 3.7, removed 32 bit testing, setting conda env path in attempt to fix issue finding dependencies. [#822](https://github.com/ARM-DOE/pyart/pull/822) ([@zssherman](https://github.com/zssherman))
- ENH: Adding Barnes 2 weighting function. [#806](https://github.com/ARM-DOE/pyart/pull/806) ([@zssherman](https://github.com/zssherman))
- ENH: Faster optimization loop in region based dealiasing + extra continuity term [#804](https://github.com/ARM-DOE/pyart/pull/804) ([@rcjackson](https://github.com/rcjackson))
- ENH: Adding link to setting up a conda Py-ART environment on the pyart main page. [#800](https://github.com/ARM-DOE/pyart/pull/800) ([@zssherman](https://github.com/zssherman))
- ENH: Nearest neighbor in map_to_grid [#778](https://github.com/ARM-DOE/pyart/pull/778) ([@rcjackson](https://github.com/rcjackson))
- ENH: Changed default reflectivity colormap to HomeyerRainbow. [#773](https://github.com/ARM-DOE/pyart/pull/773) ([@zssherman](https://github.com/zssherman))
- ENH: Drop FORTRAN dependancy for computing Steiner classification [#688](https://github.com/ARM-DOE/pyart/pull/688) ([@vlouf](https://github.com/vlouf))

### Bugs fixed

- FIX: Skip empty scans and incomplete MSG5's [#832](https://github.com/ARM-DOE/pyart/pull/832) ([@rcjackson](https://github.com/rcjackson))
- FIX: A fix suggested by @scollis for the bug in rhi plotting found by @swnesbitt [#820](https://github.com/ARM-DOE/pyart/pull/820) ([@zssherman](https://github.com/zssherman))
- BUG: Region based dealiasing cost function would crash when there was only one region [#812](https://github.com/ARM-DOE/pyart/pull/812) ([@rcjackson](https://github.com/rcjackson))
- FIX: added argument to deal with negative fixed_angles [#809](https://github.com/ARM-DOE/pyart/pull/809) ([@jhemedin](https://github.com/jhemedin))
- FIX: Contiuum Analytics renamed to Anaconda, fixed broken link on gh-pages. [#795](https://github.com/ARM-DOE/pyart/pull/795) ([@zssherman](https://github.com/zssherman))
- FIX: CI fix. explicit add of GDAL for py2.7 [#790](https://github.com/ARM-DOE/pyart/pull/790) ([@scollis](https://github.com/scollis))
- FIX: A fix for install.sh suggested by Kai Muehlbauer, add conda-forge. [#789](https://github.com/ARM-DOE/pyart/pull/789) ([@zssherman](https://github.com/zssherman))
- FIX: An attempt to fix basemap pyproj issue. [#777](https://github.com/ARM-DOE/pyart/pull/777) ([@zssherman](https://github.com/zssherman))
- BUG: prevent IndexError in check_outliers [#776](https://github.com/ARM-DOE/pyart/pull/776) ([@juhi24](https://github.com/juhi24))
- FIX: This is a temporary fix for Cartopy issue #1120. [#770](https://github.com/ARM-DOE/pyart/pull/770) ([@zssherman](https://github.com/zssherman))
- FIX: The imp module was throwing a deprecation error for newer python versions [#675](https://github.com/ARM-DOE/pyart/pull/675) ([@zssherman](https://github.com/zssherman))

### Maintenance and upkeep improvements

- MNT: Removed fortran from pyart. [#824](https://github.com/ARM-DOE/pyart/pull/824) ([@zssherman](https://github.com/zssherman))
- MAINT: Reverted init back to original state, minus having nose. [#803](https://github.com/ARM-DOE/pyart/pull/803) ([@zssherman](https://github.com/zssherman))
- MAINT: Updated cftime import as suggested in issue #738 [#799](https://github.com/ARM-DOE/pyart/pull/799) ([@zssherman](https://github.com/zssherman))
- MAINT: Changing github documentation to mention Cartopy over Basemap. [#792](https://github.com/ARM-DOE/pyart/pull/792) ([@zssherman](https://github.com/zssherman))
- MAINT: Change of graph modules to reflect favoring of Cartopy. [#791](https://github.com/ARM-DOE/pyart/pull/791) ([@zssherman](https://github.com/zssherman))
- MAINT: Removal of basemap from core modules and some fixes. [#786](https://github.com/ARM-DOE/pyart/pull/786) ([@zssherman](https://github.com/zssherman))
- MAINT: changed desired_angle so user can set the radar tilt angle [#784](https://github.com/ARM-DOE/pyart/pull/784) ([@jhemedin](https://github.com/jhemedin))

### Documentation improvements

- DOC: Contiuum Analytics renamed itself to Anaconda inc. Updated broken links. [#794](https://github.com/ARM-DOE/pyart/pull/794) ([@zssherman](https://github.com/zssherman))
- DOC: update dependency info, fix rst preformatting [#779](https://github.com/ARM-DOE/pyart/pull/779) ([@juhi24](https://github.com/juhi24))

### Other merged PRs

- Created  new eaxmple [#834](https://github.com/ARM-DOE/pyart/pull/834) ([@jhemedin](https://github.com/jhemedin))
- CI: Removing python 3.5 CI testing. [#833](https://github.com/ARM-DOE/pyart/pull/833) ([@zssherman](https://github.com/zssherman))
- Force typing to match sweep indices elsewhere. [#831](https://github.com/ARM-DOE/pyart/pull/831) ([@nguy](https://github.com/nguy))
- ADD: new GridMapDisplay class that uses Xarray and Cartopy. [#828](https://github.com/ARM-DOE/pyart/pull/828) ([@jhemedin](https://github.com/jhemedin))
- Master [#821](https://github.com/ARM-DOE/pyart/pull/821) ([@tjlang](https://github.com/tjlang))
- CI: Fix for Python 3.4 issue with pytest.  [#818](https://github.com/ARM-DOE/pyart/pull/818) ([@zssherman](https://github.com/zssherman))
- Atteunation correction fixes [#817](https://github.com/ARM-DOE/pyart/pull/817) ([@rcjackson](https://github.com/rcjackson))
- Masked array check in simulated_velocity [#811](https://github.com/ARM-DOE/pyart/pull/811) ([@rcjackson](https://github.com/rcjackson))
- CI: Removed basemap from Python 2.7 appveyor testing. [#802](https://github.com/ARM-DOE/pyart/pull/802) ([@zssherman](https://github.com/zssherman))
- Attempt to grab icao from Nexrad header [#801](https://github.com/ARM-DOE/pyart/pull/801) ([@nguy](https://github.com/nguy))
- ADD: Adding basic environment file and setting up conda environments rst file. [#796](https://github.com/ARM-DOE/pyart/pull/796) ([@zssherman](https://github.com/zssherman))
- New and updated plot_ppi examples for basemap and cartopy [#793](https://github.com/ARM-DOE/pyart/pull/793) ([@jhemedin](https://github.com/jhemedin))
- ADD: Meteoswiss differential attenuation code [#787](https://github.com/ARM-DOE/pyart/pull/787) ([@rcjackson](https://github.com/rcjackson))
- ADD: added a function that will make a QVP object from a radar object  [#783](https://github.com/ARM-DOE/pyart/pull/783) ([@jhemedin](https://github.com/jhemedin))
- ADD: include_fields parameter [#781](https://github.com/ARM-DOE/pyart/pull/781) ([@rcjackson](https://github.com/rcjackson))
- Add balance CVD friendly colormap [#775](https://github.com/ARM-DOE/pyart/pull/775) ([@scollis](https://github.com/scollis))
- Gridding handles 1D radar lat, lon, alt [#774](https://github.com/ARM-DOE/pyart/pull/774) ([@rtanamachi](https://github.com/rtanamachi))
- ADD: added a function that will make a VAD profile from a radar scan and a unit test to go along with the function [#769](https://github.com/ARM-DOE/pyart/pull/769) ([@jhemedin](https://github.com/jhemedin))
- Don't crash on broken nexrad NL2 [#765](https://github.com/ARM-DOE/pyart/pull/765) ([@miaoneng](https://github.com/miaoneng))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2018-09-06&to=2019-04-24&type=c))

[@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2018-09-06..2019-04-24&type=Issues) | [@dstex](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adstex+updated%3A2018-09-06..2019-04-24&type=Issues) | [@gewitterblitz](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agewitterblitz+updated%3A2018-09-06..2019-04-24&type=Issues) | [@HumphreysCarter](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AHumphreysCarter+updated%3A2018-09-06..2019-04-24&type=Issues) | [@jhemedin](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajhemedin+updated%3A2018-09-06..2019-04-24&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2018-09-06..2019-04-24&type=Issues) | [@juhi24](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajuhi24+updated%3A2018-09-06..2019-04-24&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2018-09-06..2019-04-24&type=Issues) | [@liliaow567](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aliliaow567+updated%3A2018-09-06..2019-04-24&type=Issues) | [@louiswicker](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Alouiswicker+updated%3A2018-09-06..2019-04-24&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2018-09-06..2019-04-24&type=Issues) | [@miaoneng](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amiaoneng+updated%3A2018-09-06..2019-04-24&type=Issues) | [@mvanlierwalq](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amvanlierwalq+updated%3A2018-09-06..2019-04-24&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2018-09-06..2019-04-24&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2018-09-06..2019-04-24&type=Issues) | [@rtanamachi](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Artanamachi+updated%3A2018-09-06..2019-04-24&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2018-09-06..2019-04-24&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2018-09-06..2019-04-24&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2018-09-06..2019-04-24&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2018-09-06..2019-04-24&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2018-09-06..2019-04-24&type=Issues)


## PyART v1.9.2-picasso

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.9.1-picasso...v1.9.2-picasso))

### Enhancements made

- ENH: Gatefiltered LP codes [#764](https://github.com/ARM-DOE/pyart/pull/764) ([@scollis](https://github.com/scollis))

### Bugs fixed

- FIX: Fixes an issue that, when python-coveralls is installed. [#767](https://github.com/ARM-DOE/pyart/pull/767) ([@zssherman](https://github.com/zssherman))
- FIX: Added a warning messsage when an axes is defined without a projection [#761](https://github.com/ARM-DOE/pyart/pull/761) ([@jhemedin](https://github.com/jhemedin))
- FIX: Fixed an issue of nexrad level 2 throwing an error when no msg5 … [#757](https://github.com/ARM-DOE/pyart/pull/757) ([@scollis](https://github.com/scollis))
- FIX: Fixes a bug where set_rasterized is always True. [#748](https://github.com/ARM-DOE/pyart/pull/748) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Changes to docstrings in a few files and pep8 changes. Review after accepting #754 [#755](https://github.com/ARM-DOE/pyart/pull/755) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Recompile cython code with cython 0.28.4 [#758](https://github.com/ARM-DOE/pyart/pull/758) ([@ngoldbaum](https://github.com/ngoldbaum))
- TST: Switch from Nose to Pytest, NOTE: This still needs some work, needed CI to run. [#754](https://github.com/ARM-DOE/pyart/pull/754) ([@zssherman](https://github.com/zssherman))
- STY: Spelling error in cfradial files. Changed reciever to receiver. [#752](https://github.com/ARM-DOE/pyart/pull/752) ([@zssherman](https://github.com/zssherman))
- Fix MaskedArray Error in gate_id.py #749 [#750](https://github.com/ARM-DOE/pyart/pull/750) ([@vlouf](https://github.com/vlouf))
- allow reading from MDV with unknown vertical level [#746](https://github.com/ARM-DOE/pyart/pull/746) ([@gamaanderson](https://github.com/gamaanderson))
- Fix written error [#744](https://github.com/ARM-DOE/pyart/pull/744) ([@zxdawn](https://github.com/zxdawn))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2018-05-17&to=2018-09-06&type=c))

[@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2018-05-17..2018-09-06&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2018-05-17..2018-09-06&type=Issues) | [@gewitterblitz](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agewitterblitz+updated%3A2018-05-17..2018-09-06&type=Issues) | [@jhemedin](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajhemedin+updated%3A2018-05-17..2018-09-06&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2018-05-17..2018-09-06&type=Issues) | [@liliaow567](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aliliaow567+updated%3A2018-05-17..2018-09-06&type=Issues) | [@ngoldbaum](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Angoldbaum+updated%3A2018-05-17..2018-09-06&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2018-05-17..2018-09-06&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2018-05-17..2018-09-06&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2018-05-17..2018-09-06&type=Issues) | [@zxdawn](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azxdawn+updated%3A2018-05-17..2018-09-06&type=Issues)


## PyART v1.9.1-picasso

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.9.0-picasso...v1.9.1-picasso))

### Bugs fixed

- FIX: netcdftime was changed to cftime. Causes travis to fail. Changed import name to reflect new name. [#736](https://github.com/ARM-DOE/pyart/pull/736) ([@zssherman](https://github.com/zssherman))
- FIX: typo in ARM badge [#731](https://github.com/ARM-DOE/pyart/pull/731) ([@scollis](https://github.com/scollis))
- FIX: A fix suggested by meteoswiss-mdr for the dot_product error mentioned in issue #726. [#729](https://github.com/ARM-DOE/pyart/pull/729) ([@zssherman](https://github.com/zssherman))
- FIX: def test_rhi_elevation was used twice, the other should be named after field data. [#724](https://github.com/ARM-DOE/pyart/pull/724) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Added more links to optional dependencies, removed broken links. [#728](https://github.com/ARM-DOE/pyart/pull/728) ([@zssherman](https://github.com/zssherman))
- DOC: Changes to documentation in README.rst and radar.py. [#727](https://github.com/ARM-DOE/pyart/pull/727) ([@zssherman](https://github.com/zssherman))
- DOC: Added pyart build in place install for nosetests and added import order list. [#715](https://github.com/ARM-DOE/pyart/pull/715) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- Add VRADH and VRADV quantities to ODIM HDF5 decoder [#739](https://github.com/ARM-DOE/pyart/pull/739) ([@es5nhc](https://github.com/es5nhc))
- Fixed issues with radar's info() function and numeric fields [#735](https://github.com/ARM-DOE/pyart/pull/735) ([@wave100](https://github.com/wave100))
- Fix bug in sign calculation [#734](https://github.com/ARM-DOE/pyart/pull/734) ([@wave100](https://github.com/wave100))
- Fix TypeError when displaying products without standard names [#733](https://github.com/ARM-DOE/pyart/pull/733) ([@wave100](https://github.com/wave100))
- ADD: Guides directory [#730](https://github.com/ARM-DOE/pyart/pull/730) ([@zssherman](https://github.com/zssherman))
- Fix wradlib  [#723](https://github.com/ARM-DOE/pyart/pull/723) ([@kmuehlbauer](https://github.com/kmuehlbauer))
- Comp texture [#721](https://github.com/ARM-DOE/pyart/pull/721) ([@rcjackson](https://github.com/rcjackson))
- ADD: Cameron Homeyer's colormap [#716](https://github.com/ARM-DOE/pyart/pull/716) ([@rcjackson](https://github.com/rcjackson))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2018-02-15&to=2018-05-17&type=c))

[@CameronHomeyer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ACameronHomeyer+updated%3A2018-02-15..2018-05-17&type=Issues) | [@dopplerchase](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplerchase+updated%3A2018-02-15..2018-05-17&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2018-02-15..2018-05-17&type=Issues) | [@es5nhc](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aes5nhc+updated%3A2018-02-15..2018-05-17&type=Issues) | [@jamessong](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajamessong+updated%3A2018-02-15..2018-05-17&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2018-02-15..2018-05-17&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2018-02-15..2018-05-17&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2018-02-15..2018-05-17&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2018-02-15..2018-05-17&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2018-02-15..2018-05-17&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2018-02-15..2018-05-17&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2018-02-15..2018-05-17&type=Issues) | [@wave100](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awave100+updated%3A2018-02-15..2018-05-17&type=Issues) | [@winash12](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awinash12+updated%3A2018-02-15..2018-05-17&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2018-02-15..2018-05-17&type=Issues)


## PyART v1.9.0-picasso

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.8.0...v1.9.0-picasso))

### Enhancements made

- ENH: Allow graph titles and filenames to use time at beginning of sweep [#687](https://github.com/ARM-DOE/pyart/pull/687) ([@csnardi](https://github.com/csnardi))
- ENH: vpt plot gatefilter addition. [#645](https://github.com/ARM-DOE/pyart/pull/645) ([@zssherman](https://github.com/zssherman))

### Bugs fixed

- FIX: Fixing docbuild failure in Travis. [#709](https://github.com/ARM-DOE/pyart/pull/709) ([@mhpicel](https://github.com/mhpicel))
- FIX: Should fix the CI fail for 2.7 doc build. Let us see if CI test for 2.7 passes. [#705](https://github.com/ARM-DOE/pyart/pull/705) ([@zssherman](https://github.com/zssherman))
- FIX: last part of fromstring fix [#704](https://github.com/ARM-DOE/pyart/pull/704) ([@scollis](https://github.com/scollis))
- FIX: Python 3 issue with KAZR ingest [#692](https://github.com/ARM-DOE/pyart/pull/692) ([@scollis](https://github.com/scollis))
- FIX: Coef in B-Matrix [#651](https://github.com/ARM-DOE/pyart/pull/651) ([@scollis](https://github.com/scollis))

### Maintenance and upkeep improvements

- MAINT: Added classifier for Python 3.6 and changed the maintainer email. [#711](https://github.com/ARM-DOE/pyart/pull/711) ([@zssherman](https://github.com/zssherman))
- MAINT: Move calculate_velocity_texture to pyart.retreive [#672](https://github.com/ARM-DOE/pyart/pull/672) ([@rcjackson](https://github.com/rcjackson))

### Documentation improvements

- DOC: Noticed link to wradlib was to the old bit bucket page, no longer exists. [#673](https://github.com/ARM-DOE/pyart/pull/673) ([@zssherman](https://github.com/zssherman))
- DOC: Contr guide updates [#653](https://github.com/ARM-DOE/pyart/pull/653) ([@zssherman](https://github.com/zssherman))
- DOC: Add documentation of CI setup [#638](https://github.com/ARM-DOE/pyart/pull/638) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Add document on release process [#635](https://github.com/ARM-DOE/pyart/pull/635) ([@jjhelmus](https://github.com/jjhelmus))

### Deprecated features

- DEP: Changed fromstring to frombuffer to removed depreciation. [#702](https://github.com/ARM-DOE/pyart/pull/702) ([@zssherman](https://github.com/zssherman))

### Other merged PRs

- STY: Some minor pep8 changes to grid_mapper.py [#710](https://github.com/ARM-DOE/pyart/pull/710) ([@zssherman](https://github.com/zssherman))
- Bug correction of Vulpiani KDP/PhiDP retrieval [#707](https://github.com/ARM-DOE/pyart/pull/707) ([@meteoswiss-mdr](https://github.com/meteoswiss-mdr))
- EDIT: Adding new version of dealiasing code [#706](https://github.com/ARM-DOE/pyart/pull/706) ([@rcjackson](https://github.com/rcjackson))
- changed all fromstring() to frombuffer() due to deprecation warnings in numpy  [#700](https://github.com/ARM-DOE/pyart/pull/700) ([@goharkay](https://github.com/goharkay))
- Fixing infinite loop in 4DD algorithm [#693](https://github.com/ARM-DOE/pyart/pull/693) ([@freemansw1](https://github.com/freemansw1))
- added 'Nearest' keyword to 'map_to_grid' [#683](https://github.com/ARM-DOE/pyart/pull/683) ([@swnesbitt](https://github.com/swnesbitt))
- Add transparency to plot methods and despeckle issue [#674](https://github.com/ARM-DOE/pyart/pull/674) ([@tjlang](https://github.com/tjlang))
- Fixed issue with range() [#668](https://github.com/ARM-DOE/pyart/pull/668) ([@wolfidan](https://github.com/wolfidan))
- Remove jhelmus contact info from landing page [#667](https://github.com/ARM-DOE/pyart/pull/667) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Fix for numpy 1.13 update. [#665](https://github.com/ARM-DOE/pyart/pull/665) ([@zssherman](https://github.com/zssherman))
- ADD: Velocity texture calculation into pyart.filters [#662](https://github.com/ARM-DOE/pyart/pull/662) ([@rcjackson](https://github.com/rcjackson))
- TST: Fix for the sweep_mode assert in cfradial test. [#661](https://github.com/ARM-DOE/pyart/pull/661) ([@zssherman](https://github.com/zssherman))
- AttributeError fix with python 3.6 in cfradial.py [#656](https://github.com/ARM-DOE/pyart/pull/656) ([@vlouf](https://github.com/vlouf))
- H5Py OSError: File close degree doesn't match fix [#650](https://github.com/ARM-DOE/pyart/pull/650) ([@vlouf](https://github.com/vlouf))
- OverflowError: Python int too large to convert to C long in despeckle [#648](https://github.com/ARM-DOE/pyart/pull/648) ([@vlouf](https://github.com/vlouf))
- added Raster keyword for happier vector file output [#647](https://github.com/ARM-DOE/pyart/pull/647) ([@swnesbitt](https://github.com/swnesbitt))
- TST: Do not use jjhelmus channel for Travis CI test environment [#640](https://github.com/ARM-DOE/pyart/pull/640) ([@jjhelmus](https://github.com/jjhelmus))
- Contributor guide [#639](https://github.com/ARM-DOE/pyart/pull/639) ([@zssherman](https://github.com/zssherman))
- Deprecate dealias sonde function and parameters [#634](https://github.com/ARM-DOE/pyart/pull/634) ([@jjhelmus](https://github.com/jjhelmus))
- Addition of two Kdp estimation methods [#620](https://github.com/ARM-DOE/pyart/pull/620) ([@wolfidan](https://github.com/wolfidan))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2017-02-27&to=2018-02-15&type=c))

[@csnardi](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Acsnardi+updated%3A2017-02-27..2018-02-15&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2017-02-27..2018-02-15&type=Issues) | [@freemansw1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Afreemansw1+updated%3A2017-02-27..2018-02-15&type=Issues) | [@goharkay](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agoharkay+updated%3A2017-02-27..2018-02-15&type=Issues) | [@itsjms](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aitsjms+updated%3A2017-02-27..2018-02-15&type=Issues) | [@jamessong](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajamessong+updated%3A2017-02-27..2018-02-15&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2017-02-27..2018-02-15&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2017-02-27..2018-02-15&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2017-02-27..2018-02-15&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2017-02-27..2018-02-15&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2017-02-27..2018-02-15&type=Issues) | [@mgrover1](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amgrover1+updated%3A2017-02-27..2018-02-15&type=Issues) | [@mhpicel](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amhpicel+updated%3A2017-02-27..2018-02-15&type=Issues) | [@miaoneng](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amiaoneng+updated%3A2017-02-27..2018-02-15&type=Issues) | [@rcjackson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Arcjackson+updated%3A2017-02-27..2018-02-15&type=Issues) | [@Rumpkie](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ARumpkie+updated%3A2017-02-27..2018-02-15&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2017-02-27..2018-02-15&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2017-02-27..2018-02-15&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2017-02-27..2018-02-15&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2017-02-27..2018-02-15&type=Issues) | [@wolfidan](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Awolfidan+updated%3A2017-02-27..2018-02-15&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2017-02-27..2018-02-15&type=Issues)


## PyART v1.8.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.7.0...v1.8.0))

### Enhancements made

- ENH: Added local install option for radx [#617](https://github.com/ARM-DOE/pyart/pull/617) ([@scollis](https://github.com/scollis))
- ENH: location data available in HorizontalWindProfile class [#616](https://github.com/ARM-DOE/pyart/pull/616) ([@kirknorth](https://github.com/kirknorth))

### Bugs fixed

- BUG: Add missing import to gatefilter module [#631](https://github.com/ARM-DOE/pyart/pull/631) ([@jjhelmus](https://github.com/jjhelmus))
- FIX: Bug swapping az for ele in plot_ray [#619](https://github.com/ARM-DOE/pyart/pull/619) ([@scollis](https://github.com/scollis))
- BUG: Fix the use of mask_outside and norm when plotting [#618](https://github.com/ARM-DOE/pyart/pull/618) ([@jjhelmus](https://github.com/jjhelmus))
- FIX: fix _get_angle-function [#613](https://github.com/ARM-DOE/pyart/pull/613) ([@kmuehlbauer](https://github.com/kmuehlbauer))
- BUG: Read in altitude form ARM sonde files [#607](https://github.com/ARM-DOE/pyart/pull/607) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Change use of dtype in linspace function [#603](https://github.com/ARM-DOE/pyart/pull/603) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Typo in index.html [#627](https://github.com/ARM-DOE/pyart/pull/627) ([@zssherman](https://github.com/zssherman))

### Documentation improvements

- DOC: Update INSTALL.rst file [#623](https://github.com/ARM-DOE/pyart/pull/623) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Update README.rst with new conda info [#596](https://github.com/ARM-DOE/pyart/pull/596) ([@jjhelmus](https://github.com/jjhelmus))

### Deprecated features

- DEP: Remove deprecated items [#595](https://github.com/ARM-DOE/pyart/pull/595) ([@jjhelmus](https://github.com/jjhelmus))

### Other merged PRs

- Add support for Python 3.6 [#632](https://github.com/ARM-DOE/pyart/pull/632) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Update Travis CI setup [#630](https://github.com/ARM-DOE/pyart/pull/630) ([@jjhelmus](https://github.com/jjhelmus))
- improving gamic reader [#625](https://github.com/ARM-DOE/pyart/pull/625) ([@TulipaSilva](https://github.com/TulipaSilva))
- Fix syntax error under python 2.6.x [#622](https://github.com/ARM-DOE/pyart/pull/622) ([@normbw](https://github.com/normbw))
- CI: Use -q (quite) switch on conda commands [#614](https://github.com/ARM-DOE/pyart/pull/614) ([@jjhelmus](https://github.com/jjhelmus))
- CI: Supress git commit output after building docs [#611](https://github.com/ARM-DOE/pyart/pull/611) ([@jjhelmus](https://github.com/jjhelmus))
- Added a CfRadial writer for SINARAME H5 files [#608](https://github.com/ARM-DOE/pyart/pull/608) ([@mrugna](https://github.com/mrugna))
- Updated sinarame_h5 reader [#605](https://github.com/ARM-DOE/pyart/pull/605) ([@mrugna](https://github.com/mrugna))
- BLD: Add kludge to setup.py script for Python 3.4 [#604](https://github.com/ARM-DOE/pyart/pull/604) ([@jjhelmus](https://github.com/jjhelmus))
- ADD: Add DoE acknowledgement to __init__.py [#602](https://github.com/ARM-DOE/pyart/pull/602) ([@scollis](https://github.com/scollis))
- hydrometeor classification and QPE [#598](https://github.com/ARM-DOE/pyart/pull/598) ([@meteoswiss-mdr](https://github.com/meteoswiss-mdr))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2016-09-16&to=2017-02-27&type=c))

[@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2016-09-16..2017-02-27&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2016-09-16..2017-02-27&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2016-09-16..2017-02-27&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2016-09-16..2017-02-27&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2016-09-16..2017-02-27&type=Issues) | [@mrugna](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amrugna+updated%3A2016-09-16..2017-02-27&type=Issues) | [@mustafaalicelik](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amustafaalicelik+updated%3A2016-09-16..2017-02-27&type=Issues) | [@normbw](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anormbw+updated%3A2016-09-16..2017-02-27&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2016-09-16..2017-02-27&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2016-09-16..2017-02-27&type=Issues) | [@TulipaSilva](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ATulipaSilva+updated%3A2016-09-16..2017-02-27&type=Issues) | [@vlouf](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Avlouf+updated%3A2016-09-16..2017-02-27&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2016-09-16..2017-02-27&type=Issues)


## PyART v1.7.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.6.0...v1.7.0))

### Enhancements made

- ENH: Filter based on antenna transitions [#580](https://github.com/ARM-DOE/pyart/pull/580) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: simulated wind and profile changes to dealias functions [#577](https://github.com/ARM-DOE/pyart/pull/577) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Simulated radial velocities from a profile [#576](https://github.com/ARM-DOE/pyart/pull/576) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Reading and storing horizontal wind profiles [#575](https://github.com/ARM-DOE/pyart/pull/575) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Optimized reading of NEXRAD level 2 files [#562](https://github.com/ARM-DOE/pyart/pull/562) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for reading ODIM H5 AZIM files [#546](https://github.com/ARM-DOE/pyart/pull/546) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Radar and Grid classes can be pickled and unpickled [#543](https://github.com/ARM-DOE/pyart/pull/543) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: NEXRAD VCP included in radar metadata [#541](https://github.com/ARM-DOE/pyart/pull/541) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Read NEXRAD Level 3 with NOAAPORT seperator [#540](https://github.com/ARM-DOE/pyart/pull/540) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for reading bzip2 compressed MDV files [#521](https://github.com/ARM-DOE/pyart/pull/521) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: variational KDP retrievals [#459](https://github.com/ARM-DOE/pyart/pull/459) ([@kirknorth](https://github.com/kirknorth))

### Bugs fixed

- BUG: pyart.io.read can read RSL only files [#590](https://github.com/ARM-DOE/pyart/pull/590) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: bugfix for reading NEXRAD L3 product 135 (EET) [#585](https://github.com/ARM-DOE/pyart/pull/585) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Decode strings from GAMIC files [#582](https://github.com/ARM-DOE/pyart/pull/582) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Raise an error for too much sounding data [#574](https://github.com/ARM-DOE/pyart/pull/574) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Reading NetCDF files with masked data [#570](https://github.com/ARM-DOE/pyart/pull/570) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Prevent nan being returned from transform [#558](https://github.com/ARM-DOE/pyart/pull/558) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Read NEXRAD L2 files with CTM information [#553](https://github.com/ARM-DOE/pyart/pull/553) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Writing grids with empty radar names [#542](https://github.com/ARM-DOE/pyart/pull/542) ([@jjhelmus](https://github.com/jjhelmus))
- FIX: several fixes for pyart.aux_io.read_gamic() [#535](https://github.com/ARM-DOE/pyart/pull/535) ([@kmuehlbauer](https://github.com/kmuehlbauer))
- BUG: Fix issue with UF files representing midnight as 24:00:00 [#523](https://github.com/ARM-DOE/pyart/pull/523) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: ImportError on warn --> warnings.warn [#522](https://github.com/ARM-DOE/pyart/pull/522) ([@kirknorth](https://github.com/kirknorth))
- BUG: Correct use of min_radius in ROI calculation [#519](https://github.com/ARM-DOE/pyart/pull/519) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fix NetCDF4 1.2.3+ masked constant issue [#512](https://github.com/ARM-DOE/pyart/pull/512) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Set _FillValue in dealias routines [#510](https://github.com/ARM-DOE/pyart/pull/510) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fix division in phase_proc module [#502](https://github.com/ARM-DOE/pyart/pull/502) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: ZeroDivision errors when reading certain UF files [#494](https://github.com/ARM-DOE/pyart/pull/494) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Docs can be build in Sphinx 1.3 [#485](https://github.com/ARM-DOE/pyart/pull/485) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Better error message of unsupported MDV proj [#481](https://github.com/ARM-DOE/pyart/pull/481) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Minor cleanup [#579](https://github.com/ARM-DOE/pyart/pull/579) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Various minor changes [#578](https://github.com/ARM-DOE/pyart/pull/578) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Prefer importing pyproj over basemap [#568](https://github.com/ARM-DOE/pyart/pull/568) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Change default gridding algorithm [#563](https://github.com/ARM-DOE/pyart/pull/563) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Raise error when cyl projections used [#559](https://github.com/ARM-DOE/pyart/pull/559) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Two minor fixes [#549](https://github.com/ARM-DOE/pyart/pull/549) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Clean up join_radar function [#547](https://github.com/ARM-DOE/pyart/pull/547) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Python 3 fixes in gamicfile and gamic_hdf5 [#536](https://github.com/ARM-DOE/pyart/pull/536) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: ODIM_H5 improvements [#524](https://github.com/ARM-DOE/pyart/pull/524) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Ignore division zero warning in transform [#513](https://github.com/ARM-DOE/pyart/pull/513) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Remove BallTree class [#504](https://github.com/ARM-DOE/pyart/pull/504) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Python 3 fix for cvxopt phase proc [#501](https://github.com/ARM-DOE/pyart/pull/501) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Remove Python 2.6, 3.3 and add 3.5 to tags [#482](https://github.com/ARM-DOE/pyart/pull/482) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Remove support for Python 2.6 and 3.3, add Python 3.5 [#479](https://github.com/ARM-DOE/pyart/pull/479) ([@jjhelmus](https://github.com/jjhelmus))

### Documentation improvements

- DOC: Minor doc fixes [#594](https://github.com/ARM-DOE/pyart/pull/594) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Fix equation in antenna_to_cartesian func [#567](https://github.com/ARM-DOE/pyart/pull/567) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Add information about citing Py-ART in publications [#561](https://github.com/ARM-DOE/pyart/pull/561) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Fix docstring for despeckle_field function [#544](https://github.com/ARM-DOE/pyart/pull/544) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Typo, axislabel_flag -> axislabels_flag [#539](https://github.com/ARM-DOE/pyart/pull/539) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Add link to example data to docs [#529](https://github.com/ARM-DOE/pyart/pull/529) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: fixed docstring for _get_x_z [#491](https://github.com/ARM-DOE/pyart/pull/491) ([@Rumpkie](https://github.com/Rumpkie))
- DOC: Building of examples opt-in [#486](https://github.com/ARM-DOE/pyart/pull/486) ([@jjhelmus](https://github.com/jjhelmus))

### Other merged PRs

- TST: Fix Travis CI Python 2.7 [#586](https://github.com/ARM-DOE/pyart/pull/586) ([@jjhelmus](https://github.com/jjhelmus))
- Computation of secondary moments, noise correction of RhoHV and pseudo-PPI from RHI volume [#583](https://github.com/ARM-DOE/pyart/pull/583) ([@jfigui](https://github.com/jfigui))
- New gate filter based on texture of polarimetric variables [#572](https://github.com/ARM-DOE/pyart/pull/572) ([@jfigui](https://github.com/jfigui))
- Fixup Pull Request #565 [#569](https://github.com/ARM-DOE/pyart/pull/569) ([@jjhelmus](https://github.com/jjhelmus))
- Advection calculation and shifting of grids [#565](https://github.com/ARM-DOE/pyart/pull/565) ([@scollis](https://github.com/scollis))
- ADD: Updated index.html with citation [#560](https://github.com/ARM-DOE/pyart/pull/560) ([@scollis](https://github.com/scollis))
- Added rainbow_wrl.py. Function to read rainbow5 files [#555](https://github.com/ARM-DOE/pyart/pull/555) ([@jfigui](https://github.com/jfigui))
- CI: Pin conda version when installing from recipe [#554](https://github.com/ARM-DOE/pyart/pull/554) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Evaluation NOSE_ARGS on Travis CI [#548](https://github.com/ARM-DOE/pyart/pull/548) ([@jjhelmus](https://github.com/jjhelmus))
- Finding objects in scans and despeckling [#538](https://github.com/ARM-DOE/pyart/pull/538) ([@tjlang](https://github.com/tjlang))
- Sweep mode fix for UF files [#532](https://github.com/ARM-DOE/pyart/pull/532) ([@jjhelmus](https://github.com/jjhelmus))
- Various fixed for read ODIM H5 files [#531](https://github.com/ARM-DOE/pyart/pull/531) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Test only non-locale dependent time string [#528](https://github.com/ARM-DOE/pyart/pull/528) ([@jjhelmus](https://github.com/jjhelmus))
- Add unit tests for the output_to_geotiff module [#514](https://github.com/ARM-DOE/pyart/pull/514) ([@jjhelmus](https://github.com/jjhelmus))
- GeoTIFF output [#511](https://github.com/ARM-DOE/pyart/pull/511) ([@tjlang](https://github.com/tjlang))
- Testing to see if Pull Request Trigger CI [#507](https://github.com/ARM-DOE/pyart/pull/507) ([@jjhelmus](https://github.com/jjhelmus))
- Python 3 support for building the documentation [#506](https://github.com/ARM-DOE/pyart/pull/506) ([@jjhelmus](https://github.com/jjhelmus))
- 	modified:   pyart/graph/radarmapdisplay.py [#498](https://github.com/ARM-DOE/pyart/pull/498) ([@swnesbitt](https://github.com/swnesbitt))
- TST: Use system libgfortran on Travis CI [#497](https://github.com/ARM-DOE/pyart/pull/497) ([@jjhelmus](https://github.com/jjhelmus))
- RHI contour example 2 [#495](https://github.com/ARM-DOE/pyart/pull/495) ([@Rumpkie](https://github.com/Rumpkie))
- TST: Travis CI working with wradlib 0.7.0 [#493](https://github.com/ARM-DOE/pyart/pull/493) ([@jjhelmus](https://github.com/jjhelmus))
- Example: creates rhi data from one field and contours from another [#489](https://github.com/ARM-DOE/pyart/pull/489) ([@Rumpkie](https://github.com/Rumpkie))
- Example: simple plot, grid data with contours [#488](https://github.com/ARM-DOE/pyart/pull/488) ([@Rumpkie](https://github.com/Rumpkie))
- read Argentinean h5 files [#480](https://github.com/ARM-DOE/pyart/pull/480) ([@swnesbitt](https://github.com/swnesbitt))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2016-02-05&to=2016-09-16&type=c))

[@bdolan44](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Abdolan44+updated%3A2016-02-05..2016-09-16&type=Issues) | [@dara74k](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adara74k+updated%3A2016-02-05..2016-09-16&type=Issues) | [@dcedgren](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adcedgren+updated%3A2016-02-05..2016-09-16&type=Issues) | [@dopplershift](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adopplershift+updated%3A2016-02-05..2016-09-16&type=Issues) | [@gavi](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agavi+updated%3A2016-02-05..2016-09-16&type=Issues) | [@hhuangwx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ahhuangwx+updated%3A2016-02-05..2016-09-16&type=Issues) | [@jacaicedob](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajacaicedob+updated%3A2016-02-05..2016-09-16&type=Issues) | [@jfigui](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajfigui+updated%3A2016-02-05..2016-09-16&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2016-02-05..2016-09-16&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2016-02-05..2016-09-16&type=Issues) | [@joshua-wx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajoshua-wx+updated%3A2016-02-05..2016-09-16&type=Issues) | [@jsignell](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajsignell+updated%3A2016-02-05..2016-09-16&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2016-02-05..2016-09-16&type=Issues) | [@kmuehlbauer](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akmuehlbauer+updated%3A2016-02-05..2016-09-16&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2016-02-05..2016-09-16&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2016-02-05..2016-09-16&type=Issues) | [@pfhein](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Apfhein+updated%3A2016-02-05..2016-09-16&type=Issues) | [@Rumpkie](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ARumpkie+updated%3A2016-02-05..2016-09-16&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2016-02-05..2016-09-16&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2016-02-05..2016-09-16&type=Issues) | [@tamisalex](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atamisalex+updated%3A2016-02-05..2016-09-16&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2016-02-05..2016-09-16&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2016-02-05..2016-09-16&type=Issues)


## PyART v1.6.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.5.0...v1.6.0))

### Enhancements made

- ENH: Plotting methods pass additional arguments to pcolormesh [#469](https://github.com/ARM-DOE/pyart/pull/469) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Add norm parameter to plotting methods [#468](https://github.com/ARM-DOE/pyart/pull/468) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Dealiasing routines set valid limits [#467](https://github.com/ARM-DOE/pyart/pull/467) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Default field specific colormaps and luminosity when plotting [#464](https://github.com/ARM-DOE/pyart/pull/464) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for reading message 1 NEXRAD Level 2 files [#455](https://github.com/ARM-DOE/pyart/pull/455) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for Sigmet HCLASS data [#447](https://github.com/ARM-DOE/pyart/pull/447) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Aliases to rename and moved transform function [#439](https://github.com/ARM-DOE/pyart/pull/439) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: New Layout from Grid [#434](https://github.com/ARM-DOE/pyart/pull/434) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Improvements to the Radar Class [#433](https://github.com/ARM-DOE/pyart/pull/433) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Additional field limits and colormap mappings [#427](https://github.com/ARM-DOE/pyart/pull/427) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: More informative error messages when optional dependency is missing [#411](https://github.com/ARM-DOE/pyart/pull/411) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: replace_existing in Grid [#409](https://github.com/ARM-DOE/pyart/pull/409) ([@kirknorth](https://github.com/kirknorth))
- ENH: Hildebrand-Sekhon estimation of noise levels [#404](https://github.com/ARM-DOE/pyart/pull/404) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: write UF files [#388](https://github.com/ARM-DOE/pyart/pull/388) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Add pyart.util.cross_section_ppi function [#380](https://github.com/ARM-DOE/pyart/pull/380) ([@jjhelmus](https://github.com/jjhelmus))

### Bugs fixed

- BUG: instrument parameter skipped if dim not known [#477](https://github.com/ARM-DOE/pyart/pull/477) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fix projection issue when creating large grids [#472](https://github.com/ARM-DOE/pyart/pull/472) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Do not set valid_min/max if all data masked [#471](https://github.com/ARM-DOE/pyart/pull/471) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: RadarMapDisplay.plot_range_rings [#470](https://github.com/ARM-DOE/pyart/pull/470) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Sigmet multi PRF flag outside of specified range [#460](https://github.com/ARM-DOE/pyart/pull/460) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: get_field_colormap return string. [#446](https://github.com/ARM-DOE/pyart/pull/446) ([@gamaanderson](https://github.com/gamaanderson))
- BUG: Masked values not included in Barnes weights [#444](https://github.com/ARM-DOE/pyart/pull/444) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Make example_cfradial_rhi.nc file for source [#441](https://github.com/ARM-DOE/pyart/pull/441) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Check for h5py in read_gamic corrected [#425](https://github.com/ARM-DOE/pyart/pull/425) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Example CfRadial files have correct sweep end [#417](https://github.com/ARM-DOE/pyart/pull/417) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: struct.pack requires native string on Python < 2.7.7 [#410](https://github.com/ARM-DOE/pyart/pull/410) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fixes for UF file reading and writing [#400](https://github.com/ARM-DOE/pyart/pull/400) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Return 'S' arrays when reading files [#383](https://github.com/ARM-DOE/pyart/pull/383) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fix writing of radar classes which contain unicode arrays [#382](https://github.com/ARM-DOE/pyart/pull/382) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Missing gatefiter parameter in plot_sweep_grid [#374](https://github.com/ARM-DOE/pyart/pull/374) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: 1-byte width field from Sigmet files returns in m/s [#372](https://github.com/ARM-DOE/pyart/pull/372) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Fix typo (depreciate -> deprecate) [#465](https://github.com/ARM-DOE/pyart/pull/465) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Refactor of Display classes [#463](https://github.com/ARM-DOE/pyart/pull/463) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Replace requires decorator with if/raise block [#416](https://github.com/ARM-DOE/pyart/pull/416) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Python 3 support in phase_proc module [#392](https://github.com/ARM-DOE/pyart/pull/392) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Raise exception when RadxCovert does not create a file [#385](https://github.com/ARM-DOE/pyart/pull/385) ([@jjhelmus](https://github.com/jjhelmus))

### Documentation improvements

- DOC: Clean and clarify docs in grid_io module [#475](https://github.com/ARM-DOE/pyart/pull/475) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Added text mentioning h5py to README.rst [#406](https://github.com/ARM-DOE/pyart/pull/406) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Note that add_field_like does not copy data [#397](https://github.com/ARM-DOE/pyart/pull/397) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Updates to the documentation and README [#391](https://github.com/ARM-DOE/pyart/pull/391) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Pin sphinx version in Travis [#376](https://github.com/ARM-DOE/pyart/pull/376) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Updated README.rst file [#370](https://github.com/ARM-DOE/pyart/pull/370) ([@jjhelmus](https://github.com/jjhelmus))

### Deprecated features

- DEP: Deprecate corner_to_point [#473](https://github.com/ARM-DOE/pyart/pull/473) ([@jjhelmus](https://github.com/jjhelmus))

### Other merged PRs

- API: Add transform function to pyart.core [#466](https://github.com/ARM-DOE/pyart/pull/466) ([@jjhelmus](https://github.com/jjhelmus))
- Add radar_utils [#456](https://github.com/ARM-DOE/pyart/pull/456) ([@nguy](https://github.com/nguy))
- Updates to resolve outstanding issues #412 and #413 [#454](https://github.com/ARM-DOE/pyart/pull/454) ([@Rumpkie](https://github.com/Rumpkie))
- Time-height displays. [#453](https://github.com/ARM-DOE/pyart/pull/453) ([@nguy](https://github.com/nguy))
- Airborne Display class name change [#449](https://github.com/ARM-DOE/pyart/pull/449) ([@nguy](https://github.com/nguy))
- TST: Fix skipped basemap tests on Travis CI [#438](https://github.com/ARM-DOE/pyart/pull/438) ([@jjhelmus](https://github.com/jjhelmus))
- Added basemap keyword to RadarMapDisplay.plot_ppi_map [#437](https://github.com/ARM-DOE/pyart/pull/437) ([@tjlang](https://github.com/tjlang))
- Circular means in Sigmet pointing angles [#430](https://github.com/ARM-DOE/pyart/pull/430) ([@jjhelmus](https://github.com/jjhelmus))
- Update join_radar function. [#426](https://github.com/ARM-DOE/pyart/pull/426) ([@nguy](https://github.com/nguy))
- Update AppVeyor to use pre-installed Miniconda and reactivate Python 3.4 CI [#422](https://github.com/ARM-DOE/pyart/pull/422) ([@jjhelmus](https://github.com/jjhelmus))
- EXAMPLE: Gatefilter in plot_map_one_radar_to_grid [#420](https://github.com/ARM-DOE/pyart/pull/420) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Fix AppVeyor CI by adding Library/bin to PATH [#419](https://github.com/ARM-DOE/pyart/pull/419) ([@jjhelmus](https://github.com/jjhelmus))
- Typo in README.rst [#408](https://github.com/ARM-DOE/pyart/pull/408) ([@jjhelmus](https://github.com/jjhelmus))
- Add plot azimuthal cross-section to radardisplay class. [#405](https://github.com/ARM-DOE/pyart/pull/405) ([@nguy](https://github.com/nguy))
- Made reader more resillient to missing sweep_number parameter [#403](https://github.com/ARM-DOE/pyart/pull/403) ([@josephhardinee](https://github.com/josephhardinee))
- add mdv_field_names to write_mdv_grid [#402](https://github.com/ARM-DOE/pyart/pull/402) ([@gamaanderson](https://github.com/gamaanderson))
- Unwrap velocities gates outside of the Nyquist range with dealias_region_based [#401](https://github.com/ARM-DOE/pyart/pull/401) ([@jjhelmus](https://github.com/jjhelmus))
- Update chl.py documentation [#399](https://github.com/ARM-DOE/pyart/pull/399) ([@josephhardinee](https://github.com/josephhardinee))
- Read Sigmet Dual PRF information when available [#395](https://github.com/ARM-DOE/pyart/pull/395) ([@jjhelmus](https://github.com/jjhelmus))
- Update documenation of pyart.io.add_2d_latlon_axis [#394](https://github.com/ARM-DOE/pyart/pull/394) ([@jjhelmus](https://github.com/jjhelmus))
- ENH better example image [#378](https://github.com/ARM-DOE/pyart/pull/378) ([@scollis](https://github.com/scollis))
- Gatefilter direct acess [#377](https://github.com/ARM-DOE/pyart/pull/377) ([@gamaanderson](https://github.com/gamaanderson))
- TST: Additional code coverage in unit tests [#373](https://github.com/ARM-DOE/pyart/pull/373) ([@jjhelmus](https://github.com/jjhelmus))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2015-09-01&to=2016-02-05&type=c))

[@deeplycloudy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adeeplycloudy+updated%3A2015-09-01..2016-02-05&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2015-09-01..2016-02-05&type=Issues) | [@hhuangwx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ahhuangwx+updated%3A2015-09-01..2016-02-05&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2015-09-01..2016-02-05&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2015-09-01..2016-02-05&type=Issues) | [@joshua-wx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajoshua-wx+updated%3A2015-09-01..2016-02-05&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2015-09-01..2016-02-05&type=Issues) | [@mvanlierwalq](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Amvanlierwalq+updated%3A2015-09-01..2016-02-05&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2015-09-01..2016-02-05&type=Issues) | [@pfhein](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Apfhein+updated%3A2015-09-01..2016-02-05&type=Issues) | [@Rumpkie](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ARumpkie+updated%3A2015-09-01..2016-02-05&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2015-09-01..2016-02-05&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2015-09-01..2016-02-05&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2015-09-01..2016-02-05&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2015-09-01..2016-02-05&type=Issues)


## PyART v1.5.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.4.0...v1.5.0))

### Enhancements made

- ENH: Transparent decompression when reading files [#368](https://github.com/ARM-DOE/pyart/pull/368) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Mapping routines accept GateFilter instances to specify gates to include in interpolation [#360](https://github.com/ARM-DOE/pyart/pull/360) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for reading Universal Format (UF) files [#358](https://github.com/ARM-DOE/pyart/pull/358) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: edge_netcdf module and read_edge_netcdf function [#357](https://github.com/ARM-DOE/pyart/pull/357) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: GateFilter based filter in dealias_fourdd [#348](https://github.com/ARM-DOE/pyart/pull/348) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: add label, title etc. to gridmapdisplay [#346](https://github.com/ARM-DOE/pyart/pull/346) ([@gamaanderson](https://github.com/gamaanderson))
- ENH: Default limits and colormap [#336](https://github.com/ARM-DOE/pyart/pull/336) ([@gamaanderson](https://github.com/gamaanderson))
- ENH: grid creation function accept a single Radar object. [#330](https://github.com/ARM-DOE/pyart/pull/330) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Statistics on circular distributions [#326](https://github.com/ARM-DOE/pyart/pull/326) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: GateFilter available for 4DD [#308](https://github.com/ARM-DOE/pyart/pull/308) ([@kirknorth](https://github.com/kirknorth))

### Bugs fixed

- BUG: Fixes for Windows bug [#361](https://github.com/ARM-DOE/pyart/pull/361) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: refl_filter_flag=False not working in map_gate_to_grid [#334](https://github.com/ARM-DOE/pyart/pull/334) ([@gamaanderson](https://github.com/gamaanderson))
- BUG: Various fixes for bugs in the region_dealias module [#327](https://github.com/ARM-DOE/pyart/pull/327) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Make libm link only on POSIX systems [#319](https://github.com/ARM-DOE/pyart/pull/319) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Remove unnecessary InMemoryFile alias [#365](https://github.com/ARM-DOE/pyart/pull/365) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Move GateFilter related code to filters sub-package [#359](https://github.com/ARM-DOE/pyart/pull/359) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Change default value of mask_outside to False [#354](https://github.com/ARM-DOE/pyart/pull/354) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: _rsl_interface.pyx can be compiled with Cython 0.22 [#342](https://github.com/ARM-DOE/pyart/pull/342) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Have Travis-CI use latest version of TRMM RSL on binstar.org [#337](https://github.com/ARM-DOE/pyart/pull/337) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Refactor gamic_hdf5 module [#320](https://github.com/ARM-DOE/pyart/pull/320) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Depreciate file based Display classes [#317](https://github.com/ARM-DOE/pyart/pull/317) ([@jjhelmus](https://github.com/jjhelmus))

### Documentation improvements

- DOC: Add AppVeyor badge to README.rst [#362](https://github.com/ARM-DOE/pyart/pull/362) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Update plot_grid_three_panel.py example to use new GridMapDisplay class [#353](https://github.com/ARM-DOE/pyart/pull/353) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Fix docstring to remove confusion in gridmapdisplay.py [#331](https://github.com/ARM-DOE/pyart/pull/331) ([@scollis](https://github.com/scollis))

### Other merged PRs

- Add GateFilter to RadarDisplay [#363](https://github.com/ARM-DOE/pyart/pull/363) ([@nguy](https://github.com/nguy))
- TST: Use most up-to-date version of h5py and HDF5 on Travis CI [#340](https://github.com/ARM-DOE/pyart/pull/340) ([@jjhelmus](https://github.com/jjhelmus))
- externalise methods from display [#339](https://github.com/ARM-DOE/pyart/pull/339) ([@gamaanderson](https://github.com/gamaanderson))
- Added NOXP reader for IPHEx [#333](https://github.com/ARM-DOE/pyart/pull/333) ([@tjlang](https://github.com/tjlang))
- Handle SQI in Sigmet reader [#332](https://github.com/ARM-DOE/pyart/pull/332) ([@deeplycloudy](https://github.com/deeplycloudy))
- TST: Use TRMM RSL version 1.47 build 0 on binstar on Travis CI [#324](https://github.com/ARM-DOE/pyart/pull/324) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Fix failing documentation build on Travis CI [#323](https://github.com/ARM-DOE/pyart/pull/323) ([@jjhelmus](https://github.com/jjhelmus))
- Read KAZR ingest [#271](https://github.com/ARM-DOE/pyart/pull/271) ([@kirknorth](https://github.com/kirknorth))
- Binarize [#266](https://github.com/ARM-DOE/pyart/pull/266) ([@gamaanderson](https://github.com/gamaanderson))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2015-06-09&to=2015-09-01&type=c))

[@coveralls](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Acoveralls+updated%3A2015-06-09..2015-09-01&type=Issues) | [@deeplycloudy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adeeplycloudy+updated%3A2015-06-09..2015-09-01&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2015-06-09..2015-09-01&type=Issues) | [@hhuangwx](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ahhuangwx+updated%3A2015-06-09..2015-09-01&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2015-06-09..2015-09-01&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2015-06-09..2015-09-01&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2015-06-09..2015-09-01&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2015-06-09..2015-09-01&type=Issues) | [@Rumpkie](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3ARumpkie+updated%3A2015-06-09..2015-09-01&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2015-06-09..2015-09-01&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2015-06-09..2015-09-01&type=Issues) | [@zssherman](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Azssherman+updated%3A2015-06-09..2015-09-01&type=Issues)


## PyART v1.4.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.3.0...v1.4.0))

### Enhancements made

- ENH: Run length encoding support when reading MDV files [#313](https://github.com/ARM-DOE/pyart/pull/313) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Read NEXRAD level 3 files from file like object [#312](https://github.com/ARM-DOE/pyart/pull/312) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: map_gates_to_grid function [#290](https://github.com/ARM-DOE/pyart/pull/290) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Delayed loading of field data from radar files. [#286](https://github.com/ARM-DOE/pyart/pull/286) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: inclusive kwarg to filters [#280](https://github.com/ARM-DOE/pyart/pull/280) ([@kirknorth](https://github.com/kirknorth))
- ENH: Addition optimization of the region based dealiasing algorithm [#273](https://github.com/ARM-DOE/pyart/pull/273) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Faster region based dealiasing [#272](https://github.com/ARM-DOE/pyart/pull/272) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Support for reading NEXRAD level 3 products. [#261](https://github.com/ARM-DOE/pyart/pull/261) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Added check for uniform range bin locations [#256](https://github.com/ARM-DOE/pyart/pull/256) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Added skip_checks parameter to dealias_phase_unwrap function. [#255](https://github.com/ARM-DOE/pyart/pull/255) ([@jjhelmus](https://github.com/jjhelmus))
- ENH: Enable option of not plotting features on basemap for radarmapdispl... [#249](https://github.com/ARM-DOE/pyart/pull/249) ([@scollis](https://github.com/scollis))

### Bugs fixed

- BUG: Issue with sigmet module when detecting discontinity [#315](https://github.com/ARM-DOE/pyart/pull/315) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Misc fixes for reading Sigmet files [#314](https://github.com/ARM-DOE/pyart/pull/314) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Better handling of scalar NetCDF variables across netCDF versions [#303](https://github.com/ARM-DOE/pyart/pull/303) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: ODIM H5 without a how Group can be read. [#288](https://github.com/ARM-DOE/pyart/pull/288) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Fixed bug which causes segmentation fault in dealias_region_based. [#276](https://github.com/ARM-DOE/pyart/pull/276) ([@jjhelmus](https://github.com/jjhelmus))
- BUG: Support for dealiasing vpt scans with dealias_unwrap_phase. [#275](https://github.com/ARM-DOE/pyart/pull/275) ([@jjhelmus](https://github.com/jjhelmus))
- FIX: Partial reading of corrupt sigmet files. [#269](https://github.com/ARM-DOE/pyart/pull/269) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Deprecate file specific displays [#307](https://github.com/ARM-DOE/pyart/pull/307) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Clean up of mdv modules. [#295](https://github.com/ARM-DOE/pyart/pull/295) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: various dealias related enhancement and fixes [#283](https://github.com/ARM-DOE/pyart/pull/283) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Fixed inconsistency in grid shape ordering [#274](https://github.com/ARM-DOE/pyart/pull/274) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Changes required to get Py-ART to work with netcdf4-python version 1.1.6 [#254](https://github.com/ARM-DOE/pyart/pull/254) ([@jjhelmus](https://github.com/jjhelmus))
- MAINT: Added fallback ppi scan type for CfRadial files [#245](https://github.com/ARM-DOE/pyart/pull/245) ([@jjhelmus](https://github.com/jjhelmus))

### Documentation improvements

- DOC: Update README.rst [#316](https://github.com/ARM-DOE/pyart/pull/316) ([@jjhelmus](https://github.com/jjhelmus))
- DOC: Documented lazy loading in ngates_vart CfRadial files [#301](https://github.com/ARM-DOE/pyart/pull/301) ([@jjhelmus](https://github.com/jjhelmus))

### Other merged PRs

- Support for Python 3 [#310](https://github.com/ARM-DOE/pyart/pull/310) ([@jjhelmus](https://github.com/jjhelmus))
- PY3: Python 3 support in nexrad_level2 and nexrad_level3 [#309](https://github.com/ARM-DOE/pyart/pull/309) ([@jjhelmus](https://github.com/jjhelmus))
- TST: Container-based Travis CI setup [#306](https://github.com/ARM-DOE/pyart/pull/306) ([@jjhelmus](https://github.com/jjhelmus))
- Fixed issue reading sigmet 1byte datatype files. Added test. [#305](https://github.com/ARM-DOE/pyart/pull/305) ([@WeatherGod](https://github.com/WeatherGod))
- Revert "Write grid mdv" [#296](https://github.com/ARM-DOE/pyart/pull/296) ([@jjhelmus](https://github.com/jjhelmus))
- Code cleanup of mdv.py module [#293](https://github.com/ARM-DOE/pyart/pull/293) ([@jjhelmus](https://github.com/jjhelmus))
- Write grid mdv [#292](https://github.com/ARM-DOE/pyart/pull/292) ([@gamaanderson](https://github.com/gamaanderson))
- Clean up of PR #289 and minor documentation maintainance [#291](https://github.com/ARM-DOE/pyart/pull/291) ([@jjhelmus](https://github.com/jjhelmus))
- Initial version of CSU D3R radar reader [#289](https://github.com/ARM-DOE/pyart/pull/289) ([@swnesbitt](https://github.com/swnesbitt))
- solve issue #138 [#284](https://github.com/ARM-DOE/pyart/pull/284) ([@gamaanderson](https://github.com/gamaanderson))
- Write mdv [#277](https://github.com/ARM-DOE/pyart/pull/277) ([@gamaanderson](https://github.com/gamaanderson))
- alteration in grid_io  [#267](https://github.com/ARM-DOE/pyart/pull/267) ([@gamaanderson](https://github.com/gamaanderson))
- Latlon for points in grid [#264](https://github.com/ARM-DOE/pyart/pull/264) ([@gamaanderson](https://github.com/gamaanderson))
- TST: Added wradlib to CI install [#262](https://github.com/ARM-DOE/pyart/pull/262) ([@jjhelmus](https://github.com/jjhelmus))
- ADD: Backing out SNR from reflectivity [#260](https://github.com/ARM-DOE/pyart/pull/260) ([@scollis](https://github.com/scollis))
- Wradlib texture [#259](https://github.com/ARM-DOE/pyart/pull/259) ([@scollis](https://github.com/scollis))
- Profile [#258](https://github.com/ARM-DOE/pyart/pull/258) ([@scollis](https://github.com/scollis))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2015-02-19&to=2015-06-09&type=c))

[@coveralls](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Acoveralls+updated%3A2015-02-19..2015-06-09&type=Issues) | [@deeplycloudy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Adeeplycloudy+updated%3A2015-02-19..2015-06-09&type=Issues) | [@gamaanderson](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Agamaanderson+updated%3A2015-02-19..2015-06-09&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2015-02-19..2015-06-09&type=Issues) | [@josephhardinee](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajosephhardinee+updated%3A2015-02-19..2015-06-09&type=Issues) | [@kirknorth](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Akirknorth+updated%3A2015-02-19..2015-06-09&type=Issues) | [@meteoswiss-mdr](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ameteoswiss-mdr+updated%3A2015-02-19..2015-06-09&type=Issues) | [@nguy](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Anguy+updated%3A2015-02-19..2015-06-09&type=Issues) | [@scollis](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ascollis+updated%3A2015-02-19..2015-06-09&type=Issues) | [@swnesbitt](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Aswnesbitt+updated%3A2015-02-19..2015-06-09&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2015-02-19..2015-06-09&type=Issues) | [@WeatherGod](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3AWeatherGod+updated%3A2015-02-19..2015-06-09&type=Issues)


## PyART v1.3.0

([full changelog](https://github.com/ARM-DOE/pyart/compare/v1.2.0...v1.3.0))

### Enhancements made

- ENH: Various fixes and improvements when reading Sigmet files [#241](https://github.com/ARM-DOE/pyart/pull/241) ([@jjhelmus](https://github.com/jjhelmus))

### Maintenance and upkeep improvements

- MAINT: Force rebuild of documentation [#237](https://github.com/ARM-DOE/pyart/pull/237) ([@jjhelmus](https://github.com/jjhelmus))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ARM-DOE/pyart/graphs/contributors?from=2015-02-03&to=2015-02-19&type=c))

[@coveralls](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Acoveralls+updated%3A2015-02-03..2015-02-19&type=Issues) | [@jjhelmus](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Ajjhelmus+updated%3A2015-02-03..2015-02-19&type=Issues) | [@tjlang](https://github.com/search?q=repo%3AARM-DOE%2Fpyart+involves%3Atjlang+updated%3A2015-02-03..2015-02-19&type=Issues)
