import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Events::EventBus`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html
 * @external
 */
export interface CfnEventBusProps {
    /**
     * `AWS::Events::EventBus.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Events::EventBus.EventSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     * @external
     */
    readonly eventSourceName?: string;
}
/**
 * A CloudFormation `AWS::Events::EventBus`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html
 * @external
 * @cloudformationResource AWS::Events::EventBus
 */
export declare class CfnEventBus extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Events::EventBus";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventBus;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute Policy
     */
    readonly attrPolicy: string;
    /**
     * `AWS::Events::EventBus.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     * @external
     */
    name: string;
    /**
     * `AWS::Events::EventBus.EventSourceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     * @external
     */
    eventSourceName: string | undefined;
    /**
     * Create a new `AWS::Events::EventBus`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventBusProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Events::EventBusPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html
 * @external
 */
export interface CfnEventBusPolicyProps {
    /**
     * `AWS::Events::EventBusPolicy.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-action
     * @external
     */
    readonly action: string;
    /**
     * `AWS::Events::EventBusPolicy.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-principal
     * @external
     */
    readonly principal: string;
    /**
     * `AWS::Events::EventBusPolicy.StatementId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-statementid
     * @external
     */
    readonly statementId: string;
    /**
     * `AWS::Events::EventBusPolicy.Condition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-condition
     * @external
     */
    readonly condition?: CfnEventBusPolicy.ConditionProperty | cdk.IResolvable;
    /**
     * `AWS::Events::EventBusPolicy.EventBusName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-eventbusname
     * @external
     */
    readonly eventBusName?: string;
}
/**
 * A CloudFormation `AWS::Events::EventBusPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html
 * @external
 * @cloudformationResource AWS::Events::EventBusPolicy
 */
export declare class CfnEventBusPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Events::EventBusPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventBusPolicy;
    /**
     * `AWS::Events::EventBusPolicy.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-action
     * @external
     */
    action: string;
    /**
     * `AWS::Events::EventBusPolicy.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-principal
     * @external
     */
    principal: string;
    /**
     * `AWS::Events::EventBusPolicy.StatementId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-statementid
     * @external
     */
    statementId: string;
    /**
     * `AWS::Events::EventBusPolicy.Condition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-condition
     * @external
     */
    condition: CfnEventBusPolicy.ConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Events::EventBusPolicy.EventBusName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-eventbusname
     * @external
     */
    eventBusName: string | undefined;
    /**
     * Create a new `AWS::Events::EventBusPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventBusPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Events::EventBusPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html
 * @external
 * @cloudformationResource AWS::Events::EventBusPolicy
 */
export declare namespace CfnEventBusPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html
     * @external
     */
    interface ConditionProperty {
        /**
         * `CfnEventBusPolicy.ConditionProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnEventBusPolicy.ConditionProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnEventBusPolicy.ConditionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 */
export interface CfnRuleProps {
    /**
     * `AWS::Events::Rule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Events::Rule.EventBusName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventbusname
     * @external
     */
    readonly eventBusName?: string;
    /**
     * `AWS::Events::Rule.EventPattern`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern
     * @external
     */
    readonly eventPattern?: any | cdk.IResolvable;
    /**
     * `AWS::Events::Rule.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Events::Rule.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::Events::Rule.ScheduleExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression
     * @external
     */
    readonly scheduleExpression?: string;
    /**
     * `AWS::Events::Rule.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state
     * @external
     */
    readonly state?: string;
    /**
     * `AWS::Events::Rule.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets
     * @external
     */
    readonly targets?: Array<CfnRule.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare class CfnRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Events::Rule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRule;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Events::Rule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Events::Rule.EventBusName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventbusname
     * @external
     */
    eventBusName: string | undefined;
    /**
     * `AWS::Events::Rule.EventPattern`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern
     * @external
     */
    eventPattern: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Events::Rule.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Events::Rule.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::Events::Rule.ScheduleExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression
     * @external
     */
    scheduleExpression: string | undefined;
    /**
     * `AWS::Events::Rule.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state
     * @external
     */
    state: string | undefined;
    /**
     * `AWS::Events::Rule.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets
     * @external
     */
    targets: Array<CfnRule.TargetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Events::Rule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html
     * @external
     */
    interface AwsVpcConfigurationProperty {
        /**
         * `CfnRule.AwsVpcConfigurationProperty.AssignPublicIp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-assignpublicip
         * @external
         */
        readonly assignPublicIp?: string;
        /**
         * `CfnRule.AwsVpcConfigurationProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-securitygroups
         * @external
         */
        readonly securityGroups?: string[];
        /**
         * `CfnRule.AwsVpcConfigurationProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html
     * @external
     */
    interface BatchArrayPropertiesProperty {
        /**
         * `CfnRule.BatchArrayPropertiesProperty.Size`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html#cfn-events-rule-batcharrayproperties-size
         * @external
         */
        readonly size?: number;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html
     * @external
     */
    interface BatchParametersProperty {
        /**
         * `CfnRule.BatchParametersProperty.ArrayProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-arrayproperties
         * @external
         */
        readonly arrayProperties?: CfnRule.BatchArrayPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnRule.BatchParametersProperty.JobDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobdefinition
         * @external
         */
        readonly jobDefinition: string;
        /**
         * `CfnRule.BatchParametersProperty.JobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobname
         * @external
         */
        readonly jobName: string;
        /**
         * `CfnRule.BatchParametersProperty.RetryStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-retrystrategy
         * @external
         */
        readonly retryStrategy?: CfnRule.BatchRetryStrategyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html
     * @external
     */
    interface BatchRetryStrategyProperty {
        /**
         * `CfnRule.BatchRetryStrategyProperty.Attempts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html#cfn-events-rule-batchretrystrategy-attempts
         * @external
         */
        readonly attempts?: number;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html
     * @external
     */
    interface EcsParametersProperty {
        /**
         * `CfnRule.EcsParametersProperty.Group`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-group
         * @external
         */
        readonly group?: string;
        /**
         * `CfnRule.EcsParametersProperty.LaunchType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-launchtype
         * @external
         */
        readonly launchType?: string;
        /**
         * `CfnRule.EcsParametersProperty.NetworkConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-networkconfiguration
         * @external
         */
        readonly networkConfiguration?: CfnRule.NetworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnRule.EcsParametersProperty.PlatformVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-platformversion
         * @external
         */
        readonly platformVersion?: string;
        /**
         * `CfnRule.EcsParametersProperty.TaskCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         * @external
         */
        readonly taskCount?: number;
        /**
         * `CfnRule.EcsParametersProperty.TaskDefinitionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         * @external
         */
        readonly taskDefinitionArn: string;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html
     * @external
     */
    interface HttpParametersProperty {
        /**
         * `CfnRule.HttpParametersProperty.HeaderParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-headerparameters
         * @external
         */
        readonly headerParameters?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnRule.HttpParametersProperty.PathParameterValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-pathparametervalues
         * @external
         */
        readonly pathParameterValues?: string[];
        /**
         * `CfnRule.HttpParametersProperty.QueryStringParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-querystringparameters
         * @external
         */
        readonly queryStringParameters?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html
     * @external
     */
    interface InputTransformerProperty {
        /**
         * `CfnRule.InputTransformerProperty.InputPathsMap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         * @external
         */
        readonly inputPathsMap?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnRule.InputTransformerProperty.InputTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         * @external
         */
        readonly inputTemplate: string;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html
     * @external
     */
    interface KinesisParametersProperty {
        /**
         * `CfnRule.KinesisParametersProperty.PartitionKeyPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         * @external
         */
        readonly partitionKeyPath: string;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html
     * @external
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnRule.NetworkConfigurationProperty.AwsVpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html#cfn-events-rule-networkconfiguration-awsvpcconfiguration
         * @external
         */
        readonly awsVpcConfiguration?: CfnRule.AwsVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html
     * @external
     */
    interface RunCommandParametersProperty {
        /**
         * `CfnRule.RunCommandParametersProperty.RunCommandTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         * @external
         */
        readonly runCommandTargets: Array<CfnRule.RunCommandTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html
     * @external
     */
    interface RunCommandTargetProperty {
        /**
         * `CfnRule.RunCommandTargetProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnRule.RunCommandTargetProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html
     * @external
     */
    interface SqsParametersProperty {
        /**
         * `CfnRule.SqsParametersProperty.MessageGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
         * @external
         */
        readonly messageGroupId: string;
    }
}
/**
 * A CloudFormation `AWS::Events::Rule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 * @external
 * @cloudformationResource AWS::Events::Rule
 */
export declare namespace CfnRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html
     * @external
     */
    interface TargetProperty {
        /**
         * `CfnRule.TargetProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnRule.TargetProperty.BatchParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-batchparameters
         * @external
         */
        readonly batchParameters?: CfnRule.BatchParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.EcsParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         * @external
         */
        readonly ecsParameters?: CfnRule.EcsParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.HttpParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-httpparameters
         * @external
         */
        readonly httpParameters?: CfnRule.HttpParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnRule.TargetProperty.Input`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         * @external
         */
        readonly input?: string;
        /**
         * `CfnRule.TargetProperty.InputPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         * @external
         */
        readonly inputPath?: string;
        /**
         * `CfnRule.TargetProperty.InputTransformer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         * @external
         */
        readonly inputTransformer?: CfnRule.InputTransformerProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.KinesisParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         * @external
         */
        readonly kinesisParameters?: CfnRule.KinesisParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnRule.TargetProperty.RunCommandParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         * @external
         */
        readonly runCommandParameters?: CfnRule.RunCommandParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.SqsParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         * @external
         */
        readonly sqsParameters?: CfnRule.SqsParametersProperty | cdk.IResolvable;
    }
}
