import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxIntentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#description DialogflowCxIntent#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The human-readable name of the intent, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#display_name DialogflowCxIntent#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Indicates whether this is a fallback intent.
     *
     * Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
     * Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#is_fallback DialogflowCxIntent#is_fallback}
     *
     * @stability stable
     */
    readonly isFallback?: boolean | cdktf.IResolvable;
    /**
     * The key/value metadata to label an intent.
     *
     * Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#labels DialogflowCxIntent#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The language of the following fields in intent: Intent.training_phrases.parts.text If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#language_code DialogflowCxIntent#language_code}
     *
     * @stability stable
     */
    readonly languageCode?: string;
    /**
     * The agent to create an intent for. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#parent DialogflowCxIntent#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * The priority of this intent.
     *
     * Higher numbers represent higher priorities.
     * If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
     * If the supplied value is negative, the intent is ignored in runtime detect intent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#priority DialogflowCxIntent#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#parameters DialogflowCxIntent#parameters}
     *
     * @stability stable
     */
    readonly parameters?: DialogflowCxIntentParameters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#timeouts DialogflowCxIntent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxIntentTimeouts;
    /**
     * training_phrases block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#training_phrases DialogflowCxIntent#training_phrases}
     *
     * @stability stable
     */
    readonly trainingPhrases?: DialogflowCxIntentTrainingPhrases[];
}
/**
 * @stability stable
 */
export interface DialogflowCxIntentParameters {
    /**
     * The entity type of the parameter.
     *
     * Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#entity_type DialogflowCxIntent#entity_type}
     *
     * @stability stable
     */
    readonly entityType: string;
    /**
     * The unique identifier of the parameter. This field is used by training phrases to annotate their parts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#id DialogflowCxIntent#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Indicates whether the parameter represents a list of values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#is_list DialogflowCxIntent#is_list}
     *
     * @stability stable
     */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the parameter content should be redacted in log.
     *
     * If redaction is enabled, the parameter content will be replaced by parameter name during logging.
     * Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#redact DialogflowCxIntent#redact}
     *
     * @stability stable
     */
    readonly redact?: boolean | cdktf.IResolvable;
}
export declare function dialogflowCxIntentParametersToTerraform(struct?: DialogflowCxIntentParameters): any;
/**
 * @stability stable
 */
export interface DialogflowCxIntentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#create DialogflowCxIntent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#delete DialogflowCxIntent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#update DialogflowCxIntent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dialogflowCxIntentTimeoutsToTerraform(struct?: DialogflowCxIntentTimeoutsOutputReference | DialogflowCxIntentTimeouts): any;
/**
 * @stability stable
 */
export declare class DialogflowCxIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxIntentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxIntentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxIntentTrainingPhrasesParts {
    /**
     * The parameter used to annotate this part of the training phrase.
     *
     * This field is required for annotated parts of the training phrase.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#parameter_id DialogflowCxIntent#parameter_id}
     *
     * @stability stable
     */
    readonly parameterId?: string;
    /**
     * The text for this part.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#text DialogflowCxIntent#text}
     *
     * @stability stable
     */
    readonly text: string;
}
export declare function dialogflowCxIntentTrainingPhrasesPartsToTerraform(struct?: DialogflowCxIntentTrainingPhrasesParts): any;
/**
 * @stability stable
 */
export interface DialogflowCxIntentTrainingPhrases {
    /**
     * Indicates how many times this example was added to the intent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#repeat_count DialogflowCxIntent#repeat_count}
     *
     * @stability stable
     */
    readonly repeatCount?: number;
    /**
     * parts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html#parts DialogflowCxIntent#parts}
     *
     * @stability stable
     */
    readonly parts: DialogflowCxIntentTrainingPhrasesParts[];
}
export declare function dialogflowCxIntentTrainingPhrasesToTerraform(struct?: DialogflowCxIntentTrainingPhrases): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html google_dialogflow_cx_intent}.
 *
 * @stability stable
 */
export declare class DialogflowCxIntent extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_intent.html google_dialogflow_cx_intent} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxIntentConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isFallback?;
    /**
     * @stability stable
     */
    get isFallback(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isFallback(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsFallback(): void;
    /**
     * @stability stable
     */
    get isFallbackInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _languageCode?;
    /**
     * @stability stable
     */
    get languageCode(): string;
    /**
     * @stability stable
     */
    set languageCode(value: string);
    /**
     * @stability stable
     */
    resetLanguageCode(): void;
    /**
     * @stability stable
     */
    get languageCodeInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): DialogflowCxIntentParameters[];
    /**
     * @stability stable
     */
    set parameters(value: DialogflowCxIntentParameters[]);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): DialogflowCxIntentParameters[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxIntentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxIntentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxIntentTimeouts | undefined;
    private _trainingPhrases?;
    /**
     * @stability stable
     */
    get trainingPhrases(): DialogflowCxIntentTrainingPhrases[];
    /**
     * @stability stable
     */
    set trainingPhrases(value: DialogflowCxIntentTrainingPhrases[]);
    /**
     * @stability stable
     */
    resetTrainingPhrases(): void;
    /**
     * @stability stable
     */
    get trainingPhrasesInput(): DialogflowCxIntentTrainingPhrases[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
