import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#description DnsPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Allows networks bound to this policy to receive DNS queries sent by VMs or applications over VPN connections.
     *
     * When enabled, a
     * virtual IP address will be allocated from each of the sub-networks
     * that are bound to this policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#enable_inbound_forwarding DnsPolicy#enable_inbound_forwarding}
     *
     * @stability stable
     */
    readonly enableInboundForwarding?: boolean | cdktf.IResolvable;
    /**
     * Controls whether logging is enabled for the networks bound to this policy. Defaults to no logging if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#enable_logging DnsPolicy#enable_logging}
     *
     * @stability stable
     */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
     * User assigned name for this policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#name DnsPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#project DnsPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * alternative_name_server_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#alternative_name_server_config DnsPolicy#alternative_name_server_config}
     *
     * @stability stable
     */
    readonly alternativeNameServerConfig?: DnsPolicyAlternativeNameServerConfig;
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#networks DnsPolicy#networks}
     *
     * @stability stable
     */
    readonly networks?: DnsPolicyNetworks[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#timeouts DnsPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface DnsPolicyAlternativeNameServerConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#forwarding_path DnsPolicy#forwarding_path}
     *
     * @stability stable
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address to forward to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#ipv4_address DnsPolicy#ipv4_address}
     *
     * @stability stable
     */
    readonly ipv4Address: string;
}
export declare function dnsPolicyAlternativeNameServerConfigTargetNameServersToTerraform(struct?: DnsPolicyAlternativeNameServerConfigTargetNameServers): any;
/**
 * @stability stable
 */
export interface DnsPolicyAlternativeNameServerConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#target_name_servers DnsPolicy#target_name_servers}
     *
     * @stability stable
     */
    readonly targetNameServers: DnsPolicyAlternativeNameServerConfigTargetNameServers[];
}
export declare function dnsPolicyAlternativeNameServerConfigToTerraform(struct?: DnsPolicyAlternativeNameServerConfigOutputReference | DnsPolicyAlternativeNameServerConfig): any;
/**
 * @stability stable
 */
export declare class DnsPolicyAlternativeNameServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsPolicyAlternativeNameServerConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsPolicyAlternativeNameServerConfig | undefined);
    private _targetNameServers?;
    /**
     * @stability stable
     */
    get targetNameServers(): DnsPolicyAlternativeNameServerConfigTargetNameServers[];
    /**
     * @stability stable
     */
    set targetNameServers(value: DnsPolicyAlternativeNameServerConfigTargetNameServers[]);
    /**
     * @stability stable
     */
    get targetNameServersInput(): DnsPolicyAlternativeNameServerConfigTargetNameServers[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsPolicyNetworks {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#network_url DnsPolicy#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
export declare function dnsPolicyNetworksToTerraform(struct?: DnsPolicyNetworks): any;
/**
 * @stability stable
 */
export interface DnsPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#create DnsPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#delete DnsPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#update DnsPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsPolicyTimeoutsToTerraform(struct?: DnsPolicyTimeoutsOutputReference | DnsPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DnsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html google_dns_policy}.
 *
 * @stability stable
 */
export declare class DnsPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html google_dns_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableInboundForwarding?;
    /**
     * @stability stable
     */
    get enableInboundForwarding(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableInboundForwarding(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableInboundForwarding(): void;
    /**
     * @stability stable
     */
    get enableInboundForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    /**
     * @stability stable
     */
    get enableLogging(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableLogging(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableLogging(): void;
    /**
     * @stability stable
     */
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _alternativeNameServerConfig;
    /**
     * @stability stable
     */
    get alternativeNameServerConfig(): DnsPolicyAlternativeNameServerConfigOutputReference;
    /**
     * @stability stable
     */
    putAlternativeNameServerConfig(value: DnsPolicyAlternativeNameServerConfig): void;
    /**
     * @stability stable
     */
    resetAlternativeNameServerConfig(): void;
    /**
     * @stability stable
     */
    get alternativeNameServerConfigInput(): DnsPolicyAlternativeNameServerConfig | undefined;
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): DnsPolicyNetworks[];
    /**
     * @stability stable
     */
    set networks(value: DnsPolicyNetworks[]);
    /**
     * @stability stable
     */
    resetNetworks(): void;
    /**
     * @stability stable
     */
    get networksInput(): DnsPolicyNetworks[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
