import pandas as pd
import numpy as np

def load_IEEE5():
        n_bus = 5

        line_data= [[  1,  2,	0.02,	0.06,	0.06],
                    [   1,  3,	0.08,	0.24,	0.05],
                    [   2,  3,	0.06,	0.25,	0.04],
                    [   2,  4,	0.06,	0.18,	0.04],
                    [   2,  5,	0.04,	0.12,	0.03],
                    [   3,  4,	0.01,	0.03,	0.02],
                    [   4,  5,	0.08,	0.24,	0.05]]
        
        line_data =  np.array(line_data )[:,:4] 

        df_line_data = pd.DataFrame( line_data , columns=['FromBus','ToBus','R','X']  )


        load_data = [   [1, 0, 0],
                        [2, 20000,  10000],
                        [3, 45000,  15000],
                        [4, 40000,  5000],
                        [5, 60000,  10000]]

        df_load_data = pd.DataFrame( load_data , columns=['BusID','P_KW','Q_KVAr']  )               

        return df_load_data, df_line_data, n_bus

def load_IEEE33():

        n_bus = 33


        line_data=      [[1,2,0.0922,0.047],
                        [2,3,0.493,0.2511],
                        [3,4,0.366,0.1864],
                        [4,5,0.3811,0.1941],
                        [5,6,0.819,0.707],
                        [6,7,0.1872,0.6188],
                        [7,8,1.7114,1.2351],
                        [8,9,1.03,0.74],
                        [9,10,1.04,0.74],
                        [10,11,0.7966,0.065],
                        [11,12,0.3744,0.1238],
                        [12,13,1.468,1.155],
                        [13,14,0.5416,0.7129],
                        [14,15,0.591,0.526],
                        [15,16,0.7463,0.545],
                        [16,17,1.289,1.721],
                        [17,18,0.32,0.574],
                        [2,19,0.164,0.1565],
                        [19,20,1.5042,1.3554],
                        [20,21,0.4095,0.4784],
                        [21,22,0.7089,0.9373],
                        [3,23,0.4512,0.3083],
                        [23,24,0.898,0.7091],
                        [24,25,0.896,0.7011],
                        [6,26,0.203,0.1034],
                        [26,27,0.2842,0.1447],
                        [27,28,1.059,0.9337],
                        [28,29,0.8042,0.7006],
                        [29,30,0.5075,0.2585],
                        [30,31,0.9744,0.963],
                        [31,32,0.3105,0.3619],
                        [32,33,0.341,0.5302]]
        
        line_data =  np.array(line_data )[:,:4] 

        df_line_data = pd.DataFrame( line_data , columns=['FromBus','ToBus','R','X']  )


        load_data = [   [1.00,0.00,0.00],
                        [2.00,100.00,60.00],
                        [3.00,90.00,40.00],
                        [4.00,120.00,80.00],
                        [5.00,60.00,30.00],
                        [6.00,60.00,20.00],
                        [7.00,200.00,100.00],
                        [8.00,200.00,100.00],
                        [9.00,60.00,20.00],
                        [10.00,60.00,20.00],
                        [11.00,45.00,30.00],
                        [12.00,60.00,35.00],
                        [13.00,60.00,35.00],
                        [14.00,120.00,80.00],
                        [15.00,60.00,10.00],
                        [16.00,60.00,20.00],
                        [17.00,60.00,20.00],
                        [18.00,90.00,40.00],
                        [19.00,90.00,40.00],
                        [20.00,90.00,40.00],
                        [21.00,90.00,40.00],
                        [22.00,90.00,40.00],
                        [23.00,90.00,50.00],
                        [24.00,420.00,200.00],
                        [25.00,420.00,200.00],
                        [26.00,60.00,25.00],
                        [27.00,60.00,25.00],
                        [28.00,60.00,20.00],
                        [29.00,120.00,70.00],
                        [30.00,200.00,600.00],
                        [31.00,150.00,70.00],
                        [32.00,210.00,100.00],
                        [33.00,60.00,40.00]]


        df_load_data = pd.DataFrame( load_data , columns=['BusID','P_KW','Q_KVAr']  )               

        return df_load_data, df_line_data, n_bus


def load_IEEE69():

        n_bus = 69


        line_data=  [[ 1,2,0.0005,0.0012],
                        [ 2,3,0.0005,0.0012],
                        [ 3,4,0.0015,0.0036],
                        [ 4,5,0.0251,0.0294],
                        [ 5,6,0.3660,0.1864],
                        [ 6,7,0.3811,0.9410],
                        [ 7,8,0.0922,0.0470],
                        [ 8,9,0.0493,0.0251],
                        [ 9,10,0.8190,0.2707],
                        [ 10,11,0.1872,0.0619],
                        [ 11,12,0.7114,0.2351],
                        [ 12,13,1.0300,0.3400],
                        [ 13,14,1.0400,0.3450],
                        [ 14,15,1.0580,0.3496],
                        [ 15,16,0.1966,0.0650],
                        [ 16,17,0.3744,0.1238],
                        [ 17,18,0.0047,0.0016],
                        [ 18,19,0.3276,0.1083],
                        [ 19,20,0.2106,0.0690],
                        [ 20,21,0.3416,0.1129],
                        [ 21,22,0.0140,0.0046],
                        [ 22,23,0.1591,0.0526],
                        [ 23,24,0.3463,0.1145],
                        [ 24,25,0.7488,0.2475],
                        [ 25,26,0.3089,0.1021],
                        [ 26,27,0.1732,0.0572],
                        [ 3,28,0.0044,0.0108],
                        [ 28,29,0.0640,0.1565],
                        [ 29,30,0.3978,0.1315],
                        [ 30,31,0.0702,0.0232],
                        [ 31,32,0.3510,0.1160],
                        [ 32,33,0.8390,0.2816],
                        [ 33,34,1.7080,0.5646],
                        [ 34,35,1.4740,0.4873],
                        [ 3,36,0.0044,0.0108],
                        [ 36,37,0.0640,0.1565],
                        [ 37,38,0.1053,0.1230],
                        [ 38,39,0.0304,0.0355],
                        [ 39,40,0.0018,0.0021],
                        [ 40,41,0.7283,0.8509],
                        [ 41,42,0.3100,0.3623],
                        [ 42,43,0.0410,0.0478],
                        [ 43,44,0.0092,0.0116],
                        [ 44,45,0.1089,0.1373],
                        [ 45,46,0.0009,0.0012],
                        [ 4,47,0.0034,0.0084],
                        [ 47,48,0.0851,0.2083],
                        [ 48,49,0.2898,0.7091],
                        [ 49,50,0.0822,0.2011],
                        [ 8,51,0.0928,0.0473],
                        [ 51,52,0.3319,0.1114],
                        [ 52,53,0.1740,0.0886],
                        [ 53,54,0.2030,0.1034],
                        [ 54,55,0.2842,0.1447],
                        [ 55,56,0.2813,0.1433],
                        [ 56,57,1.5900,0.5337],
                        [ 57,58,0.7837,0.2630],
                        [ 58,59,0.3042,0.1006],
                        [ 59,60,0.3861,0.1172],
                        [ 60,61,0.5075,0.2585],
                        [ 61,62,0.0974,0.0496],
                        [ 62,63,0.1450,0.0738],
                        [ 63,64,0.7105,0.3619],
                        [ 64,65,1.0410,0.5302],
                        [ 11,66,0.2012,0.0611],
                        [ 66,67,0.0047,0.0014],
                        [ 12,68,0.7394,0.2444],
                        [ 68,69,0.0047,0.0016]]
        
        line_data =  np.array(line_data )[:,:4] 

        df_line_data = pd.DataFrame( line_data , columns=['FromBus','ToBus','R','X']  )


        load_data = [  [1,0.00,0.00],
                        [2,0.00,0.00],
                        [3,0.00,0.00],
                        [4,0.00,0.00],
                        [5,0.00,0.00],
                        [6,2.60,2.20],
                        [7,40.40,30.00],
                        [8,75.00,54.00],
                        [9,30.00,22.00],
                        [10,28.00,19.00],
                        [11,145.00,104.00],
                        [12,145.00,104.00],
                        [13,8.00,5.00],
                        [14,8.00,5.50],
                        [15,0.00,0.00],
                        [16,45.50,30.00],
                        [17,60.00,35.00],
                        [18,60.00,35.00],
                        [19,0.00,0.00],
                        [20,1.00,0.60],
                        [21,114.00,81.00],
                        [22,5.00,3.50],
                        [23,0.00,0.00],
                        [24,28.00,20.00],
                        [25,0.00,0.00],
                        [26,14.00,10.00],
                        [27,14.00,10.00],
                        [28,26.00,18.60],
                        [29,26.00,18.60],
                        [30,0.00,0.00],
                        [31,0.00,0.00],
                        [32,0.00,0.00],
                        [33,14.00,10.00],
                        [34,9.50,14.00],
                        [35,6.00,4.00],
                        [36,26.00,18.55],
                        [37,26.00,18.55],
                        [38,0.00,0.00],
                        [39,24.00,17.00],
                        [40,24.00,17.00],
                        [41,1.20,1.00],
                        [42,0.00,0.00],
                        [43,6.00,4.30],
                        [44,0.00,0.00],
                        [45,39.22,26.30],
                        [46,39.22,26.30],
                        [47,0.00,0.00],
                        [48,79.00,56.40],
                        [49,384.70,274.50],
                        [50,384.70,274.50],
                        [51,40.50,28.30],
                        [52,3.60,2.70],
                        [53,4.35,3.50],
                        [54,26.40,19.00],
                        [55,24.00,17.20],
                        [56,0.00,0.00],
                        [57,0.00,0.00],
                        [58,0.00,0.00],
                        [59,100.00,72.00],
                        [60,0.00,0.00],
                        [61,1244.00,888.00],
                        [62,32.00,23.00],
                        [63,0.00,0.00],
                        [64,227.00,162.00],
                        [65,59.00,42.00],
                        [66,18.00,13.00],
                        [67,18.00,13.00],
                        [68,28.00,20.00],
                        [69,28.00,20.00]]


        df_load_data = pd.DataFrame( load_data , columns=['BusID','P_KW','Q_KVAr']  )               

        return df_load_data, df_line_data, n_bus
    
if __name__ == "__main__" :

        df_load_data, df_line_data, n_bus  = load_IEEE5()
        print(df_load_data)
        print(df_line_data)




