"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
class AwsCdkConstructLibrary extends projen_1.awscdk.AwsCdkConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            ...options,
            authorOrganization: true,
            license: "MIT",
            copyrightOwner: "Pepperize UG (haftungsbeschränkt)",
            autoApproveUpgrades: true,
            autoApproveOptions: {
                ...options.autoApproveOptions,
                allowedUsernames: ["pflorek", "acfo", "dependabot[bot]"],
                label: "auto-approve",
                secret: "GITHUB_TOKEN",
            },
            depsUpgradeOptions: {
                ...options.depsUpgradeOptions,
                workflowOptions: {
                    ...options.depsUpgradeOptions?.workflowOptions,
                },
            },
            dependabot: true,
            dependabotOptions: {
                labels: ["auto-approve"],
            },
            eslint: true,
            prettier: true,
            prettierOptions: {
                ...options.prettierOptions,
                settings: {
                    ...options.prettierOptions?.settings,
                    printWidth: 120,
                },
            },
            defaultReleaseBranch: "main",
            npmAccess: projen_1.javascript.NpmAccess.PUBLIC,
            release: true,
            staleOptions: {
                pullRequest: {
                    daysBeforeStale: 90,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                issues: {
                    daysBeforeStale: 180,
                    daysBeforeClose: 30,
                    ...options.staleOptions?.pullRequest,
                },
                ...options.staleOptions,
            },
            gitignore: [...(options.gitignore || [])],
        });
        this.gitignore.exclude(".idea/", "*.iml", ".vscode/");
        this.prettier?.addIgnorePattern("API.md");
        this.tryFindObjectFile(".mergify.yml")?.addOverride("pull_request_rules.0.actions.queue.method", "merge");
        this.formatTask = this.addTask("format", {
            description: "Format with prettier",
            exec: "prettier --write src/**/*.ts test/**/*.ts .projenrc.[jt]s README.md",
        });
        // https://editorconfig.org/#file-format-details
        new projen_1.IniFile(this, ".editorconfig", {
            obj: {
                ["root"]: true,
                ["*"]: {
                    ["end_of_line"]: "lf",
                    ["charset"]: "utf-8",
                },
                ["*.{js,ts}"]: {
                    ["indent_style"]: "space",
                    ["indent_size"]: 2,
                    ["max_line_length"]: 120,
                },
            },
            marker: true,
        });
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "@pepperize/projen-awscdk-construct.AwsCdkConstructLibrary", version: "0.0.430" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtQ0FBMkQ7QUFFM0QsTUFBYSxzQkFBdUIsU0FBUSxlQUFNLENBQUMsc0JBQXNCO0lBTXZFOztPQUVHO0lBQ0gsWUFBWSxPQUE2QztRQUN2RCxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFDVixrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLE9BQU8sRUFBRSxLQUFLO1lBQ2QsY0FBYyxFQUFFLG1DQUFtQztZQUNuRCxtQkFBbUIsRUFBRSxJQUFJO1lBQ3pCLGtCQUFrQixFQUFFO2dCQUNsQixHQUFHLE9BQU8sQ0FBQyxrQkFBa0I7Z0JBQzdCLGdCQUFnQixFQUFFLENBQUMsU0FBUyxFQUFFLE1BQU0sRUFBRSxpQkFBaUIsQ0FBQztnQkFDeEQsS0FBSyxFQUFFLGNBQWM7Z0JBQ3JCLE1BQU0sRUFBRSxjQUFjO2FBQ3ZCO1lBQ0Qsa0JBQWtCLEVBQUU7Z0JBQ2xCLEdBQUcsT0FBTyxDQUFDLGtCQUFrQjtnQkFDN0IsZUFBZSxFQUFFO29CQUNmLEdBQUcsT0FBTyxDQUFDLGtCQUFrQixFQUFFLGVBQWU7aUJBQy9DO2FBQ0Y7WUFDRCxVQUFVLEVBQUUsSUFBSTtZQUNoQixpQkFBaUIsRUFBRTtnQkFDakIsTUFBTSxFQUFFLENBQUMsY0FBYyxDQUFDO2FBQ3pCO1lBQ0QsTUFBTSxFQUFFLElBQUk7WUFDWixRQUFRLEVBQUUsSUFBSTtZQUNkLGVBQWUsRUFBRTtnQkFDZixHQUFHLE9BQU8sQ0FBQyxlQUFlO2dCQUMxQixRQUFRLEVBQUU7b0JBQ1IsR0FBRyxPQUFPLENBQUMsZUFBZSxFQUFFLFFBQVE7b0JBQ3BDLFVBQVUsRUFBRSxHQUFHO2lCQUNoQjthQUNGO1lBQ0Qsb0JBQW9CLEVBQUUsTUFBTTtZQUM1QixTQUFTLEVBQUUsbUJBQVUsQ0FBQyxTQUFTLENBQUMsTUFBTTtZQUN0QyxPQUFPLEVBQUUsSUFBSTtZQUNiLFlBQVksRUFBRTtnQkFDWixXQUFXLEVBQUU7b0JBQ1gsZUFBZSxFQUFFLEVBQUU7b0JBQ25CLGVBQWUsRUFBRSxFQUFFO29CQUNuQixHQUFHLE9BQU8sQ0FBQyxZQUFZLEVBQUUsV0FBVztpQkFDckM7Z0JBQ0QsTUFBTSxFQUFFO29CQUNOLGVBQWUsRUFBRSxHQUFHO29CQUNwQixlQUFlLEVBQUUsRUFBRTtvQkFDbkIsR0FBRyxPQUFPLENBQUMsWUFBWSxFQUFFLFdBQVc7aUJBQ3JDO2dCQUNELEdBQUcsT0FBTyxDQUFDLFlBQVk7YUFDeEI7WUFDRCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUMxQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBRXRELElBQUksQ0FBQyxRQUFRLEVBQUUsZ0JBQWdCLENBQUMsUUFBUSxDQUFDLENBQUM7UUFFMUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxFQUFFLFdBQVcsQ0FBQywyQ0FBMkMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUUxRyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQ3ZDLFdBQVcsRUFBRSxzQkFBc0I7WUFDbkMsSUFBSSxFQUFFLHFFQUFxRTtTQUM1RSxDQUFDLENBQUM7UUFFSCxnREFBZ0Q7UUFDaEQsSUFBSSxnQkFBTyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDakMsR0FBRyxFQUFFO2dCQUNILENBQUMsTUFBTSxDQUFDLEVBQUUsSUFBSTtnQkFDZCxDQUFDLEdBQUcsQ0FBQyxFQUFFO29CQUNMLENBQUMsYUFBYSxDQUFDLEVBQUUsSUFBSTtvQkFDckIsQ0FBQyxTQUFTLENBQUMsRUFBRSxPQUFPO2lCQUNyQjtnQkFDRCxDQUFDLFdBQVcsQ0FBQyxFQUFFO29CQUNiLENBQUMsY0FBYyxDQUFDLEVBQUUsT0FBTztvQkFDekIsQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDO29CQUNsQixDQUFDLGlCQUFpQixDQUFDLEVBQUUsR0FBRztpQkFDekI7YUFDRjtZQUNELE1BQU0sRUFBRSxJQUFJO1NBQ2IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF2Rkgsd0RBd0ZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzY2RrLCBJbmlGaWxlLCBqYXZhc2NyaXB0LCBUYXNrIH0gZnJvbSBcInByb2plblwiO1xuXG5leHBvcnQgY2xhc3MgQXdzQ2RrQ29uc3RydWN0TGlicmFyeSBleHRlbmRzIGF3c2Nkay5Bd3NDZGtDb25zdHJ1Y3RMaWJyYXJ5IHtcbiAgLyoqXG4gICAqIFRoZSBcImZvcm1hdFwiIHRhc2suXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZm9ybWF0VGFzazogVGFzaztcblxuICAvKipcbiAgICogQGV4cGVyaW1lbnRhbFxuICAgKi9cbiAgY29uc3RydWN0b3Iob3B0aW9uczogYXdzY2RrLkF3c0Nka0NvbnN0cnVjdExpYnJhcnlPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIGF1dGhvck9yZ2FuaXphdGlvbjogdHJ1ZSxcbiAgICAgIGxpY2Vuc2U6IFwiTUlUXCIsXG4gICAgICBjb3B5cmlnaHRPd25lcjogXCJQZXBwZXJpemUgVUcgKGhhZnR1bmdzYmVzY2hyw6Rua3QpXCIsXG4gICAgICBhdXRvQXBwcm92ZVVwZ3JhZGVzOiB0cnVlLFxuICAgICAgYXV0b0FwcHJvdmVPcHRpb25zOiB7XG4gICAgICAgIC4uLm9wdGlvbnMuYXV0b0FwcHJvdmVPcHRpb25zLFxuICAgICAgICBhbGxvd2VkVXNlcm5hbWVzOiBbXCJwZmxvcmVrXCIsIFwiYWNmb1wiLCBcImRlcGVuZGFib3RbYm90XVwiXSxcbiAgICAgICAgbGFiZWw6IFwiYXV0by1hcHByb3ZlXCIsXG4gICAgICAgIHNlY3JldDogXCJHSVRIVUJfVE9LRU5cIixcbiAgICAgIH0sXG4gICAgICBkZXBzVXBncmFkZU9wdGlvbnM6IHtcbiAgICAgICAgLi4ub3B0aW9ucy5kZXBzVXBncmFkZU9wdGlvbnMsXG4gICAgICAgIHdvcmtmbG93T3B0aW9uczoge1xuICAgICAgICAgIC4uLm9wdGlvbnMuZGVwc1VwZ3JhZGVPcHRpb25zPy53b3JrZmxvd09wdGlvbnMsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgZGVwZW5kYWJvdDogdHJ1ZSxcbiAgICAgIGRlcGVuZGFib3RPcHRpb25zOiB7XG4gICAgICAgIGxhYmVsczogW1wiYXV0by1hcHByb3ZlXCJdLFxuICAgICAgfSxcbiAgICAgIGVzbGludDogdHJ1ZSxcbiAgICAgIHByZXR0aWVyOiB0cnVlLFxuICAgICAgcHJldHRpZXJPcHRpb25zOiB7XG4gICAgICAgIC4uLm9wdGlvbnMucHJldHRpZXJPcHRpb25zLFxuICAgICAgICBzZXR0aW5nczoge1xuICAgICAgICAgIC4uLm9wdGlvbnMucHJldHRpZXJPcHRpb25zPy5zZXR0aW5ncyxcbiAgICAgICAgICBwcmludFdpZHRoOiAxMjAsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgZGVmYXVsdFJlbGVhc2VCcmFuY2g6IFwibWFpblwiLFxuICAgICAgbnBtQWNjZXNzOiBqYXZhc2NyaXB0Lk5wbUFjY2Vzcy5QVUJMSUMsXG4gICAgICByZWxlYXNlOiB0cnVlLFxuICAgICAgc3RhbGVPcHRpb25zOiB7XG4gICAgICAgIHB1bGxSZXF1ZXN0OiB7XG4gICAgICAgICAgZGF5c0JlZm9yZVN0YWxlOiA5MCxcbiAgICAgICAgICBkYXlzQmVmb3JlQ2xvc2U6IDMwLFxuICAgICAgICAgIC4uLm9wdGlvbnMuc3RhbGVPcHRpb25zPy5wdWxsUmVxdWVzdCxcbiAgICAgICAgfSxcbiAgICAgICAgaXNzdWVzOiB7XG4gICAgICAgICAgZGF5c0JlZm9yZVN0YWxlOiAxODAsXG4gICAgICAgICAgZGF5c0JlZm9yZUNsb3NlOiAzMCxcbiAgICAgICAgICAuLi5vcHRpb25zLnN0YWxlT3B0aW9ucz8ucHVsbFJlcXVlc3QsXG4gICAgICAgIH0sXG4gICAgICAgIC4uLm9wdGlvbnMuc3RhbGVPcHRpb25zLFxuICAgICAgfSxcbiAgICAgIGdpdGlnbm9yZTogWy4uLihvcHRpb25zLmdpdGlnbm9yZSB8fCBbXSldLFxuICAgIH0pO1xuXG4gICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZShcIi5pZGVhL1wiLCBcIiouaW1sXCIsIFwiLnZzY29kZS9cIik7XG5cbiAgICB0aGlzLnByZXR0aWVyPy5hZGRJZ25vcmVQYXR0ZXJuKFwiQVBJLm1kXCIpO1xuXG4gICAgdGhpcy50cnlGaW5kT2JqZWN0RmlsZShcIi5tZXJnaWZ5LnltbFwiKT8uYWRkT3ZlcnJpZGUoXCJwdWxsX3JlcXVlc3RfcnVsZXMuMC5hY3Rpb25zLnF1ZXVlLm1ldGhvZFwiLCBcIm1lcmdlXCIpO1xuXG4gICAgdGhpcy5mb3JtYXRUYXNrID0gdGhpcy5hZGRUYXNrKFwiZm9ybWF0XCIsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBcIkZvcm1hdCB3aXRoIHByZXR0aWVyXCIsXG4gICAgICBleGVjOiBcInByZXR0aWVyIC0td3JpdGUgc3JjLyoqLyoudHMgdGVzdC8qKi8qLnRzIC5wcm9qZW5yYy5banRdcyBSRUFETUUubWRcIixcbiAgICB9KTtcblxuICAgIC8vIGh0dHBzOi8vZWRpdG9yY29uZmlnLm9yZy8jZmlsZS1mb3JtYXQtZGV0YWlsc1xuICAgIG5ldyBJbmlGaWxlKHRoaXMsIFwiLmVkaXRvcmNvbmZpZ1wiLCB7XG4gICAgICBvYmo6IHtcbiAgICAgICAgW1wicm9vdFwiXTogdHJ1ZSxcbiAgICAgICAgW1wiKlwiXToge1xuICAgICAgICAgIFtcImVuZF9vZl9saW5lXCJdOiBcImxmXCIsXG4gICAgICAgICAgW1wiY2hhcnNldFwiXTogXCJ1dGYtOFwiLFxuICAgICAgICB9LFxuICAgICAgICBbXCIqLntqcyx0c31cIl06IHtcbiAgICAgICAgICBbXCJpbmRlbnRfc3R5bGVcIl06IFwic3BhY2VcIixcbiAgICAgICAgICBbXCJpbmRlbnRfc2l6ZVwiXTogMixcbiAgICAgICAgICBbXCJtYXhfbGluZV9sZW5ndGhcIl06IDEyMCxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICBtYXJrZXI6IHRydWUsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==