import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultTransformEncodeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a list of items to be encoded in a single batch. If this parameter is set, the parameters 'value', 'transformation' and 'tweak' will be ignored. Each batch item within the list can specify these parameters instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#batch_input DataVaultTransformEncode#batch_input}
    */
    readonly batchInput?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * The result of encoding batch_input.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#batch_results DataVaultTransformEncode#batch_results}
    */
    readonly batchResults?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
    * The result of encoding a value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#encoded_value DataVaultTransformEncode#encoded_value}
    */
    readonly encodedValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#id DataVaultTransformEncode#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Path to backend from which to retrieve data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#path DataVaultTransformEncode#path}
    */
    readonly path: string;
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#role_name DataVaultTransformEncode#role_name}
    */
    readonly roleName: string;
    /**
    * The transformation to perform. If no value is provided and the role contains a single transformation, this value will be inferred from the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#transformation DataVaultTransformEncode#transformation}
    */
    readonly transformation?: string;
    /**
    * The tweak value to use. Only applicable for FPE transformations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#tweak DataVaultTransformEncode#tweak}
    */
    readonly tweak?: string;
    /**
    * The value in which to encode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transform_encode#value DataVaultTransformEncode#value}
    */
    readonly value?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/transform_encode vault_transform_encode}
*/
export declare class DataVaultTransformEncode extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_transform_encode";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/transform_encode vault_transform_encode} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultTransformEncodeConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultTransformEncodeConfig);
    private _batchInput?;
    get batchInput(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set batchInput(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetBatchInput(): void;
    get batchInputInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _batchResults?;
    get batchResults(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set batchResults(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    resetBatchResults(): void;
    get batchResultsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _encodedValue?;
    get encodedValue(): string;
    set encodedValue(value: string);
    resetEncodedValue(): void;
    get encodedValueInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _transformation?;
    get transformation(): string;
    set transformation(value: string);
    resetTransformation(): void;
    get transformationInput(): string | undefined;
    private _tweak?;
    get tweak(): string;
    set tweak(value: string);
    resetTweak(): void;
    get tweakInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
