import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityEntityAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the entity to which this is an alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#canonical_id IdentityEntityAlias#canonical_id}
    */
    readonly canonicalId: string;
    /**
    * Custom metadata to be associated with this alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#custom_metadata IdentityEntityAlias#custom_metadata}
    */
    readonly customMetadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#id IdentityEntityAlias#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Mount accessor to which this alias belongs toMount accessor to which this alias belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#mount_accessor IdentityEntityAlias#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the entity alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#name IdentityEntityAlias#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#namespace IdentityEntityAlias#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias vault_identity_entity_alias}
*/
export declare class IdentityEntityAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_entity_alias";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias vault_identity_entity_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityEntityAliasConfig
    */
    constructor(scope: Construct, id: string, config: IdentityEntityAliasConfig);
    private _canonicalId?;
    get canonicalId(): string;
    set canonicalId(value: string);
    get canonicalIdInput(): string | undefined;
    private _customMetadata?;
    get customMetadata(): {
        [key: string]: string;
    };
    set customMetadata(value: {
        [key: string]: string;
    });
    resetCustomMetadata(): void;
    get customMetadataInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
